/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader.paygate;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.tradedata.PaygateTradeData;
import io.github.lightman314.lightmanscurrency.integration.computercraft.data.LCLuaTable;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader.TradeWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraftforge.registries.ForgeRegistries;

public class PaygateTradeWrapper
extends TradeWrapper<PaygateTradeData> {
    public PaygateTradeWrapper(Supplier<PaygateTradeData> tradeSource, Supplier<TraderData> trader) {
        super(tradeSource, trader);
    }

    public String getType() {
        return "lc_trade_paygate";
    }

    @Override
    @LuaFunction(mainThread=true)
    public LCLuaTable getPrice() throws LuaException {
        PaygateTradeData trade = (PaygateTradeData)this.getTrade();
        if (trade.isTicketTrade()) {
            LCLuaTable table = new LCLuaTable();
            table.put("TicketID", trade.getTicketID());
            table.put("TicketColor", Integer.toHexString(trade.getTicketColor()));
            table.put("TicketItem", ForgeRegistries.ITEMS.getKey((Object)trade.getTicketItem()).toString());
            return table;
        }
        return super.getPrice();
    }

    @LuaFunction(mainThread=true)
    public boolean storesTicketStubs() throws LuaException {
        return ((PaygateTradeData)this.getTrade()).shouldStoreTicketStubs();
    }

    @LuaFunction(mainThread=true)
    public LCLuaTable getDuration() throws LuaException {
        int duration = ((PaygateTradeData)this.getTrade()).getDuration();
        LCLuaTable table = new LCLuaTable();
        table.put("ticks", duration);
        table.put("text", PaygateTradeData.formatDurationDisplay(duration));
        return table;
    }

    @LuaFunction(mainThread=true)
    public int getRedstoneLevel() throws LuaException {
        return ((PaygateTradeData)this.getTrade()).getRedstoneLevel();
    }

    @LuaFunction(mainThread=true)
    public String getDescription() throws LuaException {
        return ((PaygateTradeData)this.getTrade()).getDescription();
    }

    @LuaFunction(mainThread=true)
    public String[] getTooltip() throws LuaException {
        String tooltip = ((PaygateTradeData)this.getTrade()).getTooltip();
        if (tooltip.isBlank()) {
            return new String[0];
        }
        ArrayList<String> lines = new ArrayList<String>(Arrays.asList(tooltip.split("\\\\n")));
        return (String[])lines.toArray(String[]::new);
    }

    @LuaFunction(mainThread=true)
    public LCLuaTable getOutputSides() throws LuaException {
        PaygateTradeData trade = (PaygateTradeData)this.getTrade();
        LCLuaTable table = new LCLuaTable();
        for (Direction side : Direction.values()) {
            table.put(side.toString(), trade.allowOutputSide(side));
        }
        return table;
    }
}

