/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader.gacha_machine;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.GachaMachineBlockEntity;
import io.github.lightman314.lightmanscurrency.common.traders.gacha.GachaStorage;
import io.github.lightman314.lightmanscurrency.common.traders.gacha.GachaTrader;
import io.github.lightman314.lightmanscurrency.integration.computercraft.data.LCLuaTable;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader.TraderPeripheral;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;

public class GachaMachinePeripheral
extends TraderPeripheral<GachaMachineBlockEntity, GachaTrader> {
    public GachaMachinePeripheral(GachaMachineBlockEntity gachaMachineBlockEntity) {
        super(gachaMachineBlockEntity);
    }

    public GachaMachinePeripheral(GachaTrader trader) {
        super(trader);
    }

    @Override
    @Nullable
    protected IPeripheral wrapTrade(TradeData trade) throws LuaException {
        return this;
    }

    public String getType() {
        return "lc_trader_gacha";
    }

    @LuaFunction(mainThread=true)
    public int getStorageCount() throws LuaException {
        return ((GachaTrader)this.getTrader()).getStorage().getItemCount();
    }

    @LuaFunction(mainThread=true)
    public int getStorageCapacity() throws LuaException {
        return ((GachaTrader)this.getTrader()).getMaxItems();
    }

    @LuaFunction(mainThread=true)
    public LCLuaTable[] getStorageItems() throws LuaException {
        GachaStorage storage = ((GachaTrader)this.getTrader()).getStorage();
        ArrayList<LCLuaTable> list = new ArrayList<LCLuaTable>();
        for (ItemStack item : new ArrayList<ItemStack>(storage.getContents())) {
            list.add(LCLuaTable.fromTag(InventoryUtil.saveItemNoLimits(item)));
        }
        return (LCLuaTable[])list.toArray(LCLuaTable[]::new);
    }

    @LuaFunction(mainThread=true)
    public LCLuaTable getPrice() throws LuaException {
        return LCLuaTable.fromMoney(((GachaTrader)this.getTrader()).getPrice());
    }
}

