/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blockentity.CapabilityInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blockentity.CashRegisterBlockEntity;
import io.github.lightman314.lightmanscurrency.integration.computercraft.data.LCLuaTable;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.MultiTraderPeripheral;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CashRegisterPeripheral
extends MultiTraderPeripheral {
    private final CashRegisterBlockEntity be;

    public CashRegisterPeripheral(CashRegisterBlockEntity be) {
        this.be = be;
    }

    public String getType() {
        return "lc_cash_register";
    }

    @Override
    @Nonnull
    protected List<TraderData> getAccessibleTraders() {
        return this.be.getTraders();
    }

    @Override
    protected boolean stillAccessible(TraderData trader) {
        return this.be.getTraders().contains(trader);
    }

    @LuaFunction(mainThread=true)
    public LCLuaTable[] getTraderPositions() {
        ArrayList<LCLuaTable> list = new ArrayList<LCLuaTable>();
        Level level = this.be.m_58904_();
        for (BlockPos pos : this.be.traderPositions()) {
            LCLuaTable entry = new LCLuaTable();
            entry.put("x", pos.m_123341_());
            entry.put("y", pos.m_123342_());
            entry.put("z", pos.m_123343_());
            list.add(entry);
        }
        return (LCLuaTable[])list.toArray(LCLuaTable[]::new);
    }

    @LuaFunction(mainThread=true)
    public void addTraderPosition(int x, int y, int z) throws LuaException {
        List<BlockPos> pos = this.be.traderPositions();
        BlockPos newPos = new BlockPos(x, y, z);
        BlockEntity newBE = this.be.m_58904_().m_7702_(newPos);
        if (newBE instanceof CapabilityInterfaceBlockEntity) {
            CapabilityInterfaceBlockEntity cbe = (CapabilityInterfaceBlockEntity)newBE;
            newBE = cbe.tryGetCoreBlockEntity();
        }
        if (!(newBE instanceof TraderBlockEntity)) {
            throw new LuaException("Cannot find a trader at " + x + " " + y + " " + z);
        }
        TraderBlockEntity tbe = (TraderBlockEntity)newBE;
        newPos = tbe.m_58899_();
        if (pos.contains(newPos)) {
            throw new LuaException("Cannot add " + x + " " + y + " " + z + " as it's already in the list of positions!");
        }
        pos.add(newPos);
        this.be.setPositions(pos);
    }

    @LuaFunction(mainThread=true)
    public void removeTraderPosition(int x, int y, int z) throws LuaException {
        BlockPos deletePos;
        List<BlockPos> pos = this.be.traderPositions();
        if (!pos.contains(deletePos = new BlockPos(x, y, z))) {
            throw new LuaException("Cannot remove " + x + " " + y + " " + z + " as it's not on the list of positions!");
        }
        pos.remove(deletePos);
        this.be.setPositions(pos);
    }

    @LuaFunction(mainThread=true)
    public String getCustomTitle() {
        Component title = this.be.getCustomTitle();
        return title == null ? "" : title.getString();
    }

    @LuaFunction
    public void setCustomTitle(String newTitle) {
        if (newTitle.isBlank()) {
            this.be.setCustomTitle(null);
        } else {
            this.be.setCustomTitle((Component)EasyText.literal(newTitle));
        }
    }

    @Override
    public boolean equals(@Nullable IPeripheral peripheral) {
        if (peripheral instanceof CashRegisterPeripheral) {
            CashRegisterPeripheral other = (CashRegisterPeripheral)peripheral;
            return other.be == this.be && super.equals(peripheral);
        }
        return false;
    }
}

