/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.upgrades.types.capacity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.upgrades.UpgradeData;
import io.github.lightman314.lightmanscurrency.common.items.UpgradeItem;
import io.github.lightman314.lightmanscurrency.common.upgrades.Upgrades;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.capacity.CapacityUpgrade;
import io.github.lightman314.lightmanscurrency.util.NumberUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class TradeOfferUpgrade
extends CapacityUpgrade {
    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    @Nonnull
    public List<Component> getTooltip(@Nonnull UpgradeData data) {
        return Lists.newArrayList((Object[])new Component[]{LCText.TOOLTIP_UPGRADE_TRADE_OFFER.get(NumberUtil.GetPrettyString(data.getIntValue(CapacityUpgrade.CAPACITY)))});
    }

    @Override
    @Nonnull
    protected List<Component> getBuiltInTargets() {
        return ImmutableList.of((Object)LCText.TOOLTIP_UPGRADE_TARGET_TRADER_ITEM.get(new Object[0]));
    }

    public static int getBonusTrades(@Nonnull Container upgradeContainer) {
        int count = 0;
        for (int i = 0; i < upgradeContainer.m_6643_(); ++i) {
            UpgradeItem item;
            Item item2;
            ItemStack stack = upgradeContainer.m_8020_(i);
            if (stack.m_41619_() || !((item2 = stack.m_41720_()) instanceof UpgradeItem) || (item = (UpgradeItem)item2).getUpgradeType() != Upgrades.TRADE_OFFERS) continue;
            count += UpgradeItem.getUpgradeData(stack).getIntValue(CapacityUpgrade.CAPACITY);
        }
        return count;
    }
}

