/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.rules;

import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public interface ITradeRuleHost {
    default public boolean allowTradeRule(TradeRule rule) {
        return true;
    }

    public boolean isTrader();

    public boolean isTrade();

    default public boolean canMoneyBeRelevant() {
        return true;
    }

    default public boolean isMoneyRelevant() {
        return this.canMoneyBeRelevant();
    }

    public void markTradeRulesDirty();

    public List<TradeRule> getRules();

    default public TradeRule getRuleOfType(ResourceLocation ruleType) {
        return TradeRule.GetTradeRule(this.getRules(), ruleType);
    }

    default public void validateRuleStates() {
        TradeRule.ValidateTradeRuleActiveStates(this.getRules());
    }

    default public void HandleRuleUpdate(Player player, ResourceLocation type, LazyPacketData updateData) {
        TradeRule rule = this.getRuleOfType(type);
        if (rule != null) {
            rule.receiveUpdateMessage(player, updateData);
            this.markTradeRulesDirty();
        }
    }
}

