/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.traderstorage.gacha;

import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.api.upgrades.slot.UpgradeInputSlot;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.gacha.GachaStorageClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.slots.easy.EasySlot;
import io.github.lightman314.lightmanscurrency.common.traders.gacha.GachaStorage;
import io.github.lightman314.lightmanscurrency.common.traders.gacha.GachaTrader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GachaStorageTab
extends TraderStorageTab {
    List<EasySlot> slots = new ArrayList<EasySlot>();

    public GachaStorageTab(ITraderStorageMenu menu) {
        super(menu);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Object createClientTab(Object screen) {
        return new GachaStorageClientTab(screen, this);
    }

    @Override
    public boolean canOpen(Player player) {
        return true;
    }

    public List<? extends Slot> getSlots() {
        return this.slots;
    }

    @Override
    public void addStorageMenuSlots(Function<Slot, Slot> addSlot) {
        GachaTrader trader;
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof GachaTrader && !(trader = (GachaTrader)traderData).isPersistent()) {
            Container upgrades = trader.getUpgrades();
            for (int i = 0; i < upgrades.m_6643_(); ++i) {
                UpgradeInputSlot upgradeSlot = new UpgradeInputSlot(upgrades, i, 176, 18 + 18 * i, trader);
                upgradeSlot.active = false;
                addSlot.apply(upgradeSlot);
                this.slots.add(upgradeSlot);
            }
        }
    }

    @Override
    public void onTabOpen() {
        EasySlot.SetActive(this.slots);
    }

    @Override
    public void onTabClose() {
        EasySlot.SetInactive(this.slots);
    }

    @Override
    public boolean quickMoveStack(ItemStack stack) {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof GachaTrader) {
            GachaTrader trader = (GachaTrader)traderData;
            if (trader.isPersistent()) {
                return false;
            }
            GachaStorage storage = trader.getStorage();
            if (storage.getSpace() > 0) {
                storage.insertItem(stack);
                trader.markStorageDirty();
                return true;
            }
            return trader.quickInsertUpgrade(stack);
        }
        return super.quickMoveStack(stack);
    }

    public void clickedOnSlot(int storageSlot, boolean isShiftHeld, boolean leftClick) {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof GachaTrader) {
            GachaTrader trader = (GachaTrader)traderData;
            if (trader.isPersistent()) {
                return;
            }
            GachaStorage storage = trader.getStorage();
            ItemStack heldItem = ((ITraderStorageMenu)this.menu).getHeldItem();
            if (heldItem.m_41619_()) {
                List<ItemStack> storageContents = storage.getContents();
                if (storageSlot >= 0 && storageSlot < storageContents.size()) {
                    int removedAmount;
                    ItemStack stackToRemove = storageContents.get(storageSlot).m_41777_();
                    ItemStack removeStack = stackToRemove.m_41777_();
                    int tempAmount = Math.min(stackToRemove.m_41741_(), stackToRemove.m_41613_());
                    stackToRemove.m_41764_(tempAmount);
                    if (!leftClick) {
                        if (tempAmount > 1) {
                            tempAmount /= 2;
                        }
                        stackToRemove.m_41764_(tempAmount);
                    }
                    if (isShiftHeld) {
                        ((ITraderStorageMenu)this.menu).getPlayer().m_150109_().m_36054_(stackToRemove);
                        removedAmount = tempAmount - stackToRemove.m_41613_();
                    } else {
                        ((ITraderStorageMenu)this.menu).setHeldItem(stackToRemove);
                        removedAmount = tempAmount;
                    }
                    if (removedAmount > 0) {
                        removeStack.m_41764_(removedAmount);
                        storage.removeItem(storageSlot, removedAmount);
                        trader.markStorageDirty();
                    }
                }
            } else if (leftClick) {
                if (storage.insertItem(heldItem)) {
                    trader.markStorageDirty();
                }
            } else {
                ItemStack addItem = heldItem.m_41777_();
                addItem.m_41764_(1);
                if (storage.insertItem(addItem)) {
                    heldItem.m_41774_(1);
                    if (heldItem.m_41619_()) {
                        ((ITraderStorageMenu)this.menu).setHeldItem(ItemStack.f_41583_);
                    }
                }
                trader.markStorageDirty();
            }
            if (((ITraderStorageMenu)this.menu).isClient()) {
                this.sendStorageClickMessage(storageSlot, isShiftHeld, leftClick);
            }
        }
    }

    private void sendStorageClickMessage(int storageSlot, boolean isShiftHeld, boolean leftClick) {
        ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setInt("ClickedSlot", storageSlot).setBoolean("HeldShift", isShiftHeld).setBoolean("LeftClick", leftClick));
    }

    @Override
    public void receiveMessage(LazyPacketData message) {
        if (message.contains("ClickedSlot", (byte)2)) {
            int storageSlot = message.getInt("ClickedSlot");
            boolean isShiftHeld = message.getBoolean("HeldShift");
            boolean leftClick = message.getBoolean("LeftClick");
            this.clickedOnSlot(storageSlot, isShiftHeld, leftClick);
        }
    }
}

