/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus;

import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.items.data.FilterData;
import io.github.lightman314.lightmanscurrency.common.menus.LazyMessageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.providers.EasyMenuProvider;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkHooks;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ItemFilterMenu
extends LazyMessageMenu {
    private final int itemIndex;
    private Consumer<ItemStack> quickMoveConsumer = s -> {};

    public FilterData getData() {
        return FilterData.parse(this.getTargetedStack());
    }

    public ItemFilterMenu(int id, Inventory inventory, int itemIndex) {
        this(ModMenus.ITEM_FILTER.get(), id, inventory, itemIndex);
    }

    protected ItemFilterMenu(MenuType<?> type, int id, Inventory inventory, int itemIndex) {
        super(type, id, inventory);
        this.itemIndex = itemIndex;
        this.addValidator(() -> !this.getTargetedStack().m_41619_());
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                int index = x + y * 9 + 9;
                this.m_38897_(new Slot((Container)inventory, index, 8 + x * 18, 134 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)inventory, x, 8 + x * 18, 192));
        }
    }

    public final ItemStack getTargetedStack() {
        if (this.itemIndex < 0 || this.itemIndex >= this.inventory.m_6643_()) {
            return ItemStack.f_41583_;
        }
        return this.inventory.m_8020_(this.itemIndex);
    }

    public void setQuickMoveConsumer(Consumer<ItemStack> consumer) {
        this.quickMoveConsumer = consumer;
    }

    @Override
    public void HandleMessage(LazyPacketData message) {
        if (message.contains("MoveToSlot")) {
            this.quickMoveConsumer.accept(message.getItem("MoveToSlot"));
        }
        if (message.contains("AddEntry")) {
            this.editData(filter -> filter.addEntry(message.getResourceLocation("AddEntry")));
        }
        if (message.contains("RemoveEntry")) {
            this.editData(filter -> filter.removeEntry(message.getResourceLocation("RemoveEntry")));
        }
        if (message.contains("AddTag")) {
            this.editData(filter -> filter.addTag(message.getResourceLocation("AddTag")));
        }
        if (message.contains("RemoveTag")) {
            this.editData(filter -> filter.removeTag(message.getResourceLocation("RemoveTag")));
        }
    }

    protected final void editData(UnaryOperator<FilterData> action) {
        ItemStack target = this.getTargetedStack();
        if (target.m_41619_()) {
            this.player.m_6915_();
        } else {
            FilterData filter = FilterData.parse(target);
            FilterData newFilter = (FilterData)action.apply(filter);
            if (newFilter.equals(filter)) {
                return;
            }
            newFilter.write(target);
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack quickMove;
        if (this.isClient()) {
            return ItemStack.f_41583_;
        }
        if (index >= 0 && index < this.f_38839_.size() && !(quickMove = ((Slot)this.f_38839_.get(index)).m_7993_()).m_41619_()) {
            this.SendMessage(this.builder().setItem("MoveToSlot", quickMove));
        }
        return ItemStack.f_41583_;
    }

    public static void OpenMenu(Player player, int itemIndex) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            NetworkHooks.openScreen((ServerPlayer)sp, (MenuProvider)new Provider(itemIndex), buf -> buf.writeInt(itemIndex));
        }
    }

    private record Provider(int itemIndex) implements EasyMenuProvider
    {
        @Nullable
        public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
            return new ItemFilterMenu(containerId, inventory, this.itemIndex);
        }
    }
}

