/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.filter.IItemTradeFilter;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.common.items.data.FilterData;
import io.github.lightman314.lightmanscurrency.common.menus.ItemFilterMenu;
import io.github.lightman314.lightmanscurrency.common.util.TooltipHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FilterItem
extends Item
implements IItemTradeFilter {
    public FilterItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack stack, @Nullable Level context, List<Component> tooltip, TooltipFlag flag) {
        List<Component> extraTooltips = this.getCustomTooltip(stack);
        if (extraTooltips != null) {
            tooltip.addAll(extraTooltips);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack heldItem = player.m_21120_(hand);
        if (!level.f_46443_) {
            int indexOfItem = -1;
            Inventory inv = player.m_150109_();
            for (int i = 0; i < inv.m_6643_() && indexOfItem < 0; ++i) {
                if (inv.m_8020_(i) != heldItem) continue;
                indexOfItem = i;
            }
            if (indexOfItem >= 0) {
                ItemFilterMenu.OpenMenu(player, indexOfItem);
            }
        }
        return InteractionResultHolder.m_19090_((Object)heldItem);
    }

    @Override
    @Nullable
    public Predicate<ItemStack> getFilter(ItemStack stack) {
        FilterData filter = FilterData.parse(stack);
        if (filter.isEmpty()) {
            return null;
        }
        return filter.asItemPredicate();
    }

    @Override
    public List<ItemStack> getDisplayableItems(ItemStack stack, @Nullable IItemHandler availableItems) {
        FilterData filter = FilterData.parse(stack);
        HashSet<Item> items = new HashSet<Item>();
        for (ResourceLocation entry : filter.entries()) {
            Item i2 = (Item)ForgeRegistries.ITEMS.getValue(entry);
            if (i2 == Items.f_41852_ || !FilterItem.shouldDisplayItem(i2, availableItems)) continue;
            items.add(i2);
        }
        for (ResourceLocation tag : filter.tags()) {
            TagKey tagKey = TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)tag);
            for (Item i3 : ForgeRegistries.ITEMS.tags().getTag(tagKey)) {
                if (i3 == Items.f_41852_ || !FilterItem.shouldDisplayItem(i3, availableItems)) continue;
                items.add(i3);
            }
        }
        return items.stream().map(i -> new ItemStack((ItemLike)i, stack.m_41613_())).toList();
    }

    @Override
    @Nullable
    public List<Component> getCustomTooltip(ItemStack stack) {
        boolean notFirst;
        FilterData filter = FilterData.parse(stack);
        if (filter.isEmpty()) {
            return null;
        }
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (!filter.entries().isEmpty()) {
            tooltip.add((Component)LCText.TOOLTIP_ITEM_TRADE_FILTER_ITEM_LABEL.getWithStyle(ChatFormatting.GOLD));
            MutableComponent itemLine = EasyText.empty();
            notFirst = false;
            for (ResourceLocation entry : filter.entries()) {
                Item item;
                if (notFirst) {
                    itemLine.m_7220_((Component)LCText.GUI_SEPERATOR.get(new Object[0]));
                }
                if ((item = (Item)ForgeRegistries.ITEMS.getValue(entry)) == Items.f_41852_) continue;
                itemLine.m_7220_(new ItemStack((ItemLike)item).m_41786_());
                notFirst = true;
            }
            tooltip.addAll(TooltipHelper.splitTooltips((Component)itemLine, new ChatFormatting[0]));
        }
        if (!filter.tags().isEmpty()) {
            tooltip.add((Component)LCText.TOOLTIP_ITEM_TRADE_FILTER_TAG_LABEL.getWithStyle(ChatFormatting.GOLD));
            MutableComponent tagLine = EasyText.empty();
            notFirst = false;
            for (ResourceLocation entry : filter.tags()) {
                if (notFirst) {
                    tagLine.m_7220_((Component)LCText.GUI_SEPERATOR.get(new Object[0]));
                }
                tagLine.m_130946_("#" + entry.toString());
                notFirst = true;
            }
            tooltip.addAll(TooltipHelper.splitTooltips((Component)tagLine, new ChatFormatting[0]));
        }
        return tooltip;
    }

    private static boolean shouldDisplayItem(Item item, @Nullable IItemHandler availableItems) {
        if (availableItems == null) {
            return true;
        }
        for (int i = 0; i < availableItems.getSlots(); ++i) {
            if (availableItems.getStackInSlot(i).m_41720_() != item) continue;
            return true;
        }
        return false;
    }
}

