/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CouponItem
extends Item {
    public CouponItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag tooltipFlag) {
        int uses = TicketItem.getUseCount(stack);
        if (uses > 0) {
            tooltip.add((Component)LCText.TOOLTIP_TICKET_USES.get(uses).m_130940_(ChatFormatting.GRAY));
        }
    }

    public static int GetCouponCode(ItemStack coupon) {
        CompoundTag tag = coupon.m_41783_();
        if (tag != null && tag.m_128441_("CouponCode")) {
            return tag.m_128451_("CouponCode");
        }
        return 0;
    }

    public static int GetCouponColor(ItemStack coupon) {
        if (coupon.m_41619_() || !(coupon.m_41720_() instanceof CouponItem)) {
            return 0xFFFFFF;
        }
        CompoundTag tag = coupon.m_41783_();
        if (tag == null || !tag.m_128441_("CouponColor")) {
            return 0xFFFFFF;
        }
        return tag.m_128451_("CouponColor");
    }

    public static ItemStack CreateCoupon(Item coupon, String code, int durability) {
        return CouponItem.CreateCoupon(coupon, code, durability, 0xFFFFFF);
    }

    public static ItemStack CreateCoupon(Item coupon, String code, int durability, int color) {
        ItemStack stack = new ItemStack((ItemLike)coupon);
        if (code.length() > 16) {
            code = code.substring(0, 16);
        }
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("CouponCode", code.hashCode());
        tag.m_128405_("CouponColor", color);
        LightmansCurrency.LogDebug("Crafted Coupon with code '" + code + "' and durability '" + durability + "'!");
        if (durability > 0) {
            TicketItem.setUseCount(stack, durability);
        }
        return stack;
    }
}

