/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.enchantments;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.common.EventHandler;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.IWalletHandler;
import io.github.lightman314.lightmanscurrency.common.core.ModEnchantments;
import io.github.lightman314.lightmanscurrency.common.enchantments.LCEnchantmentCategories;
import io.github.lightman314.lightmanscurrency.common.enchantments.WalletEnchantment;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.menus.wallet.WalletMenuBase;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class CoinMagnetEnchantment
extends WalletEnchantment {
    public CoinMagnetEnchantment(Enchantment.Rarity rarity, EquipmentSlot ... slots) {
        super(rarity, LCEnchantmentCategories.WALLET_PICKUP_CATEGORY, slots);
    }

    public int m_6183_(int level) {
        return 5 + (level - 1) * 8;
    }

    public int m_6175_(int level) {
        return super.m_6183_(level) + 50;
    }

    public int m_6586_() {
        return 3;
    }

    public static void runEntityTick(@Nonnull IWalletHandler walletHandler, @Nonnull LivingEntity entity) {
        if (entity.m_5833_()) {
            return;
        }
        ItemStack wallet = walletHandler.getWallet();
        if (!WalletItem.isWallet(wallet) || !WalletItem.CanPickup((WalletItem)wallet.m_41720_())) {
            return;
        }
        int enchantLevel = wallet.getEnchantmentLevel((Enchantment)ModEnchantments.COIN_MAGNET.get());
        if (enchantLevel <= 0) {
            return;
        }
        float range = CoinMagnetEnchantment.getCollectionRange(enchantLevel);
        Level level = entity.m_9236_();
        AABB searchBox = new AABB(entity.f_19854_ - (double)range, entity.f_19855_ - (double)range, entity.f_19856_ - (double)range, entity.f_19854_ + (double)range, entity.f_19855_ + (double)range, entity.f_19856_ + (double)range);
        boolean updateWallet = false;
        for (Entity e2 : level.m_6249_((Entity)entity, searchBox, e -> CoinMagnetEnchantment.coinMagnetEntityFilter(e, entity))) {
            ItemEntity ie = (ItemEntity)e2;
            ItemStack coinStack = ie.m_32055_();
            ItemStack leftovers = WalletItem.PickupCoin(wallet, coinStack);
            if (InventoryUtil.ItemsFullyMatch(leftovers, coinStack)) continue;
            updateWallet = true;
            if (leftovers.m_41619_()) {
                ie.m_146870_();
            } else {
                ie.m_32045_(leftovers);
            }
            WalletItem.playCollectSound(entity, wallet);
        }
        if (updateWallet) {
            walletHandler.setWallet(wallet);
            WalletMenuBase.OnWalletUpdated((Entity)entity);
        }
    }

    public static boolean coinMagnetEntityFilter(Entity entity, @Nonnull LivingEntity potentialPickup) {
        if (entity instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            if (!EventHandler.matchesTarget(item, (Entity)potentialPickup)) {
                return false;
            }
            return CoinAPI.API.IsAllowedInCoinContainer(item.m_32055_(), false);
        }
        return false;
    }

    public static float getCollectionRange(int enchantLevel) {
        if (--enchantLevel < 0) {
            return 0.0f;
        }
        return (Integer)LCConfig.SERVER.coinMagnetBaseRange.get() + (Integer)LCConfig.SERVER.coinMagnetLeveledRange.get() * Math.min(enchantLevel, (Integer)LCConfig.SERVER.coinMagnetCalculationCap.get());
    }

    public static Component getCollectionRangeDisplay(int enchantLevel) {
        float range = CoinMagnetEnchantment.getCollectionRange(enchantLevel);
        String display = range % 1.0f > 0.0f ? String.valueOf(range) : String.valueOf(Math.round(range));
        return Component.m_237113_((String)display).m_130940_(ChatFormatting.GREEN);
    }

    @Override
    public void addWalletTooltips(List<Component> tooltips, int enchantLevel, ItemStack wallet) {
        Item item = wallet.m_41720_();
        if (item instanceof WalletItem) {
            WalletItem wi = (WalletItem)item;
            if (enchantLevel > 0 && WalletItem.CanPickup(wi)) {
                tooltips.add((Component)LCText.TOOLTIP_WALLET_PICKUP_MAGNET.get(CoinMagnetEnchantment.getCollectionRangeDisplay(enchantLevel)).m_130940_(ChatFormatting.YELLOW));
            }
        }
    }
}

