/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.data.types;

import io.github.lightman314.lightmanscurrency.api.events.NotificationEvent;
import io.github.lightman314.lightmanscurrency.api.misc.data.CustomData;
import io.github.lightman314.lightmanscurrency.api.misc.data.CustomDataType;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationData;
import io.github.lightman314.lightmanscurrency.network.message.notifications.SPacketChatNotification;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.server.ServerLifecycleHooks;

@MethodsReturnNonnullByDefault
@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class NotificationDataCache
extends CustomData {
    public static final CustomDataType<NotificationDataCache> TYPE = new CustomDataType<NotificationDataCache>("lightmanscurrency_notification_data", NotificationDataCache::new);
    private final Map<UUID, NotificationData> playerNotifications = new HashMap<UUID, NotificationData>();

    private NotificationDataCache() {
    }

    @Override
    public CustomDataType<?> getType() {
        return TYPE;
    }

    @Override
    public void save(CompoundTag tag) {
        ListTag notificationData = new ListTag();
        this.playerNotifications.forEach((id, data) -> {
            CompoundTag entry = data.save();
            entry.m_128362_("Player", id);
            notificationData.add((Object)entry);
        });
        tag.m_128365_("PlayerNotifications", (Tag)notificationData);
    }

    @Override
    protected void load(CompoundTag tag) {
        ListTag notificationData = tag.m_128437_("PlayerNotifications", 10);
        for (int i = 0; i < notificationData.size(); ++i) {
            CompoundTag entry = notificationData.m_128728_(i);
            UUID id = entry.m_128342_("Player");
            NotificationData data = NotificationData.loadFrom(entry);
            if (id == null || data == null) continue;
            this.playerNotifications.put(id, data);
        }
    }

    public NotificationData getNotifications(Player player) {
        return this.getNotifications(player.m_20148_());
    }

    public NotificationData getNotifications(UUID player) {
        if (!this.playerNotifications.containsKey(player)) {
            this.playerNotifications.put(player, new NotificationData());
            this.setChanged();
        }
        return this.playerNotifications.get(player);
    }

    public void markNotificationsDirty(UUID player) {
        this.setChanged();
        if (this.isServer() && this.playerNotifications.containsKey(player)) {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server == null) {
                return;
            }
            ServerPlayer sp = server.m_6846_().m_11259_(player);
            if (sp == null) {
                return;
            }
            this.syncNotifications(sp);
        }
    }

    public void pushNotification(UUID player, Notification notification) {
        this.pushNotification(player, notification, true);
    }

    public void pushNotification(UUID player, Notification notification, boolean pushToChat) {
        ServerPlayer sp;
        MinecraftServer server;
        NotificationData data = this.getNotifications(player);
        NotificationEvent.NotificationSent.Pre event = new NotificationEvent.NotificationSent.Pre(player, data, notification);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        data.addNotification(event.getNotification());
        this.markNotificationsDirty(player);
        MinecraftForge.EVENT_BUS.post((Event)new NotificationEvent.NotificationSent.Post(player, data, event.getNotification()));
        if (pushToChat && (server = ServerLifecycleHooks.getCurrentServer()) != null && (sp = server.m_6846_().m_11259_(player)) != null) {
            new SPacketChatNotification(notification).sendTo(sp);
        }
    }

    private void syncNotifications(ServerPlayer player) {
        this.sendSyncPacket(this.builder().setCompound("UpdateNotifications", this.getNotifications((Player)player).save()).setUUID("Player", player.m_20148_()), player);
    }

    @Override
    protected void parseSyncPacket(LazyPacketData message) {
        if (message.contains("UpdateNotifications")) {
            NotificationData data = NotificationData.loadFrom(message.getNBT("UpdateNotifications")).flagAsClient(this);
            UUID player = message.getUUID("Player");
            this.playerNotifications.put(player, data);
        }
    }

    @Override
    public void onPlayerJoin(ServerPlayer player) {
        this.syncNotifications(player);
    }
}

