/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.LCTags;
import io.github.lightman314.lightmanscurrency.common.core.ModRecipes;
import io.github.lightman314.lightmanscurrency.common.core.variants.Color;
import io.github.lightman314.lightmanscurrency.common.crafting.TicketStationRecipe;
import io.github.lightman314.lightmanscurrency.common.crafting.durability.DurabilityData;
import io.github.lightman314.lightmanscurrency.common.crafting.input.TicketStationRecipeInput;
import io.github.lightman314.lightmanscurrency.common.items.CouponItem;
import io.github.lightman314.lightmanscurrency.common.menus.slots.ticket.TicketModifierSlot;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CouponRecipe
implements TicketStationRecipe {
    private final ResourceLocation id;
    private final Ingredient ingredient;
    private final Item result;
    private final DurabilityData durability;

    private ResourceLocation resultID() {
        return ForgeRegistries.ITEMS.getKey((Object)this.result);
    }

    public CouponRecipe(ResourceLocation id, Ingredient ingredient, Item result, Optional<DurabilityData> durabilityData) {
        this(id, ingredient, result, durabilityData.orElse(new DurabilityData(true, 0, 99)));
    }

    public CouponRecipe(ResourceLocation id, Ingredient ingredient, Item result, DurabilityData durability) {
        this.id = id;
        this.ingredient = ingredient;
        this.result = result;
        this.durability = durability;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Override
    public boolean consumeModifier() {
        return true;
    }

    @Override
    public List<ItemStack> jeiModifierList() {
        return TicketStationRecipe.exampleModifierList((TagKey<Item>)Tags.Items.DYES, Items.f_41852_);
    }

    @Override
    public Ingredient getIngredient() {
        return this.ingredient;
    }

    @Override
    public ItemStack exampleResult() {
        return CouponItem.CreateCoupon(this.result, "", 0);
    }

    @Override
    public boolean requiredCodeInput() {
        return true;
    }

    @Override
    public DurabilityData getDurabilityData() {
        return this.durability;
    }

    @Override
    public boolean validModifier(ItemStack stack) {
        return stack.m_41619_() || stack.m_204117_(Tags.Items.DYES);
    }

    @Override
    public boolean validIngredient(ItemStack stack) {
        return this.ingredient.test(stack);
    }

    public ItemStack assemble(TicketStationRecipeInput container, RegistryAccess lookup) {
        ItemStack dyeStack = container.m_8020_(0);
        Color dyeColor = TicketModifierSlot.getColorFromDye(dyeStack);
        int color = dyeColor == null ? 0xFFFFFF : dyeColor.hexColor;
        return CouponItem.CreateCoupon(this.result, container.data.code(), container.data.durability(), color);
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess lookup) {
        return CouponItem.CreateCoupon(this.result, "", 0);
    }

    @Override
    public ItemStack peekAtResult(Container container, TicketStationRecipe.ExtraData data) {
        ItemStack dyeStack = container.m_8020_(0);
        Color dyeColor = TicketModifierSlot.getColorFromDye(dyeStack);
        if (dyeColor != null) {
            return CouponItem.CreateCoupon(this.result, data.code(), data.durability(), dyeColor.hexColor);
        }
        return CouponItem.CreateCoupon(this.result, data.code(), data.durability());
    }

    @Override
    public boolean matchesTicketKioskSellItem(ItemStack sellItem) {
        return this.validIngredient(sellItem) && !InventoryUtil.ItemHasTag(sellItem, LCTags.Items.TICKETS_MASTER);
    }

    @Override
    public boolean allowIgnoreKioskRecipe() {
        return true;
    }

    @Override
    public ItemStack assembleWithKiosk(ItemStack sellItem, TicketStationRecipe.ExtraData data) {
        return CouponItem.CreateCoupon(this.result, data.code(), data.durability());
    }

    public RecipeSerializer<?> m_7707_() {
        return ModRecipes.COUPON.get();
    }

    public static class Serializer
    implements RecipeSerializer<CouponRecipe> {
        public CouponRecipe fromJson(ResourceLocation id, JsonObject json) {
            Ingredient ingredient = CraftingHelper.getIngredient((JsonElement)json.get("ingredient"), (boolean)false);
            Item result = CraftingHelper.getItem((String)GsonHelper.m_13906_((JsonObject)json, (String)"result"), (boolean)false);
            Optional<DurabilityData> durability = DurabilityData.parseValid(json, "durability");
            return new CouponRecipe(id, ingredient, result, durability);
        }

        @Nullable
        public CouponRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Item result = CraftingHelper.getItem((String)buffer.m_130277_(), (boolean)false);
            DurabilityData durability = DurabilityData.decode(buffer);
            return new CouponRecipe(id, ingredient, result, durability);
        }

        public void toNetwork(FriendlyByteBuf buffer, CouponRecipe recipe) {
            recipe.ingredient.m_43923_(buffer);
            buffer.m_130070_(recipe.resultID().toString());
            recipe.durability.encode(buffer);
        }
    }
}

