/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.core;

import com.google.common.base.Supplier;
import io.github.lightman314.lightmanscurrency.common.blocks.ATMBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.CashRegisterBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.CoinBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.CoinChestBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.CoinJarBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.CoinMintBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.CoinpileBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.MoneyBagBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.PaygateBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.TaxCollectorBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.TerminalBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.TicketStationBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.tradeinterface.ItemTraderInterfaceBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.ArmorDisplayBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.BookTraderBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.CardDisplayBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.CommandTraderBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.DisplayCaseBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.FreezerBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.GachaMachineBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.NetworkItemTraderBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.ShelfBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.SlotMachineBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.TicketKioskBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.VendingMachineBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.VendingMachineLargeBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.reference.AuctionStandBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModRegistries;
import io.github.lightman314.lightmanscurrency.common.core.groups.RegistryObjectBiBundle;
import io.github.lightman314.lightmanscurrency.common.core.groups.RegistryObjectBundle;
import io.github.lightman314.lightmanscurrency.common.core.variants.Color;
import io.github.lightman314.lightmanscurrency.common.core.variants.WoodType;
import io.github.lightman314.lightmanscurrency.common.items.CashRegisterItem;
import io.github.lightman314.lightmanscurrency.common.items.CoinJarItem;
import io.github.lightman314.lightmanscurrency.common.items.CommandTraderItem;
import io.github.lightman314.lightmanscurrency.common.items.CustomBlockModelItem;
import io.github.lightman314.lightmanscurrency.common.items.MoneyBagItem;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    private static final SoundType CHOCOLATE_SOUND = SoundType.f_222470_;
    public static final RegistryObject<Block> COINPILE_COPPER = ModBlocks.register("coinpile_copper", ModBlocks.getCoinGenerator(false), () -> new CoinpileBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283750_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_)));
    public static final RegistryObject<Block> COINPILE_IRON = ModBlocks.register("coinpile_iron", ModBlocks.getCoinGenerator(false), () -> new CoinpileBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_)));
    public static final RegistryObject<Block> COINPILE_GOLD = ModBlocks.register("coinpile_gold", ModBlocks.getCoinGenerator(false), () -> new CoinpileBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283757_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_)));
    public static final RegistryObject<Block> COINPILE_DIAMOND;
    public static final RegistryObject<Block> COINPILE_EMERALD;
    public static final RegistryObject<Block> COINPILE_NETHERITE;
    public static final RegistryObject<Block> COINPILE_CHOCOLATE_COPPER;
    public static final RegistryObject<Block> COINPILE_CHOCOLATE_IRON;
    public static final RegistryObject<Block> COINPILE_CHOCOLATE_GOLD;
    public static final RegistryObject<Block> COINPILE_CHOCOLATE_DIAMOND;
    public static final RegistryObject<Block> COINPILE_CHOCOLATE_EMERALD;
    public static final RegistryObject<Block> COINPILE_CHOCOLATE_NETHERITE;
    public static final RegistryObject<Block> COINBLOCK_COPPER;
    public static final RegistryObject<Block> COINBLOCK_IRON;
    public static final RegistryObject<Block> COINBLOCK_GOLD;
    public static final RegistryObject<Block> COINBLOCK_EMERALD;
    public static final RegistryObject<Block> COINBLOCK_DIAMOND;
    public static final RegistryObject<Block> COINBLOCK_NETHERITE;
    public static final RegistryObject<Block> COINBLOCK_CHOCOLATE_COPPER;
    public static final RegistryObject<Block> COINBLOCK_CHOCOLATE_IRON;
    public static final RegistryObject<Block> COINBLOCK_CHOCOLATE_GOLD;
    public static final RegistryObject<Block> COINBLOCK_CHOCOLATE_EMERALD;
    public static final RegistryObject<Block> COINBLOCK_CHOCOLATE_DIAMOND;
    public static final RegistryObject<Block> COINBLOCK_CHOCOLATE_NETHERITE;
    public static final RegistryObject<Block> ATM;
    public static final RegistryObject<Block> COIN_MINT;
    public static final RegistryObjectBundle<Block, Color> DISPLAY_CASE;
    public static final RegistryObjectBundle<Block, Color> VENDING_MACHINE;
    public static final RegistryObjectBundle<Block, Color> VENDING_MACHINE_LARGE;
    public static final RegistryObjectBundle<Block, WoodType> SHELF;
    public static final RegistryObjectBundle<Block, WoodType> SHELF_2x2;
    public static final RegistryObjectBiBundle<Block, WoodType, Color> CARD_DISPLAY;
    public static final RegistryObject<Block> ARMOR_DISPLAY;
    public static final RegistryObjectBundle<FreezerBlock, Color> FREEZER;
    public static final RegistryObject<Block> ITEM_NETWORK_TRADER_1;
    public static final RegistryObject<Block> ITEM_NETWORK_TRADER_2;
    public static final RegistryObject<Block> ITEM_NETWORK_TRADER_3;
    public static final RegistryObject<Block> ITEM_NETWORK_TRADER_4;
    public static final RegistryObject<Block> ITEM_TRADER_INTERFACE;
    public static final RegistryObject<Block> CASH_REGISTER;
    public static final RegistryObject<Block> TERMINAL;
    public static final RegistryObject<Block> GEM_TERMINAL;
    public static final RegistryObject<Block> PAYGATE;
    public static final RegistryObject<Block> TICKET_KIOSK;
    public static final RegistryObjectBundle<Block, WoodType> BOOKSHELF_TRADER;
    public static final RegistryObject<Block> SLOT_MACHINE;
    public static final RegistryObjectBundle<Block, Color> GACHA_MACHINE;
    public static final RegistryObject<Block> COMMAND_TRADER;
    public static final RegistryObject<Block> TICKET_STATION;
    public static final RegistryObject<Block> COIN_CHEST;
    public static final RegistryObject<Block> TAX_COLLECTOR;
    public static final RegistryObject<Block> MONEY_BAG;
    public static final RegistryObject<Block> PIGGY_BANK;
    public static final RegistryObject<Block> COINJAR_BLUE;
    public static final RegistryObject<Block> SUS_JAR;
    public static final RegistryObjectBundle<Block, WoodType> AUCTION_STAND;

    public static void init() {
    }

    private static Function<Block, Item> getDefaultGenerator() {
        return block -> new BlockItem(block, new Item.Properties());
    }

    private static Function<Block, Item> getCoinGenerator(boolean fireResistant) {
        return block -> {
            Item.Properties properties = new Item.Properties();
            if (fireResistant) {
                properties.m_41486_();
            }
            return new BlockItem(block, properties);
        };
    }

    private static Function<Block, Item> getCoinJarGenerator() {
        return block -> new CoinJarItem((Block)block, new Item.Properties());
    }

    private static Function<Block, Item> getColoredCoinJarGenerator() {
        return block -> new CoinJarItem.Colored((Block)block, new Item.Properties());
    }

    private static Function<Block, Item> getMoneyBagGenerator() {
        return block -> new MoneyBagItem((Block)block, new Item.Properties());
    }

    private static Function<Block, Item> getCustomRendererGenerator() {
        return block -> new CustomBlockModelItem((Block)block, new Item.Properties());
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<T> sup) {
        return ModBlocks.register(name, ModBlocks.getDefaultGenerator(), sup);
    }

    private static <T extends Block> RegistryObject<T> register(String name, Function<Block, Item> itemGenerator, Supplier<T> sup) {
        RegistryObject block = ModRegistries.BLOCKS.register(name, sup);
        if (block != null) {
            ModRegistries.ITEMS.register(name, () -> (Item)itemGenerator.apply((Block)block.get()));
        }
        return block;
    }

    private static <T extends Block> RegistryObjectBundle<T, Color> registerColored(String name, Function<Color, T> block) {
        return ModBlocks.registerColored(name, block, null);
    }

    private static <T extends Block> RegistryObjectBundle<T, Color> registerColored(String name, Function<Color, T> block, @Nullable Color dontNameThisColor) {
        return ModBlocks.registerColored(name, ModBlocks.getDefaultGenerator(), block, dontNameThisColor);
    }

    private static <T extends Block> RegistryObjectBundle<T, Color> registerColored(String name, Function<Block, Item> itemGenerator, Function<Color, T> block, @Nullable Color dontNameThisColor) {
        RegistryObjectBundle<T, Color> bundle = new RegistryObjectBundle<T, Color>(Color::sortByColor);
        for (Color color : Color.values()) {
            Object thisName = name;
            if (color != dontNameThisColor) {
                thisName = (String)thisName + "_" + color.getResourceSafeName();
            }
            bundle.put(color, ModBlocks.register((String)thisName, itemGenerator, () -> (Block)block.apply(color)));
        }
        return bundle.lock();
    }

    private static <T extends Block> RegistryObjectBundle<T, WoodType> registerWooden(String name, Predicate<WoodType.Attributes> check, Function<WoodType, T> block) {
        return ModBlocks.registerWooden(name, check, ModBlocks.getDefaultGenerator(), block);
    }

    private static <T extends Block> RegistryObjectBundle<T, WoodType> registerWooden(String name, Predicate<WoodType.Attributes> check, Function<Block, Item> itemGenerator, Function<WoodType, T> block) {
        RegistryObjectBundle<T, WoodType> bundle = new RegistryObjectBundle<T, WoodType>(WoodType::sortByWood);
        for (WoodType woodType : WoodType.validValues()) {
            if (!check.test(woodType.attributes)) continue;
            String thisName = woodType.generateID(name);
            bundle.put(woodType, ModBlocks.register(thisName, itemGenerator, () -> (Block)block.apply(woodType)));
        }
        return bundle.lock();
    }

    private static <T extends Block> RegistryObjectBiBundle<T, WoodType, Color> registerWoodenAndColored(String name, Predicate<WoodType.Attributes> check, BiFunction<WoodType, Color, T> block) {
        return ModBlocks.registerWoodenAndColored(name, check, block, null);
    }

    private static <T extends Block> RegistryObjectBiBundle<T, WoodType, Color> registerWoodenAndColored(String name, Predicate<WoodType.Attributes> check, BiFunction<WoodType, Color, T> block, @Nullable Color ignoreColor) {
        return ModBlocks.registerWoodenAndColored(name, check, ModBlocks.getDefaultGenerator(), block, ignoreColor);
    }

    private static <T extends Block> RegistryObjectBiBundle<T, WoodType, Color> registerWoodenAndColored(String name, Predicate<WoodType.Attributes> check, Function<Block, Item> itemGenerator, BiFunction<WoodType, Color, T> block) {
        return ModBlocks.registerWoodenAndColored(name, check, itemGenerator, block, null);
    }

    private static <T extends Block> RegistryObjectBiBundle<T, WoodType, Color> registerWoodenAndColored(String name, Predicate<WoodType.Attributes> check, Function<Block, Item> itemGenerator, BiFunction<WoodType, Color, T> block, @Nullable Color ignoreColor) {
        RegistryObjectBiBundle<T, WoodType, Color> bundle = new RegistryObjectBiBundle<T, WoodType, Color>(WoodType::sortByWood, Color::sortByColor);
        for (WoodType woodType : WoodType.validValues()) {
            if (!check.test(woodType.attributes)) continue;
            for (Color color : Color.values()) {
                Object thisName = color == ignoreColor ? woodType.generateID(name) : woodType.generateID(name) + "_" + color.getResourceSafeName();
                bundle.put(woodType, color, ModBlocks.register((String)thisName, itemGenerator, () -> (Block)block.apply(woodType, color)));
            }
        }
        return bundle.lock();
    }

    static {
        COINPILE_EMERALD = ModBlocks.register("coinpile_emerald", ModBlocks.getCoinGenerator(false), () -> new CoinpileBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283812_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_)));
        COINPILE_DIAMOND = ModBlocks.register("coinpile_diamond", ModBlocks.getCoinGenerator(false), () -> new CoinpileBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283821_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_)));
        COINPILE_NETHERITE = ModBlocks.register("coinpile_netherite", ModBlocks.getCoinGenerator(true), () -> new CoinpileBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283927_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_)));
        COINPILE_CHOCOLATE_COPPER = ModBlocks.register("coinpile_chocolate_copper", ModBlocks.getCoinGenerator(false), () -> new CoinpileBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283750_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_222469_)));
        COINPILE_CHOCOLATE_IRON = ModBlocks.register("coinpile_chocolate_iron", ModBlocks.getCoinGenerator(false), () -> new CoinpileBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(3.0f, 6.0f).m_60918_(CHOCOLATE_SOUND)));
        COINPILE_CHOCOLATE_GOLD = ModBlocks.register("coinpile_chocolate_gold", ModBlocks.getCoinGenerator(false), () -> new CoinpileBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283757_).m_60913_(3.0f, 6.0f).m_60918_(CHOCOLATE_SOUND)));
        COINPILE_CHOCOLATE_EMERALD = ModBlocks.register("coinpile_chocolate_emerald", ModBlocks.getCoinGenerator(false), () -> new CoinpileBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283812_).m_60913_(3.0f, 6.0f).m_60918_(CHOCOLATE_SOUND)));
        COINPILE_CHOCOLATE_DIAMOND = ModBlocks.register("coinpile_chocolate_diamond", ModBlocks.getCoinGenerator(false), () -> new CoinpileBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283821_).m_60913_(3.0f, 6.0f).m_60918_(CHOCOLATE_SOUND)));
        COINPILE_CHOCOLATE_NETHERITE = ModBlocks.register("coinpile_chocolate_netherite", ModBlocks.getCoinGenerator(true), () -> new CoinpileBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283927_).m_60913_(3.0f, 6.0f).m_60918_(CHOCOLATE_SOUND)));
        COINBLOCK_COPPER = ModBlocks.register("coinblock_copper", ModBlocks.getCoinGenerator(false), () -> new CoinBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283750_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_)));
        COINBLOCK_IRON = ModBlocks.register("coinblock_iron", ModBlocks.getCoinGenerator(false), () -> new CoinBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_)));
        COINBLOCK_GOLD = ModBlocks.register("coinblock_gold", ModBlocks.getCoinGenerator(false), () -> new CoinBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283757_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_)));
        COINBLOCK_EMERALD = ModBlocks.register("coinblock_emerald", ModBlocks.getCoinGenerator(false), () -> new CoinBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283812_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_)));
        COINBLOCK_DIAMOND = ModBlocks.register("coinblock_diamond", ModBlocks.getCoinGenerator(false), () -> new CoinBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283821_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_)));
        COINBLOCK_NETHERITE = ModBlocks.register("coinblock_netherite", ModBlocks.getCoinGenerator(true), () -> new CoinBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283927_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_)));
        COINBLOCK_CHOCOLATE_COPPER = ModBlocks.register("coinblock_chocolate_copper", ModBlocks.getCoinGenerator(false), () -> new CoinBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283750_).m_60913_(3.0f, 6.0f).m_60918_(CHOCOLATE_SOUND)));
        COINBLOCK_CHOCOLATE_IRON = ModBlocks.register("coinblock_chocolate_iron", ModBlocks.getCoinGenerator(false), () -> new CoinBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(3.0f, 6.0f).m_60918_(CHOCOLATE_SOUND)));
        COINBLOCK_CHOCOLATE_GOLD = ModBlocks.register("coinblock_chocolate_gold", ModBlocks.getCoinGenerator(false), () -> new CoinBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283757_).m_60913_(3.0f, 6.0f).m_60918_(CHOCOLATE_SOUND)));
        COINBLOCK_CHOCOLATE_EMERALD = ModBlocks.register("coinblock_chocolate_emerald", ModBlocks.getCoinGenerator(false), () -> new CoinBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283812_).m_60913_(3.0f, 6.0f).m_60918_(CHOCOLATE_SOUND)));
        COINBLOCK_CHOCOLATE_DIAMOND = ModBlocks.register("coinblock_chocolate_diamond", ModBlocks.getCoinGenerator(false), () -> new CoinBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283821_).m_60913_(3.0f, 6.0f).m_60918_(CHOCOLATE_SOUND)));
        COINBLOCK_CHOCOLATE_NETHERITE = ModBlocks.register("coinblock_chocolate_netherite", ModBlocks.getCoinGenerator(true), () -> new CoinBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283927_).m_60913_(3.0f, 6.0f).m_60918_(CHOCOLATE_SOUND)));
        ATM = ModBlocks.register("atm", () -> new ATMBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283818_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_)));
        COIN_MINT = ModBlocks.register("coinmint", () -> new CoinMintBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283869_).m_60913_(2.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)));
        CASH_REGISTER = ModBlocks.register("cash_register", block -> new CashRegisterItem((Block)block, new Item.Properties()), () -> new CashRegisterBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283818_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0)));
        DISPLAY_CASE = ModBlocks.registerColored("display_case", c -> new DisplayCaseBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56744_), (Color)((Object)c)), Color.WHITE);
        VENDING_MACHINE = ModBlocks.registerColored("vending_machine", c -> new VendingMachineBlock(BlockBehaviour.Properties.m_284310_().m_284180_(c.mapColor).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)), Color.WHITE);
        VENDING_MACHINE_LARGE = ModBlocks.registerColored("vending_machine_large", c -> new VendingMachineLargeBlock(BlockBehaviour.Properties.m_284310_().m_284180_(c.mapColor).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)), Color.WHITE);
        SHELF = ModBlocks.registerWooden("shelf", WoodType.Attributes.needsSlab, w -> new ShelfBlock(BlockBehaviour.Properties.m_284310_().m_284180_(w.mapColor).m_60913_(2.0f, Float.POSITIVE_INFINITY)));
        SHELF_2x2 = ModBlocks.registerWooden("shelf_2x2", WoodType.Attributes.needsSlab, w -> new ShelfBlock(BlockBehaviour.Properties.m_284310_().m_284180_(w.mapColor).m_60913_(2.0f, Float.POSITIVE_INFINITY), 4));
        CARD_DISPLAY = ModBlocks.registerWoodenAndColored("card_display", WoodType.Attributes.needsLog, (WoodType w, Color c) -> new CardDisplayBlock(BlockBehaviour.Properties.m_284310_().m_284180_(w.mapColor).m_60913_(2.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56736_), w.generateID("block.lightmanscurrency.card_display"), (Color)((Object)c)), Color.RED);
        FREEZER = ModBlocks.registerColored("freezer", c -> new FreezerBlock(BlockBehaviour.Properties.m_284310_().m_284180_(c.mapColor).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_), FreezerBlock.GenerateDoorModel(c)), Color.BLACK);
        ARMOR_DISPLAY = ModBlocks.register("armor_display", () -> new ArmorDisplayBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)));
        TICKET_KIOSK = ModBlocks.register("ticket_kiosk", () -> new TicketKioskBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(3.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)));
        BOOKSHELF_TRADER = ModBlocks.registerWooden("bookshelf_trader", WoodType.Attributes.needsPlanksAndSlab, w -> new BookTraderBlock(BlockBehaviour.Properties.m_284310_().m_284180_(w.mapColor).m_60913_(3.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56736_)));
        SLOT_MACHINE = ModBlocks.register("slot_machine", () -> new SlotMachineBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283832_).m_60913_(3.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)));
        GACHA_MACHINE = ModBlocks.registerColored("gacha_machine", c -> new GachaMachineBlock(BlockBehaviour.Properties.m_284310_().m_284180_(c.mapColor).m_60913_(3.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_), (Color)((Object)c)));
        ITEM_NETWORK_TRADER_1 = ModBlocks.register("item_trader_server_sml", () -> new NetworkItemTraderBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_), 4));
        ITEM_NETWORK_TRADER_2 = ModBlocks.register("item_trader_server_med", () -> new NetworkItemTraderBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_), 8));
        ITEM_NETWORK_TRADER_3 = ModBlocks.register("item_trader_server_lrg", () -> new NetworkItemTraderBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_), 12));
        ITEM_NETWORK_TRADER_4 = ModBlocks.register("item_trader_server_xlrg", () -> new NetworkItemTraderBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_), 16));
        ITEM_TRADER_INTERFACE = ModBlocks.register("item_trader_interface", () -> new ItemTraderInterfaceBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)));
        TERMINAL = ModBlocks.register("terminal", () -> new TerminalBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0)));
        GEM_TERMINAL = ModBlocks.register("gem_terminal", () -> new TerminalBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283889_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_154655_), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0)));
        PAYGATE = ModBlocks.register("paygate", () -> new PaygateBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(3.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)));
        COMMAND_TRADER = ModBlocks.register("command_trader", b -> new CommandTraderItem((Block)b, new Item.Properties()), () -> new CommandTraderBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(3.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)));
        TICKET_STATION = ModBlocks.register("ticket_machine", () -> new TicketStationBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_)));
        COIN_CHEST = ModBlocks.register("coin_chest", ModBlocks.getCustomRendererGenerator(), () -> new CoinChestBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60913_(2.5f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56736_)));
        TAX_COLLECTOR = ModBlocks.register("tax_block", () -> new TaxCollectorBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(3.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)));
        MONEY_BAG = ModBlocks.register("money_bag", ModBlocks.getMoneyBagGenerator(), () -> new MoneyBagBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283761_).m_60913_(0.1f, 2.0f)));
        PIGGY_BANK = ModBlocks.register("piggy_bank", ModBlocks.getCoinJarGenerator(), () -> new CoinJarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283765_).m_60913_(0.1f, 2.0f).m_60918_(SoundType.f_56742_), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0)));
        COINJAR_BLUE = ModBlocks.register("coinjar_blue", ModBlocks.getCoinJarGenerator(), () -> new CoinJarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283743_).m_60913_(0.1f, 2.0f).m_60918_(SoundType.f_56742_), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0)));
        SUS_JAR = ModBlocks.register("sus_jar", ModBlocks.getColoredCoinJarGenerator(), () -> new CoinJarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283811_).m_60913_(0.1f, 2.0f).m_60918_(SoundType.f_56742_), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), true));
        AUCTION_STAND = ModBlocks.registerWooden("auction_stand", WoodType.Attributes.needsLog, w -> new AuctionStandBlock(BlockBehaviour.Properties.m_284310_().m_284180_(w.mapColor).m_60978_(2.0f)));
    }
}

