/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderState;
import io.github.lightman314.lightmanscurrency.api.traders.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.api.traders.blocks.ITraderBlock;
import io.github.lightman314.lightmanscurrency.common.capability.event_unlocks.CapabilityEventUnlocks;
import io.github.lightman314.lightmanscurrency.common.capability.event_unlocks.IEventUnlocks;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.IWalletHandler;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.WalletCapability;
import io.github.lightman314.lightmanscurrency.common.commands.arguments.ColorArgument;
import io.github.lightman314.lightmanscurrency.common.commands.arguments.MoneyValueArgument;
import io.github.lightman314.lightmanscurrency.common.commands.arguments.TraderArgument;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.data.types.EventRewardDataCache;
import io.github.lightman314.lightmanscurrency.common.data.types.TaxDataCache;
import io.github.lightman314.lightmanscurrency.common.items.GachaBallItem;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.SimpleValidator;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.taxes.TaxEntry;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.PlayerListing;
import io.github.lightman314.lightmanscurrency.integration.curios.LCCurios;
import io.github.lightman314.lightmanscurrency.network.message.command.SPacketDebugTrader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemHandlerHelper;

public class CommandLCAdmin {
    private static final SimpleCommandExceptionType ERROR_BLOCK_NOT_FOUND = new SimpleCommandExceptionType((Message)LCText.COMMAND_ADMIN_PREPARE_FOR_STRUCTURE_ERROR.get(new Object[0]));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        LiteralArgumentBuilder lcAdminCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"lcadmin").requires(stack -> stack.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"toggleadmin").requires(CommandSourceStack::m_230897_)).executes(CommandLCAdmin::toggleAdmin))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"traderdata").then(Commands.m_82127_((String)"list").executes(CommandLCAdmin::listTraderData))).then(Commands.m_82127_((String)"search").then(Commands.m_82129_((String)"searchText", (ArgumentType)StringArgumentType.greedyString()).executes(CommandLCAdmin::searchTraderData)))).then(Commands.m_82127_((String)"delete").then(Commands.m_82129_((String)"traderID", (ArgumentType)TraderArgument.trader()).executes(CommandLCAdmin::deleteTraderData)))).then(Commands.m_82127_((String)"debug").then(Commands.m_82129_((String)"traderID", (ArgumentType)TraderArgument.trader()).executes(CommandLCAdmin::debugTraderData)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"recover").requires(CommandSourceStack::m_230897_)).then(Commands.m_82129_((String)"traderID", (ArgumentType)TraderArgument.recoverableTrader()).executes(CommandLCAdmin::recoverTraderItem)))).then(Commands.m_82127_((String)"addToWhitelist").then(Commands.m_82129_((String)"traderID", (ArgumentType)TraderArgument.traderWithPersistent()).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).executes(CommandLCAdmin::addToTraderWhitelist)))))).then(Commands.m_82127_((String)"prepareForStructure").then(Commands.m_82129_((String)"traderPos", (ArgumentType)BlockPosArgument.m_118239_()).executes(CommandLCAdmin::setCustomTrader)))).then(Commands.m_82127_((String)"viewWallet").then(Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).executes(CommandLCAdmin::viewWalletSlot)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"replaceWallet").requires(c -> !LCCurios.isLoaded())).then(Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91460_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"wallet", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)context)).executes(CommandLCAdmin::replaceWalletSlotWithDefault)).then(Commands.m_82129_((String)"keepWalletContents", (ArgumentType)BoolArgumentType.bool()).executes(CommandLCAdmin::replaceWalletSlot)))))).then(Commands.m_82127_((String)"emptyWallet").then(Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91460_()).executes(CommandLCAdmin::emptyWallet)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"taxes").then(Commands.m_82127_((String)"list").executes(CommandLCAdmin::listTaxCollectors))).then(Commands.m_82127_((String)"delete").then(Commands.m_82129_((String)"taxCollectorID", (ArgumentType)LongArgumentType.longArg((long)0L)).executes(CommandLCAdmin::deleteTaxCollector)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"openServerTax").requires(CommandSourceStack::m_230897_)).executes(CommandLCAdmin::openServerTax))).then(Commands.m_82127_((String)"forceDisableTaxCollectors").executes(CommandLCAdmin::forceDisableTaxCollectors)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"events").then(Commands.m_82127_((String)"clearRewardCache").then(Commands.m_82129_((String)"eventID", (ArgumentType)StringArgumentType.greedyString()).executes(CommandLCAdmin::clearRewardCache)))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82127_((String)"list").executes(CommandLCAdmin::listUnlockedEvents))).then(Commands.m_82127_((String)"unlock").then(Commands.m_82129_((String)"event", (ArgumentType)StringArgumentType.word()).executes(CommandLCAdmin::unlockEvent)))).then(Commands.m_82127_((String)"lock").then(Commands.m_82129_((String)"event", (ArgumentType)StringArgumentType.word()).executes(CommandLCAdmin::lockEvent)))))).then(Commands.m_82127_((String)"makePrepaidCard").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"amount", (ArgumentType)MoneyValueArgument.argument(context)).executes(c -> CommandLCAdmin.createPrepaidCard((CommandContext<CommandSourceStack>)c, 0xFFFFFF))).then(Commands.m_82129_((String)"color", (ArgumentType)ColorArgument.argument()).executes(c -> CommandLCAdmin.createPrepaidCard((CommandContext<CommandSourceStack>)c, ColorArgument.getColor((CommandContext<CommandSourceStack>)c, "color")))))))).then(Commands.m_82127_((String)"debug").then(Commands.m_82127_((String)"makeGachaBall").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"contents", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)context)).executes(c -> CommandLCAdmin.createGachaBall((CommandContext<CommandSourceStack>)c, -1))).then(Commands.m_82129_((String)"color", (ArgumentType)ColorArgument.argument()).executes(c -> CommandLCAdmin.createGachaBall((CommandContext<CommandSourceStack>)c, ColorArgument.getColor((CommandContext<CommandSourceStack>)c, "color"))))))));
        dispatcher.register(lcAdminCommand);
    }

    static int toggleAdmin(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        ServerPlayer sourcePlayer = source.m_81375_();
        LCAdminMode.ToggleAdminPlayer(sourcePlayer);
        MutableComponent enabledDisabled = LCAdminMode.isAdminPlayer((Player)sourcePlayer) ? LCText.COMMAND_ADMIN_TOGGLE_ADMIN_ENABLED.getWithStyle(ChatFormatting.GREEN) : LCText.COMMAND_ADMIN_TOGGLE_ADMIN_DISABLED.getWithStyle(ChatFormatting.RED);
        EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TOGGLE_ADMIN.get(enabledDisabled), true);
        return 1;
    }

    static int setCustomTrader(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        BlockPos pos = BlockPosArgument.m_118242_(commandContext, (String)"traderPos");
        ServerLevel level = source.m_81372_();
        BlockState state = level.m_8055_(pos);
        BlockEntity be = state.m_60734_() instanceof ITraderBlock ? ((ITraderBlock)state.m_60734_()).getBlockEntity(state, (LevelAccessor)level, pos) : level.m_7702_(pos);
        if (be instanceof TraderBlockEntity) {
            TraderBlockEntity t = (TraderBlockEntity)be;
            t.saveCurrentTraderAsCustomTrader();
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_PREPARE_FOR_STRUCTURE_SUCCESS.get(new Object[0]), true);
            return 1;
        }
        throw ERROR_BLOCK_NOT_FOUND.create();
    }

    static int listTraderData(CommandContext<CommandSourceStack> commandContext) {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        List<TraderData> allTraders = TraderAPI.API.GetAllTraders(false);
        allTraders.sort(Comparator.comparingLong(TraderData::getID));
        if (!allTraders.isEmpty()) {
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TRADERDATA_LIST_TITLE.get(new Object[0]), true);
            for (int i = 0; i < allTraders.size(); ++i) {
                TraderData thisTrader = allTraders.get(i);
                if (i > 0) {
                    EasyText.sendCommandSucess(source, (Component)EasyText.empty(), true);
                }
                CommandLCAdmin.sendTraderDataFeedback(thisTrader, source);
            }
        } else {
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TRADERDATA_LIST_NONE.get(new Object[0]), true);
        }
        return 1;
    }

    static int searchTraderData(CommandContext<CommandSourceStack> commandContext) {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        String search = StringArgumentType.getString(commandContext, (String)"searchText");
        ArrayList<TraderData> results = new ArrayList<TraderData>(TraderAPI.API.GetAllTraders(false).stream().filter(trader -> TraderAPI.API.FilterTrader((TraderData)trader, search)).toList());
        if (!results.isEmpty()) {
            results.sort(Comparator.comparingLong(TraderData::getID));
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TRADERDATA_LIST_TITLE.get(new Object[0]), true);
            for (int i = 0; i < results.size(); ++i) {
                TraderData thisTrader = (TraderData)results.get(i);
                if (i > 0) {
                    EasyText.sendCommandSucess(source, (Component)EasyText.empty(), true);
                }
                CommandLCAdmin.sendTraderDataFeedback(thisTrader, source);
            }
        } else {
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TRADERDATA_SEARCH_NONE.get(new Object[0]), true);
        }
        return 1;
    }

    private static void sendTraderDataFeedback(TraderData thisTrader, CommandSourceStack source) {
        String traderID = String.valueOf(thisTrader.getID());
        EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TRADERDATA_LIST_TRADER_ID.get(EasyText.literal(traderID).m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, traderID)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)LCText.COMMAND_ADMIN_TRADERDATA_LIST_TRADER_ID_TOOLTIP.get(new Object[0]))))), false);
        if (thisTrader.isPersistent()) {
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TRADERDATA_LIST_PERSISTENT_ID.get(thisTrader.getPersistentID()), false);
        }
        EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TRADERDATA_LIST_TYPE.get(thisTrader.type), false);
        if (thisTrader instanceof AuctionHouseTrader) {
            return;
        }
        EasyText.sendCommandSucess(source, (Component)thisTrader.getOwner().getValidOwner().getCommandLabel(), false);
        TraderState state = thisTrader.getState();
        EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TRADERDATA_LIST_STATE.get(new Object[]{state}), false);
        if (thisTrader.hasWorldPosition()) {
            String dimension = thisTrader.getLevel().m_135782_().toString();
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TRADERDATA_LIST_DIMENSION.get(dimension), false);
            BlockPos pos = thisTrader.getPos();
            String position = pos.m_123341_() + " " + pos.m_123342_() + " " + pos.m_123343_();
            String teleportPosition = pos.m_123341_() + " " + (pos.m_123342_() + 1) + " " + pos.m_123343_();
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TRADERDATA_LIST_POSITION.get(EasyText.literal(position).m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/execute in " + dimension + " run tp @s " + teleportPosition)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)LCText.COMMAND_ADMIN_TRADERDATA_LIST_POSITION_TOOLTIP.get(new Object[0]))))), true);
        }
        if (thisTrader.hasCustomName()) {
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TRADERDATA_LIST_NAME.get(thisTrader.getName()), true);
        }
    }

    static int deleteTraderData(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        TraderData trader = TraderArgument.getTrader(commandContext, "traderID");
        TraderAPI.API.DeleteTrader(trader.getID());
        EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TRADERDATA_DELETE_SUCCESS.get(trader.getName()), true);
        return 1;
    }

    static int debugTraderData(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        TraderData trader = TraderArgument.getTrader(commandContext, "traderID");
        EasyText.sendCommandSucess(source, (Component)EasyText.literal(trader.save().m_7916_()), false);
        if (((CommandSourceStack)commandContext.getSource()).m_230897_()) {
            new SPacketDebugTrader(trader.getID()).sendTo(((CommandSourceStack)commandContext.getSource()).m_81375_());
        }
        return 1;
    }

    static int recoverTraderItem(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CommandSourceStack sourceStack = (CommandSourceStack)commandContext.getSource();
        TraderData trader = TraderArgument.getTrader(commandContext, "traderID");
        ServerPlayer player = sourceStack.m_81375_();
        if (trader.isRecoverable()) {
            Item item = trader.getTraderBlock();
            if (item == null) {
                EasyText.sendCommandFail(sourceStack, (Component)LCText.COMMAND_ADMIN_TRADERDATA_RECOVER_FAIL_NO_ITEM.get(new Object[0]));
                return 0;
            }
            ItemStack stack = new ItemStack((ItemLike)item);
            CompoundTag tag = stack.m_41784_();
            tag.m_128356_("StoredTrader", trader.getID());
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
            EasyText.sendCommandSucess(sourceStack, (Component)LCText.COMMAND_ADMIN_TRADERDATA_RECOVER_SUCCESS.get(new Object[0]), true);
            return 1;
        }
        throw TraderArgument.ERROR_NOT_RECOVERABLE.create();
    }

    static int addToTraderWhitelist(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        TraderData trader = TraderArgument.getTrader(commandContext, "traderID");
        TradeRule rule = TradeRule.getRule(PlayerListing.TYPE.type, trader.getRules());
        if (rule instanceof PlayerListing) {
            PlayerListing whitelist = (PlayerListing)rule;
            Collection players = EntityArgument.m_91477_(commandContext, (String)"player");
            int count = 0;
            for (ServerPlayer player : players) {
                if (!whitelist.addToWhitelist(player)) continue;
                ++count;
            }
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TRADERDATA_ADD_TO_WHITELIST_SUCCESS.get(count, trader.getName()), true);
            if (count > 0) {
                trader.markTradeRulesDirty();
            }
            return count;
        }
        EasyText.sendCommandFail(source, (Component)LCText.COMMAND_ADMIN_TRADERDATA_ADD_TO_WHITELIST_MISSING.get(new Object[0]));
        return 0;
    }

    static int viewWalletSlot(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        Entity e = EntityArgument.m_91452_(commandContext, (String)"entity");
        IWalletHandler walletHandler = WalletCapability.lazyGetWalletHandler(e);
        if (walletHandler != null) {
            ItemStack wallet = walletHandler.getWallet();
            if (wallet.m_41619_()) {
                EasyText.sendCommandSucess(commandContext, (Component)LCText.COMMAND_ADMIN_VIEW_WALLET_EMPTY.get(e.m_5446_()), false);
            } else {
                EasyText.sendCommandSucess(commandContext, (Component)LCText.COMMAND_ADMIN_VIEW_WALLET_SUCCESS.get(e.m_5446_(), wallet.m_41611_()), false);
            }
            return 1;
        }
        EasyText.sendCommandFail(commandContext, (Component)LCText.COMMAND_ADMIN_VIEW_WALLET_INVALID_TARGET.get(e.m_5446_()));
        return 0;
    }

    static int replaceWalletSlotWithDefault(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        return CommandLCAdmin.replaceWalletSlotInternal(commandContext, true);
    }

    static int replaceWalletSlot(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        return CommandLCAdmin.replaceWalletSlotInternal(commandContext, BoolArgumentType.getBool(commandContext, (String)"keepWalletContents"));
    }

    static int replaceWalletSlotInternal(CommandContext<CommandSourceStack> commandContext, boolean keepWalletContents) throws CommandSyntaxException {
        int count = 0;
        ItemInput input = ItemArgument.m_120963_(commandContext, (String)"wallet");
        if (!(input.m_120979_() instanceof WalletItem) && input.m_120979_() != Items.f_41852_) {
            throw new CommandSyntaxException(new CommandExceptionType(){}, (Message)LCText.COMMAND_ADMIN_REPLACE_WALLET_NOT_A_WALLET.get(new Object[0]));
        }
        for (Entity entity : EntityArgument.m_91461_(commandContext, (String)"entity")) {
            ItemStack oldWallet;
            ItemStack newWallet;
            IWalletHandler walletHandler = WalletCapability.lazyGetWalletHandler(entity);
            if (walletHandler == null || (newWallet = input.m_120980_(1, true)).m_41619_() && walletHandler.getWallet().m_41619_()) continue;
            if (keepWalletContents && WalletItem.isWallet(oldWallet = walletHandler.getWallet())) {
                newWallet.m_41751_(oldWallet.m_41784_().m_6426_());
            }
            walletHandler.setWallet(newWallet);
        }
        return count;
    }

    static int emptyWallet(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        int count = 0;
        for (Entity e : EntityArgument.m_91461_(commandContext, (String)"entity")) {
            SimpleContainer contents;
            ItemStack currentWallet;
            LivingEntity entity;
            IWalletHandler walletHandler;
            if (!(e instanceof LivingEntity) || (walletHandler = WalletCapability.lazyGetWalletHandler((Entity)(entity = (LivingEntity)e))) == null || !WalletItem.isWallet(currentWallet = walletHandler.getWallet()) || (contents = WalletItem.getWalletInventory(currentWallet)).m_7983_()) continue;
            WalletItem.putWalletInventory(currentWallet, (Container)new SimpleContainer(WalletItem.InventorySize(currentWallet)));
            ++count;
            walletHandler.setWallet(currentWallet);
        }
        EasyText.sendCommandSucess(commandContext, (Component)LCText.COMMAND_ADMIN_EMPTY_WALLET_SUCCESS.get(count), true);
        return count;
    }

    static int openServerTax(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        TaxEntry entry = TaxDataCache.TYPE.get(false).getServerEntry();
        entry.openMenu((Player)((CommandSourceStack)commandContext.getSource()).m_81375_(), SimpleValidator.NULL);
        return 0;
    }

    static int listTaxCollectors(CommandContext<CommandSourceStack> commandContext) {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TAXES_LIST_TITLE.get(new Object[0]), false);
        for (TaxEntry entry : TaxDataCache.TYPE.get(false).getAllEntries()) {
            CommandLCAdmin.sendTaxDataFeedback(entry, source);
        }
        return 1;
    }

    private static void sendTaxDataFeedback(TaxEntry taxEntry, CommandSourceStack source) {
        if (taxEntry.isServerEntry()) {
            return;
        }
        String id = String.valueOf(taxEntry.getID());
        EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TAXES_LIST_ID.get(EasyText.literal(id).m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, id)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)LCText.COMMAND_ADMIN_TAXES_LIST_ID_TOOLTIP.get(new Object[0]))))), false);
        if (!taxEntry.isServerEntry()) {
            EasyText.sendCommandSucess(source, (Component)taxEntry.getOwner().getValidOwner().getCommandLabel(), false);
        }
        String dimension = taxEntry.getArea().getCenter().getDimension().m_135782_().toString();
        EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TAXES_LIST_DIMENSION.get(dimension), false);
        BlockPos pos = taxEntry.getArea().getCenter().getPos();
        String position = pos.m_123341_() + " " + pos.m_123342_() + " " + pos.m_123343_();
        String teleportPosition = pos.m_123341_() + " " + (pos.m_123342_() + 1) + " " + pos.m_123343_();
        EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TAXES_LIST_POSITION.get(EasyText.literal(position).m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/execute in " + dimension + " run tp @s " + teleportPosition)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)LCText.COMMAND_ADMIN_TAXES_LIST_POSITION_TOOLTIP.get(new Object[0]))))), true);
        if (taxEntry.isInfiniteRange()) {
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TAXES_LIST_INFINITE_RANGE.get(new Object[0]), false);
        } else {
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TAXES_LIST_RADIUS.get(taxEntry.getRadius()), false);
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TAXES_LIST_HEIGHT.get(taxEntry.getHeight()), false);
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TAXES_LIST_OFFSET.get(taxEntry.getVertOffset()), false);
        }
        if (taxEntry.forcesAcceptance()) {
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TAXES_LIST_FORCE_ACCEPTANCE.get(new Object[0]), false);
        }
        if (taxEntry.hasCustomName()) {
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TAXES_LIST_NAME.get(taxEntry.getName()), true);
        }
    }

    static int deleteTaxCollector(CommandContext<CommandSourceStack> commandContext) {
        long taxCollectorID = LongArgumentType.getLong(commandContext, (String)"taxCollectorID");
        TaxDataCache data = TaxDataCache.TYPE.get(false);
        TaxEntry entry = data.getEntry(taxCollectorID);
        if (entry == null || entry.isServerEntry()) {
            EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_ADMIN_TAXES_DELETE_FAIL.get(new Object[0]));
            return 0;
        }
        data.removeEntry(taxCollectorID);
        EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_ADMIN_TAXES_DELETE_SUCCESS.get(entry.getName()), true);
        return 1;
    }

    static int forceDisableTaxCollectors(CommandContext<CommandSourceStack> commandContext) {
        int count = 0;
        for (TaxEntry entry : TaxDataCache.TYPE.get(false).getAllEntries()) {
            if (!entry.isActive()) continue;
            entry.setActive(false, null);
            ++count;
        }
        if (count > 0) {
            EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_ADMIN_TAXES_FORCE_DISABLE_SUCCESS.get(count), true);
        } else {
            EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_ADMIN_TAXES_FORCE_DISABLE_FAIL.get(new Object[0]));
        }
        return count;
    }

    static int clearRewardCache(CommandContext<CommandSourceStack> commandContext) {
        String eventID = StringArgumentType.getString(commandContext, (String)"eventID");
        EventRewardDataCache data = EventRewardDataCache.TYPE.get(false);
        if (data != null) {
            EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_ADMIN_EVENT_CLEAR_SUCCESS.get(eventID), true);
            return 1;
        }
        EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_ADMIN_EVENT_CLEAR_FAIL.get(eventID));
        return 0;
    }

    static int listUnlockedEvents(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(commandContext, (String)"player");
        IEventUnlocks eventUnlocks = CapabilityEventUnlocks.getCapability((Player)player);
        if (eventUnlocks != null) {
            List<String> unlocks = eventUnlocks.getUnlockedList();
            if (!unlocks.isEmpty()) {
                StringBuilder list = new StringBuilder();
                for (String v : eventUnlocks.getUnlockedList()) {
                    if (!list.isEmpty()) {
                        list.append(", ");
                    }
                    list.append(v);
                }
                EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)EasyText.literal(list.toString()), false);
            } else {
                EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_ADMIN_EVENT_LIST_NONE.get(new Object[0]), false);
            }
            return 1;
        }
        return 0;
    }

    static int unlockEvent(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        String event;
        ServerPlayer player = EntityArgument.m_91474_(commandContext, (String)"player");
        if (CapabilityEventUnlocks.isUnlocked((Player)player, event = StringArgumentType.getString(commandContext, (String)"event"))) {
            EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_ADMIN_EVENT_UNLOCK_FAIL.get(event));
            return 0;
        }
        CapabilityEventUnlocks.unlock((Player)player, event);
        EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_ADMIN_EVENT_UNLOCK_SUCCESS.get(event), true);
        return 1;
    }

    static int lockEvent(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        String event;
        ServerPlayer player = EntityArgument.m_91474_(commandContext, (String)"player");
        if (!CapabilityEventUnlocks.isUnlocked((Player)player, event = StringArgumentType.getString(commandContext, (String)"event"))) {
            EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_ADMIN_EVENT_LOCK_FAIL.get(event));
            return 0;
        }
        CapabilityEventUnlocks.lock((Player)player, event);
        EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_ADMIN_EVENT_LOCK_SUCCESS.get(event), true);
        return 1;
    }

    static int createPrepaidCard(CommandContext<CommandSourceStack> commandContext, int color) throws CommandSyntaxException {
        MoneyValue amount = MoneyValueArgument.getMoneyValue(commandContext, "amount");
        int count = 0;
        ItemStack item = new ItemStack((ItemLike)ModItems.PREPAID_CARD.get());
        CompoundTag tag = item.m_41784_();
        tag.m_128365_("StoredMoney", (Tag)amount.save());
        CompoundTag display = new CompoundTag();
        display.m_128405_("color", color);
        tag.m_128365_("display", (Tag)display);
        for (ServerPlayer player : EntityArgument.m_91477_(commandContext, (String)"player")) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)item.m_41777_());
            ++count;
        }
        if (count > 0) {
            EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_ADMIN_PREPAID_CARD_SUCCESS.get(amount.getText(), count), true);
        } else {
            EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_ADMIN_PREPAID_CARD_FAIL.get(new Object[0]));
        }
        return count;
    }

    static int createGachaBall(CommandContext<CommandSourceStack> commandContext, int color) throws CommandSyntaxException {
        ItemStack item = ItemArgument.m_120963_(commandContext, (String)"contents").m_120980_(1, false);
        int count = 0;
        for (ServerPlayer player : EntityArgument.m_91477_(commandContext, (String)"player")) {
            ItemStack gachaBall = color < 0 ? GachaBallItem.createWithItem(item) : GachaBallItem.createWithItemAndColor(item, color);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)gachaBall.m_41777_());
            ++count;
        }
        if (count > 0) {
            EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_ADMIN_GACHA_BALL_SUCCESS.get(item.m_41786_(), count), true);
        } else {
            EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_ADMIN_GACHA_BALL_FAIL.get(new Object[0]));
        }
        return count;
    }
}

