/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blocks.variant;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IDeepBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IOwnableBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.ITallBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IWideBlock;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.ModelVariantDataManager;
import io.github.lightman314.lightmanscurrency.common.blockentity.variant.IVariantSupportingBlockEntity;
import io.github.lightman314.lightmanscurrency.common.menus.VariantSelectMenu;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

@MethodsReturnNonnullByDefault
public interface IVariantBlock {
    public static final BooleanProperty VARIANT = BooleanProperty.m_61465_((String)"variant");

    default public int getModelIndex(BlockState state) {
        int index = 0;
        boolean wide = this instanceof IWideBlock;
        boolean tall = this instanceof ITallBlock;
        boolean deep = this instanceof IDeepBlock;
        if (wide && !((Boolean)state.m_61143_((Property)IWideBlock.ISLEFT)).booleanValue()) {
            ++index;
        }
        if (deep && !((Boolean)state.m_61143_((Property)IDeepBlock.IS_FRONT)).booleanValue()) {
            index += wide ? 2 : 1;
        }
        if (tall && !((Boolean)state.m_61143_((Property)ITallBlock.ISBOTTOM)).booleanValue()) {
            index += wide && deep ? 4 : (wide || deep ? 2 : 1);
        }
        return index;
    }

    default public ResourceLocation getBlockID() {
        IVariantBlock iVariantBlock = this;
        if (iVariantBlock instanceof Block) {
            Block block = (Block)iVariantBlock;
            return ForgeRegistries.BLOCKS.getKey((Object)block);
        }
        throw new IllegalStateException("IVariantBlock must be applied to a Block class!");
    }

    default public ResourceLocation getItemID() {
        IVariantBlock iVariantBlock = this;
        if (iVariantBlock instanceof ItemLike) {
            ItemLike item = (ItemLike)iVariantBlock;
            return ForgeRegistries.ITEMS.getKey((Object)item.m_5456_());
        }
        return this.getBlockID();
    }

    default public List<ResourceLocation> getValidVariants() {
        return ModelVariantDataManager.getPotentialVariants(this.getBlockID());
    }

    default public int requiredModels() {
        return this.modelsRequiringRotation();
    }

    default public int modelsRequiringRotation() {
        int count = 1;
        if (this instanceof IWideBlock) {
            count *= 2;
        }
        if (this instanceof ITallBlock) {
            count *= 2;
        }
        if (this instanceof IDeepBlock) {
            count *= 2;
        }
        return count;
    }

    @Nullable
    default public ResourceLocation getCustomDefaultModel(int index) {
        return null;
    }

    public static boolean tryUseWand(Player player, BlockPos pos) {
        Level level = player.m_9236_();
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof IVariantBlock) {
            IVariantBlock variantBlock = (IVariantBlock)block;
            if (player instanceof ServerPlayer) {
                IVariantSupportingBlockEntity be;
                IOwnableBlock ownable;
                ServerPlayer sp = (ServerPlayer)player;
                Block block2 = state.m_60734_();
                if (block2 instanceof IOwnableBlock && !(ownable = (IOwnableBlock)block2).canBreak(player, (LevelAccessor)level, pos, state)) {
                    return false;
                }
                if (level.f_46443_) {
                    return true;
                }
                block2 = level.m_7702_(pos);
                if (block2 instanceof IVariantSupportingBlockEntity && (be = (IVariantSupportingBlockEntity)block2).isVariantLocked()) {
                    player.m_5661_((Component)LCText.TOOLTIP_MODEL_VARIANT_LOCKED.getWithStyle(ChatFormatting.RED), true);
                    return true;
                }
                NetworkHooks.openScreen((ServerPlayer)sp, (MenuProvider)VariantSelectMenu.providerFor(pos), (BlockPos)pos);
                return true;
            }
        }
        return false;
    }

    public static void setItemVariant(ItemStack item, @Nullable ResourceLocation variantID) {
        CompoundTag tag = item.m_41784_();
        if (variantID == null) {
            tag.m_128473_("ModelVariant");
            if (tag.m_128456_()) {
                tag = null;
            }
        } else {
            tag.m_128359_("ModelVariant", variantID.toString());
        }
        item.m_41751_(tag);
    }

    @Nullable
    public static ResourceLocation getItemVariant(ItemStack item) {
        CompoundTag tag = item.m_41783_();
        if (tag == null || !tag.m_128441_("ModelVariant")) {
            return null;
        }
        return VersionUtil.parseResource(tag.m_128461_("ModelVariant"));
    }
}

