/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blockentity.handler;

import io.github.lightman314.lightmanscurrency.common.traders.InputTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.TraderItemStorage;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class TraderItemHandler<T extends InputTraderData> {
    private final T trader;
    private final Map<Direction, IItemHandler> handlers = new HashMap<Direction, IItemHandler>();

    public TraderItemHandler(@Nonnull T trader) {
        this.trader = trader;
    }

    public IItemHandler getHandler(Direction side) {
        if (!this.handlers.containsKey(side)) {
            this.handlers.put(side, new TraderHandler<T>(this.trader, side));
        }
        return this.handlers.get(side);
    }

    private static class TraderHandler<T extends InputTraderData>
    implements IItemHandler {
        private final T trader;
        private final Direction side;

        protected TraderHandler(T trader, Direction side) {
            this.trader = trader;
            this.side = side;
        }

        protected final TraderItemStorage getStorage() {
            return ((IItemStorageProvider)this.trader).getStorage();
        }

        protected final boolean allowsInputs() {
            return this.trader.allowInputSide(this.side);
        }

        protected final boolean allowsOutputs() {
            return this.trader.allowOutputSide(this.side);
        }

        protected final boolean isGhostSlot(int slot) {
            return slot >= this.getStorage().getContents().size();
        }

        protected final void validateSlot(int slot) {
            if (slot < 0) {
                throw new RuntimeException("Slot cannot be negative!");
            }
        }

        public int getSlots() {
            return this.getStorage().getContents().size() + 9;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            if (this.isGhostSlot(slot)) {
                return ItemStack.f_41583_;
            }
            this.validateSlot(slot);
            return this.getStorage().getContents().get(slot);
        }

        public int getSlotLimit(int slot) {
            return this.getStorage().getMaxAmount();
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return this.allowsInputs() && this.getStorage().allowItem(stack) && this.allowedInGhostSlot(slot, stack);
        }

        private boolean allowedInGhostSlot(int slot, @Nonnull ItemStack stack) {
            if (slot >= this.getStorage().getContents().size()) {
                return this.getStorage().getContents().stream().noneMatch(s -> InventoryUtil.ItemMatches(s, stack));
            }
            return true;
        }

        public boolean allowExtraction(@Nonnull ItemStack stack) {
            return ((IItemStorageProvider)this.trader).allowExtraction(stack);
        }

        @Nonnull
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            ItemStack copyStack = stack.m_41777_();
            if (this.allowsInputs() && this.getStorage().allowItem(stack)) {
                if (simulate) {
                    int inputAmount = Math.min(this.getStorage().getFittableAmount(copyStack), copyStack.m_41613_());
                    copyStack.m_41774_(inputAmount);
                } else {
                    this.getStorage().tryAddItem(copyStack);
                    ((IItemStorageProvider)this.trader).markStorageDirty();
                }
            }
            return copyStack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (this.allowsOutputs()) {
                ItemStack stackInSlot = this.getStackInSlot(slot).m_41777_();
                if (stackInSlot.m_41619_() || !this.allowExtraction(stackInSlot)) {
                    return ItemStack.f_41583_;
                }
                int amountToRemove = Math.min(amount, Math.min(stackInSlot.m_41613_(), stackInSlot.m_41741_()));
                if (amountToRemove > 0) {
                    ItemStack result = stackInSlot.m_41777_();
                    result.m_41764_(amountToRemove);
                    if (!simulate) {
                        stackInSlot.m_41764_(amountToRemove);
                        result = this.getStorage().removeItem(stackInSlot);
                    }
                    ((IItemStorageProvider)this.trader).markStorageDirty();
                    return result;
                }
            }
            return ItemStack.f_41583_;
        }
    }

    public static interface IItemStorageProvider {
        @Nonnull
        public TraderItemStorage getStorage();

        public void markStorageDirty();

        public boolean allowExtraction(@Nonnull ItemStack var1);
    }
}

