/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.util;

import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;

@MethodsReturnNonnullByDefault
@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@Immutable
public final class ScreenArea {
    public final int x;
    public final int y;
    public final ScreenPosition pos;
    public final int width;
    public final int height;

    private ScreenArea(ScreenPosition pos, int width, int height) {
        this.x = pos.x;
        this.y = pos.y;
        this.pos = pos;
        this.width = width;
        this.height = height;
    }

    public int centerX() {
        return this.x + this.width / 2;
    }

    public int centerY() {
        return this.y + this.height / 2;
    }

    public static ScreenArea of(int x, int y, int width, int height) {
        return ScreenArea.of(ScreenPosition.of(x, y), width, height);
    }

    public static ScreenArea of(ScreenPosition position, int width, int height) {
        return new ScreenArea(position, width, height);
    }

    public boolean isMouseInArea(ScreenPosition mousePos) {
        return this.isMouseInArea(mousePos.x, mousePos.y);
    }

    public boolean isMouseInArea(int mouseX, int mouseY) {
        return mouseX >= this.pos.x && mouseX < this.pos.x + this.width && mouseY >= this.pos.y && mouseY < this.pos.y + this.height;
    }

    public boolean isMouseInArea(double mouseX, double mouseY) {
        return mouseX >= (double)this.pos.x && mouseX < (double)(this.pos.x + this.width) && mouseY >= (double)this.pos.y && mouseY < (double)(this.pos.y + this.height);
    }

    public ScreenArea atPosition(int x, int y) {
        return ScreenArea.of(x, y, this.width, this.height);
    }

    public ScreenArea atPosition(ScreenPosition newPos) {
        return ScreenArea.of(newPos, this.width, this.height);
    }

    public ScreenArea offsetPosition(int x, int y) {
        return ScreenArea.of(this.pos.offset(x, y), this.width, this.height);
    }

    public ScreenArea offsetPosition(ScreenPosition offset) {
        return ScreenArea.of(this.pos.offset(offset), this.width, this.height);
    }

    public ScreenArea ofSize(int width, int height) {
        return ScreenArea.of(this.pos, width, height);
    }

    public ScreenArea shrinkWidth(int widthDelta) {
        return ScreenArea.of(this.pos, this.width - widthDelta, this.height);
    }

    public ScreenArea shrinkHeight(int heightDelta) {
        return ScreenArea.of(this.pos, this.width, this.height - heightDelta);
    }

    public boolean isOutside(ScreenArea area) {
        return !this.isMouseInArea(area.pos) || !this.isMouseInArea(area.pos.offset(area.width, area.height));
    }

    public String toString() {
        return this.x + "," + this.y + "[" + this.width + "," + this.height + "]";
    }
}

