/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.util;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyStorage;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.IMoneyHolder;
import io.github.lightman314.lightmanscurrency.api.trader_interface.blockentity.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.Sprite;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.dropdown.DropdownWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.util.IconUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@FieldsAreNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public class IconAndButtonUtil {
    public static final ResourceLocation WIDGET_TEXTURE = VersionUtil.lcResource("textures/gui/widgets.png");
    public static final Sprite SPRITE_PLUS = Sprite.SimpleSprite(TraderScreen.GUI_TEXTURE, 224, 20, 10, 10);
    public static final Sprite SPRITE_MINUS = Sprite.SimpleSprite(TraderScreen.GUI_TEXTURE, 234, 20, 10, 10);
    public static final Sprite SPRITE_QUICK_INSERT = Sprite.SimpleSprite(TraderScreen.GUI_TEXTURE, 224, 0, 10, 10);
    public static final Sprite SPRITE_QUICK_EXTRACT = Sprite.SimpleSprite(TraderScreen.GUI_TEXTURE, 234, 0, 10, 10);
    public static final Sprite SPRITE_CHECK_ACTIVE = Sprite.SimpleSprite(WIDGET_TEXTURE, 10, 200, 10, 10);
    public static final Sprite SPRITE_CHECK_INACTIVE = Sprite.SimpleSprite(WIDGET_TEXTURE, 10, 220, 10, 10);
    public static final Sprite SPRITE_TOGGLE_ACTIVE = Sprite.SimpleSprite(WIDGET_TEXTURE, 0, 20, 8, 18);
    public static final Sprite SPRITE_TOGGLE_INACTIVE = Sprite.SimpleSprite(WIDGET_TEXTURE, 8, 20, 8, 18);
    public static final Sprite SPRITE_NEUTRAL_TOGGLE_UP = Sprite.LockedSprite(WIDGET_TEXTURE, 16, 20, 8, 18);
    public static final Sprite SPRITE_NEUTRAL_TOGGLE_DOWN = Sprite.LockedSprite(WIDGET_TEXTURE, 16, 38, 8, 18);

    public static Supplier<Sprite> SPRITE_CHECK(Supplier<Boolean> isActive) {
        return () -> (Boolean)isActive.get() != false ? SPRITE_CHECK_ACTIVE : SPRITE_CHECK_INACTIVE;
    }

    public static Supplier<Sprite> SPRITE_TOGGLE(Supplier<Boolean> isActive) {
        return () -> (Boolean)isActive.get() != false ? SPRITE_TOGGLE_ACTIVE : SPRITE_TOGGLE_INACTIVE;
    }

    public static Supplier<Sprite> SPRITE_NEUTRAL_TOGGLE(Supplier<Boolean> isUp) {
        return () -> (Boolean)isUp.get() != false ? SPRITE_NEUTRAL_TOGGLE_UP : SPRITE_NEUTRAL_TOGGLE_DOWN;
    }

    @Nonnull
    public static IconButton finishCollectCoinButton(@Nonnull IconButton.Builder builder, @Nonnull Player player, @Nonnull Supplier<TraderData> traderSource) {
        return ((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)builder.icon(IconUtil.ICON_COLLECT_COINS).addon(EasyAddonHelper.tooltips(() -> {
            TraderData trader = (TraderData)traderSource.get();
            if (trader != null && !trader.hasBankAccount() && !trader.getStoredMoney().getStoredMoney().isEmpty()) {
                ArrayList<MutableComponent> result = new ArrayList<MutableComponent>();
                result.add(LCText.TOOLTIP_TRADER_COLLECT_COINS.get(new Object[0]));
                IMoneyHolder storage = trader.getStoredMoney();
                for (MoneyValue value : storage.getStoredMoney().allValues()) {
                    result.add(value.getText());
                }
                return result;
            }
            return new ArrayList();
        }))).addon(EasyAddonHelper.visibleCheck(() -> {
            TraderData trader = (TraderData)traderSource.get();
            if (trader == null) {
                return false;
            }
            return trader.hasPermission(player, "collectCoins") && !trader.hasBankAccount();
        }))).addon(EasyAddonHelper.activeCheck(() -> {
            TraderData trader = (TraderData)traderSource.get();
            if (trader == null) {
                return false;
            }
            return !trader.getInternalStoredMoney().isEmpty();
        }))).build();
    }

    @Nonnull
    public static IconButton finishCollectCoinButton(@Nonnull IconButton.Builder builder, @Nonnull Supplier<MoneyStorage> moneyStorageSource) {
        return ((IconButton.Builder)builder.icon(IconUtil.ICON_COLLECT_COINS).addon(EasyAddonHelper.tooltips(() -> {
            MoneyStorage storage = (MoneyStorage)moneyStorageSource.get();
            if (storage != null && !storage.isEmpty()) {
                ArrayList<MutableComponent> result = new ArrayList<MutableComponent>();
                result.add(LCText.TOOLTIP_TRADER_COLLECT_COINS.get(new Object[0]));
                for (MoneyValue value : storage.allValues()) {
                    result.add(value.getText());
                }
                return result;
            }
            return new ArrayList();
        }))).build();
    }

    @Deprecated
    public static PlainButton plusButton(ScreenPosition pos, Consumer<EasyButton> pressable) {
        return IconAndButtonUtil.plusButton(pos.x, pos.y, pressable);
    }

    @Deprecated
    public static PlainButton plusButton(int x, int y, Consumer<EasyButton> pressable) {
        return ((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(x, y)).pressAction(pressable)).sprite(SPRITE_PLUS).build();
    }

    @Deprecated
    public static PlainButton minusButton(ScreenPosition pos, Consumer<EasyButton> pressable) {
        return IconAndButtonUtil.minusButton(pos.x, pos.y, pressable);
    }

    @Deprecated
    public static PlainButton minusButton(int x, int y, Consumer<EasyButton> pressable) {
        return ((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(x, y)).pressAction(pressable)).sprite(SPRITE_MINUS).build();
    }

    @Deprecated
    public static PlainButton checkmarkButton(ScreenPosition pos, Consumer<EasyButton> pressable, Supplier<Boolean> isActive) {
        return IconAndButtonUtil.checkmarkButton(pos.x, pos.y, pressable, isActive);
    }

    @Deprecated
    public static PlainButton checkmarkButton(int x, int y, Consumer<EasyButton> pressable, Supplier<Boolean> isActive) {
        return ((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(x, y)).pressAction(pressable)).sprite(IconAndButtonUtil.SPRITE_CHECK(isActive)).build();
    }

    public static DropdownWidget interactionTypeDropdown(ScreenPosition pos, int width, TraderInterfaceBlockEntity.InteractionType currentlySelected, Consumer<Integer> onSelect, List<TraderInterfaceBlockEntity.InteractionType> blacklist) {
        return IconAndButtonUtil.interactionTypeDropdown(pos.x, pos.y, width, currentlySelected, onSelect, blacklist);
    }

    public static DropdownWidget interactionTypeDropdown(int x, int y, int width, TraderInterfaceBlockEntity.InteractionType currentlySelected, Consumer<Integer> onSelect, List<TraderInterfaceBlockEntity.InteractionType> blacklist) {
        DropdownWidget.Builder builder = ((DropdownWidget.Builder)DropdownWidget.builder().position(x, y)).width(width).selected(currentlySelected.index).selectAction(onSelect).activeCheck(i -> !blacklist.contains((Object)TraderInterfaceBlockEntity.InteractionType.fromIndex(i)));
        for (int i2 = 0; i2 < TraderInterfaceBlockEntity.InteractionType.size(); ++i2) {
            builder.option(TraderInterfaceBlockEntity.InteractionType.fromIndex(i2).getDisplayText());
        }
        return builder.build();
    }
}

