/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.scroll;

import io.github.lightman314.lightmanscurrency.util.MathUtil;

public interface IScrollable {
    public int currentScroll();

    public void setScroll(int var1);

    default public int getMinScroll() {
        return 0;
    }

    public int getMaxScroll();

    default public void validateScroll() {
        if (this.currentScroll() < this.getMinScroll()) {
            this.setScroll(this.getMinScroll());
        }
        if (this.currentScroll() > this.getMaxScroll()) {
            this.setScroll(this.getMaxScroll());
        }
    }

    default public boolean handleScrollWheel(double delta) {
        int scroll = this.currentScroll();
        if (delta < 0.0) {
            if (scroll < this.getMaxScroll()) {
                this.setScroll(scroll + 1);
                return true;
            }
        } else if (delta > 0.0 && scroll > 0) {
            this.setScroll(scroll - 1);
            return true;
        }
        return false;
    }

    public static int calculateMaxScroll(int visibleCount, int totalCount) {
        return Math.max(0, totalCount - visibleCount);
    }

    public static int calculateMaxScroll(int visibleCount, int entriesPerScroll, int totalCount) {
        return Math.max(0, MathUtil.DivideByAndRoundUp(totalCount, entriesPerScroll) - visibleCount / entriesPerScroll);
    }
}

