/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.button.inventory;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.Sprite;
import io.github.lightman314.lightmanscurrency.client.gui.screen.NotificationScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.inventory.InventoryButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.data.types.NotificationDataCache;
import io.github.lightman314.lightmanscurrency.network.message.notifications.CPacketOpenNotifications;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class NotificationButton
extends InventoryButton {
    private static NotificationButton lastButton = null;
    public static final int SIZE = 9;
    public static final ScreenPosition OFFSET = ScreenPosition.of(10, 0);
    public static final Sprite SPRITE_NORMAL = Sprite.SimpleSprite(NotificationScreen.GUI_TEXTURE, 200, 0, 9, 9);
    public static final Sprite SPRITE_UNSEEN = Sprite.SimpleSprite(NotificationScreen.GUI_TEXTURE, 209, 0, 9, 9);

    public NotificationButton(AbstractContainerScreen<?> inventoryScreen) {
        super(inventoryScreen, CPacketOpenNotifications::sendToServer, NotificationButton::getSprite);
        lastButton = this;
    }

    @Override
    protected ScreenPosition getPositionOffset(boolean isCreativeScreen) {
        return isCreativeScreen ? ((ScreenPosition)LCConfig.CLIENT.notificationAndTeamButtonCreativePosition.get()).offset(OFFSET) : ((ScreenPosition)LCConfig.CLIENT.notificationAndTeamButtonPosition.get()).offset(OFFSET);
    }

    private static Sprite getSprite() {
        return NotificationDataCache.TYPE.get(true).getNotifications((Player)Minecraft.m_91087_().f_91074_).unseenNotification() ? SPRITE_UNSEEN : SPRITE_NORMAL;
    }

    public static void tryRenderTooltip(EasyGuiGraphics gui) {
        if (lastButton != null && lastButton.isMouseOver(gui.mousePos)) {
            gui.renderTooltip((Component)LCText.TOOLTIP_NOTIFICATION_BUTTON.get(new Object[0]));
        }
    }
}

