/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.button;

import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.ITooltipWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NetworkTraderButton
extends EasyButton
implements ITooltipWidget {
    public static final ResourceLocation BUTTON_TEXTURES = VersionUtil.lcResource("textures/gui/universaltraderbuttons.png");
    public static final int WIDTH = 146;
    public static final int HEIGHT = 30;
    TraderData data;
    public boolean selected = false;

    public TraderData getData() {
        return this.data;
    }

    private NetworkTraderButton(@Nonnull Builder builder) {
        super(builder);
    }

    public void SetData(TraderData data) {
        this.data = data;
    }

    @Override
    protected void renderTick() {
        if (this.data == null == this.f_93624_) {
            this.setVisible(this.data != null);
        }
    }

    @Override
    public void renderWidget(@Nonnull EasyGuiGraphics gui) {
        boolean bl = this.f_93623_ = this.data != null && !this.selected;
        if (this.data == null) {
            return;
        }
        if (this.f_93623_) {
            gui.resetColor();
        } else {
            gui.setColor(0.5f, 0.5f, 0.5f);
        }
        int offset = 0;
        if (this.f_93622_) {
            offset = 30;
        }
        if (this.selected) {
            offset += 60;
        }
        gui.blit(BUTTON_TEXTURES, 0, 0, 0, offset, 146, 30);
        this.data.getDisplayIcon().render(gui, 4, 7);
        int color = this.data.getTerminalTextColor();
        gui.drawString(TextRenderUtil.fitString((Component)this.data.getName(), this.f_93618_ - 26), 24, 6, color);
        gui.drawString(TextRenderUtil.fitString((Component)this.data.getOwner().getName(), this.f_93618_ - 26), 24, 16, 0x404040);
        gui.resetColor();
    }

    @Override
    public List<Component> getTooltipText() {
        TraderData trader = this.getData();
        if (trader == null) {
            return new ArrayList<Component>();
        }
        return trader.getTerminalInfo((Player)Minecraft.m_91087_().f_91074_);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @MethodsReturnNonnullByDefault
    @FieldsAreNonnullByDefault
    public static class Builder
    extends EasyButton.EasyButtonBuilder<Builder> {
        private Builder() {
            super(146, 30);
        }

        @Override
        protected Builder getSelf() {
            return this;
        }

        public NetworkTraderButton build() {
            return new NetworkTraderButton(this);
        }
    }
}

