/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyScreenHelper;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.ITooltipSource;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidgetWithChildren;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.restrictions.ItemTradeRestriction;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ItemEditWidget
extends EasyWidgetWithChildren
implements IScrollable,
ITooltipSource {
    public static final ResourceLocation GUI_TEXTURE = VersionUtil.lcResource("textures/gui/item_edit.png");
    private static ItemEditWidget latestInstance = null;
    private static boolean rebuilding = false;
    private static final List<Function<CreativeModeTab, Boolean>> ITEM_GROUP_BLACKLIST = new ArrayList<Function<CreativeModeTab, Boolean>>();
    private static final List<Predicate<ItemStack>> ITEM_BLACKLIST = Lists.newArrayList((Object[])new Predicate[]{s -> s.m_41720_() instanceof TicketItem});
    private static final List<ItemInsertRule> ITEM_ADDITIONS = new ArrayList<ItemInsertRule>();
    private int scroll = 0;
    private int stackCount = 1;
    private final int columns;
    private final int rows;
    private final ScreenPosition searchOffset;
    private final ScreenPosition stackSizeOffset;
    private static final List<ItemStack> allItems = new ArrayList<ItemStack>();
    private static final Map<ResourceLocation, List<ItemStack>> preFilteredItems = new HashMap<ResourceLocation, List<ItemStack>>();
    private List<ItemStack> searchResultItems = new ArrayList<ItemStack>();
    private String searchString;
    EditBox searchInput;
    ScrollListener stackScrollListener;
    private final IItemEditListener listener;
    private final Font font;
    private final ItemEditWidget oldItemEdit;

    public static void BlacklistCreativeTabs(CreativeModeTab ... tabs) {
        for (CreativeModeTab tab : tabs) {
            ItemEditWidget.BlacklistCreativeTab(t -> tab == t);
        }
    }

    @SafeVarargs
    public static void BlacklistCreativeTabs(ResourceKey<CreativeModeTab> ... tabs) {
        for (ResourceKey<CreativeModeTab> tab : tabs) {
            ItemEditWidget.BlacklistCreativeTab(t -> BuiltInRegistries.f_279662_.m_6246_(tab) == t);
        }
    }

    @SafeVarargs
    public static void BlacklistCreativeTabs(RegistryObject<CreativeModeTab> ... tabs) {
        for (RegistryObject<CreativeModeTab> tab : tabs) {
            ItemEditWidget.BlacklistCreativeTab(t -> tab.get() == t);
        }
    }

    public static void BlacklistCreativeTab(Function<CreativeModeTab, Boolean> tabMatcher) {
        if (!ITEM_GROUP_BLACKLIST.contains(tabMatcher)) {
            ITEM_GROUP_BLACKLIST.add(tabMatcher);
        }
    }

    public static boolean IsCreativeTabAllowed(CreativeModeTab tab) {
        for (Function<CreativeModeTab, Boolean> test : ITEM_GROUP_BLACKLIST) {
            if (!test.apply(tab).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static void BlacklistItem(RegistryObject<? extends ItemLike> item) {
        ItemEditWidget.BlacklistItem((ItemLike)item.get());
    }

    public static void BlacklistItem(ItemLike item) {
        ItemEditWidget.BlacklistItem((ItemStack s) -> s.m_41720_() == item.m_5456_());
    }

    public static void BlacklistItem(Predicate<ItemStack> itemFilter) {
        if (!ITEM_BLACKLIST.contains(itemFilter)) {
            ITEM_BLACKLIST.add(itemFilter);
        }
    }

    public static void AddExtraItem(ItemStack item) {
        ITEM_ADDITIONS.add(ItemInsertRule.atEnd(item));
    }

    public static void AddExtraItemAfter(ItemStack item, @Nonnull Item afterItem) {
        ITEM_ADDITIONS.add(ItemInsertRule.afterItem(item, afterItem));
    }

    public static void AddExtraItemAfter(ItemStack item, @Nonnull Predicate<ItemStack> afterItem) {
        ITEM_ADDITIONS.add(ItemInsertRule.afterCheck(item, afterItem));
    }

    public static void AddExtraItemBefore(ItemStack item, @Nonnull Item beforeItem) {
        ITEM_ADDITIONS.add(ItemInsertRule.beforeItem(item, beforeItem));
    }

    public static void AddExtraItemBefore(ItemStack item, @Nonnull Predicate<ItemStack> beforeItem) {
        ITEM_ADDITIONS.add(ItemInsertRule.beforeCheck(item, beforeItem));
    }

    public static boolean isItemAllowed(ItemStack item) {
        for (Predicate<ItemStack> blacklist : ITEM_BLACKLIST) {
            if (!blacklist.test(item)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private EditBox getOldSearchInput() {
        return this.oldItemEdit != null ? this.oldItemEdit.searchInput : null;
    }

    private String getOldSearchString() {
        return this.oldItemEdit != null ? this.oldItemEdit.searchString : "";
    }

    private ItemEditWidget(@Nonnull Builder builder) {
        super(builder);
        latestInstance = this;
        this.listener = builder.handler;
        this.oldItemEdit = builder.oldWidget;
        this.columns = builder.columns;
        this.rows = builder.rows;
        this.searchOffset = Objects.requireNonNullElse(builder.searchOffset, ScreenPosition.of(this.f_93618_ - 90, -13));
        this.stackSizeOffset = Objects.requireNonNullElse(builder.stackSizeOffset, ScreenPosition.of(this.f_93618_ + 13, 0));
        Minecraft mc = Minecraft.m_91087_();
        this.font = mc.f_91062_;
        ItemEditWidget.ConfirmItemListLoaded();
        this.modifySearch(this.getOldSearchString());
        if (this.oldItemEdit != null) {
            this.setScroll(this.oldItemEdit.scroll);
        }
    }

    public static void ConfirmItemListLoaded() {
        if (allItems.isEmpty()) {
            rebuilding = true;
        }
        new Thread(ItemEditWidget::safeInitItemList).start();
    }

    public static void safeInitItemList() {
        try {
            ItemEditWidget.initItemList();
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error occurred while attempting to set up the Item List!\nPlease report this error to the relevant mod author (if another mod is mentioned in the error), not to the Lightman's Currency Dev!", t);
        }
        rebuilding = false;
    }

    private static void initItemList() {
        RegistryAccess lookup;
        boolean hasPermissions;
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        FeatureFlagSet flagSet = player.f_108617_.m_247016_();
        if (!CreativeModeTabs.m_269226_((FeatureFlagSet)flagSet, (boolean)(hasPermissions = (Boolean)mc.f_91066_.m_257871_().m_231551_() != false && player.m_36337_()), (HolderLookup.Provider)(lookup = mc.f_91074_.m_9236_().m_9598_())) && !allItems.isEmpty()) {
            LightmansCurrency.LogDebug("Creative Tab Contents have not changed. Used existing filtered results.");
            return;
        }
        LightmansCurrency.LogInfo("Pre-filtering item list for Item Edit items.");
        rebuilding = true;
        allItems.clear();
        for (CreativeModeTab creativeTab : CreativeModeTabs.m_257478_()) {
            if (!ItemEditWidget.IsCreativeTabAllowed(creativeTab)) continue;
            try {
                for (ItemStack stack : creativeTab.m_260957_()) {
                    if (!ItemEditWidget.isItemAllowed(stack)) continue;
                    ItemEditWidget.addToList(stack);
                    if (stack.m_41720_() != Items.f_42690_) continue;
                    Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
                    enchantments.forEach((enchantment, level) -> {
                        for (int newLevel = level - 1; newLevel > 0; --newLevel) {
                            ItemStack newBook = new ItemStack((ItemLike)Items.f_42690_);
                            EnchantmentHelper.m_44865_((Map)ImmutableMap.of((Object)enchantment, (Object)newLevel), (ItemStack)newBook);
                            if (!ItemEditWidget.isItemAllowed(newBook)) continue;
                            ItemEditWidget.addToList(newBook);
                        }
                    });
                }
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error getting display items from the '" + creativeTab.m_40786_().getString() + "' tab!\nThis tab will be ignored!", t);
            }
        }
        for (ItemInsertRule extraItemRule : ITEM_ADDITIONS) {
            ItemStack extraItem;
            if (!extraItemRule.shouldInsertAtEnd() || !ItemEditWidget.isItemAllowed(extraItem = extraItemRule.insertStack.m_41777_()) || !ItemEditWidget.notYetInList(extraItem)) continue;
            allItems.add(extraItem.m_41777_());
        }
        preFilteredItems.clear();
        ItemTradeRestriction.forEach((type, restriction) -> preFilteredItems.put((ResourceLocation)type, allItems.stream().filter(restriction::allowItemSelectItem).collect(Collectors.toList())));
        if (latestInstance != null) {
            latestInstance.refreshSearch();
        }
    }

    private static void addToList(ItemStack stack) {
        if (ItemEditWidget.notYetInList(stack = stack.m_41777_())) {
            ItemStack extraItem;
            for (ItemInsertRule insertRule : ITEM_ADDITIONS) {
                if (!insertRule.shouldInsertBefore(stack) || !ItemEditWidget.isItemAllowed(extraItem = insertRule.insertStack.m_41777_()) || !ItemEditWidget.notYetInList(extraItem)) continue;
                allItems.add(extraItem);
            }
            allItems.add(stack);
            for (ItemInsertRule insertRule : ITEM_ADDITIONS) {
                if (!insertRule.shouldInsertAfter(stack) || !ItemEditWidget.isItemAllowed(extraItem = insertRule.insertStack.m_41777_()) || !ItemEditWidget.notYetInList(extraItem)) continue;
                allItems.add(extraItem);
            }
        }
    }

    private static boolean notYetInList(ItemStack stack) {
        return allItems.stream().noneMatch(s -> InventoryUtil.ItemMatches(s, stack));
    }

    @Nonnull
    private List<ItemStack> getFilteredItems() {
        if (this.listener.restrictItemEditItems()) {
            ItemTradeData trade = this.listener.getTrade();
            ItemTradeRestriction restriction = trade == null ? ItemTradeRestriction.NONE : trade.getRestriction();
            return this.getFilteredItems(restriction);
        }
        return new ArrayList<ItemStack>(allItems);
    }

    @Nonnull
    private List<ItemStack> getFilteredItems(ItemTradeRestriction restriction) {
        if (rebuilding) {
            return new ArrayList<ItemStack>();
        }
        ResourceLocation type = restriction.getType();
        if (type == ItemTradeRestriction.NO_RESTRICTION_KEY && restriction != ItemTradeRestriction.NONE) {
            LightmansCurrency.LogWarning("Item Trade Restriction of class '" + restriction.getClass().getSimpleName() + "' was not registered, and is now being used to filter items.\nPlease register during the common setup so that this filtering can be done before the screen is opened to prevent in-game lag.");
            return new ArrayList<ItemStack>(allItems).stream().filter(restriction::allowItemSelectItem).collect(Collectors.toList());
        }
        if (!preFilteredItems.containsKey(type)) {
            LightmansCurrency.LogWarning("Item Trade Restriction of type '" + type + "' was registered AFTER the Player logged-in to the world. Please ensure that they're registered during the common setup phase so that filtering can be done at a less critical time.");
            preFilteredItems.put(type, new ArrayList<ItemStack>(allItems).stream().filter(restriction::allowItemSelectItem).collect(Collectors.toList()));
        }
        return preFilteredItems.get(type);
    }

    @Override
    public int getMaxScroll() {
        return Math.max((this.searchResultItems.size() - 1) / this.columns - this.rows + 1, 0);
    }

    public void refreshPage() {
        this.validateScroll();
        int startIndex = this.scroll * this.columns;
        for (int i = 0; i < this.rows * this.columns; ++i) {
            int thisIndex = startIndex + i;
            if (thisIndex >= this.searchResultItems.size()) continue;
            ItemStack stack = this.searchResultItems.get(thisIndex).m_41777_();
            stack.m_41764_(MathUtil.clamp(this.stackCount, 1, stack.m_41741_()));
        }
    }

    public void refreshSearch() {
        this.modifySearch(this.searchString);
    }

    public void modifySearch(@Nonnull String newSearch) {
        this.searchString = newSearch.toLowerCase();
        if (!this.searchString.isEmpty()) {
            this.searchResultItems = new ArrayList<ItemStack>();
            for (ItemStack stack : this.getFilteredItems()) {
                if (stack.m_41786_().getString().toLowerCase().contains(this.searchString)) {
                    this.searchResultItems.add(stack);
                    continue;
                }
                if (ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString().contains(this.searchString)) {
                    this.searchResultItems.add(stack);
                    continue;
                }
                AtomicReference<Boolean> enchantmentMatch = new AtomicReference<Boolean>(false);
                Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
                enchantments.forEach((enchantment, level) -> {
                    if (ForgeRegistries.ENCHANTMENTS.getKey(enchantment).toString().contains(this.searchString)) {
                        enchantmentMatch.set(true);
                    } else if (enchantment.m_44700_(level.intValue()).getString().toLowerCase().contains(this.searchString)) {
                        enchantmentMatch.set(true);
                    }
                });
                if (!enchantmentMatch.get().booleanValue()) continue;
                this.searchResultItems.add(stack);
            }
        } else {
            this.searchResultItems = this.getFilteredItems();
        }
        this.refreshPage();
    }

    @Override
    public void addChildren(@Nonnull ScreenArea area) {
        this.searchInput = this.addChild(new EditBox(this.font, area.x + this.searchOffset.x + 2, area.y + this.searchOffset.y + 2, 79, 9, this.getOldSearchInput(), (Component)LCText.GUI_ITEM_EDIT_SEARCH.get(new Object[0])));
        this.searchInput.m_94182_(false);
        this.searchInput.m_94199_(32);
        this.searchInput.m_94202_(0xFFFFFF);
        this.searchInput.m_94151_(this::modifySearch);
        this.stackScrollListener = this.addChild(((ScrollListener.Builder)((ScrollListener.Builder)ScrollListener.builder().position(area.pos.offset(this.stackSizeOffset))).size(18, 18)).listener(this::stackCountScroll).build());
        this.addChild(((ScrollBarWidget.Builder)ScrollBarWidget.builder().onRight(this).smallKnob().addon(EasyAddonHelper.visibleCheck(this::isVisible))).build());
    }

    @Override
    protected void renderTick() {
        this.searchInput.f_93624_ = this.f_93624_;
        this.stackScrollListener.f_93623_ = this.f_93624_;
    }

    @Override
    public void renderWidget(@Nonnull EasyGuiGraphics gui) {
        int index = this.scroll * this.columns;
        for (int y = 0; y < this.rows && index < this.searchResultItems.size(); ++y) {
            int yPos = y * 18;
            for (int x = 0; x < this.columns && index < this.searchResultItems.size(); ++index, ++x) {
                int xPos = x * 18;
                gui.resetColor();
                gui.blit(GUI_TEXTURE, xPos, yPos, 0, 0, 18, 18);
                gui.renderItem(this.getQuantityFixedStack(this.searchResultItems.get(index)), xPos + 1, yPos + 1);
            }
        }
        gui.resetColor();
        gui.blit(GUI_TEXTURE, this.searchOffset, 18, 0, 90, 12);
        gui.blit(GUI_TEXTURE, this.stackSizeOffset, 108, 0, 18, 18);
    }

    private ItemStack getQuantityFixedStack(ItemStack stack) {
        ItemStack copy = stack.m_41777_();
        copy.m_41764_(Math.min(stack.m_41741_(), this.stackCount));
        return copy;
    }

    @Override
    public List<Component> getTooltipText(int mouseX, int mouseY) {
        if (!this.isVisible()) {
            return null;
        }
        int hoveredSlot = this.isMouseOverSlot(mouseX, mouseY);
        if (hoveredSlot >= 0 && (hoveredSlot += this.scroll * this.columns) < this.searchResultItems.size()) {
            return EasyScreenHelper.getTooltipFromItem(this.searchResultItems.get(hoveredSlot));
        }
        if (this.isMouseOverStackSizeScroll(mouseX, mouseY)) {
            return LCText.TOOLTIP_ITEM_EDIT_SCROLL.getAsList(new Object[0]);
        }
        return null;
    }

    private boolean isMouseOverStackSizeScroll(int mouseX, int mouseY) {
        return this.stackSizeOffset.offset(this.getPosition()).asArea(18, 18).isMouseInArea(mouseX, mouseY);
    }

    private int isMouseOverSlot(double mouseX, double mouseY) {
        if (!this.isVisible()) {
            return -1;
        }
        int foundColumn = -1;
        int foundRow = -1;
        for (int x = 0; x < this.columns && foundColumn < 0; ++x) {
            if (!(mouseX >= (double)(this.m_252754_() + x * 18)) || !(mouseX < (double)(this.m_252754_() + x * 18 + 18))) continue;
            foundColumn = x;
        }
        for (int y = 0; y < this.rows && foundRow < 0; ++y) {
            if (!(mouseY >= (double)(this.m_252907_() + y * 18)) || !(mouseY < (double)(this.m_252907_() + y * 18 + 18))) continue;
            foundRow = y;
        }
        if (foundColumn < 0 || foundRow < 0) {
            return -1;
        }
        return foundRow * this.columns + foundColumn;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int hoveredSlot = this.isMouseOverSlot(mouseX, mouseY);
        if (hoveredSlot >= 0 && (hoveredSlot += this.scroll * this.columns) < this.searchResultItems.size()) {
            ItemStack stack = this.getQuantityFixedStack(this.searchResultItems.get(hoveredSlot));
            this.listener.onItemClicked(stack);
            return true;
        }
        return false;
    }

    public boolean stackCountScroll(double delta) {
        if (delta > 0.0) {
            if (this.stackCount < 64) {
                ++this.stackCount;
            }
        } else if (delta < 0.0 && this.stackCount > 1) {
            --this.stackCount;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (delta < 0.0) {
            if (this.scroll >= this.getMaxScroll()) return false;
            ++this.scroll;
            return true;
        } else {
            if (!(delta > 0.0)) return true;
            if (this.scroll <= 0) return false;
            --this.scroll;
        }
        return true;
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = newScroll;
        this.refreshPage();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    private static class ItemInsertRule {
        public final ItemStack insertStack;
        private final Predicate<ItemStack> afterItemCheck;
        private final Predicate<ItemStack> beforeItemCheck;
        private final Predicate<ItemStack> NULLCHECK = s -> false;

        private ItemInsertRule(ItemStack insertStack, @Nullable Predicate<ItemStack> afterItemCheck, @Nullable Predicate<ItemStack> beforeItemCheck) {
            this.insertStack = insertStack;
            this.afterItemCheck = afterItemCheck == null ? this.NULLCHECK : afterItemCheck;
            this.beforeItemCheck = beforeItemCheck == null ? this.NULLCHECK : beforeItemCheck;
        }

        public static ItemInsertRule atEnd(ItemStack insertStack) {
            return new ItemInsertRule(insertStack, null, null);
        }

        public static ItemInsertRule afterItem(ItemStack insertStack, @Nonnull Item item) {
            return new ItemInsertRule(insertStack, s -> s.m_41720_() == item, null);
        }

        public static ItemInsertRule afterCheck(ItemStack insertStack, @Nonnull Predicate<ItemStack> check) {
            return new ItemInsertRule(insertStack, check, null);
        }

        public static ItemInsertRule beforeItem(ItemStack insertStack, @Nonnull Item item) {
            return new ItemInsertRule(insertStack, null, s -> s.m_41720_() == item);
        }

        public static ItemInsertRule beforeCheck(ItemStack insertStack, @Nonnull Predicate<ItemStack> check) {
            return new ItemInsertRule(insertStack, null, check);
        }

        public boolean shouldInsertBefore(ItemStack insertedItem) {
            return this.beforeItemCheck.test(insertedItem);
        }

        public boolean shouldInsertAfter(ItemStack insertedItem) {
            return this.afterItemCheck.test(insertedItem);
        }

        public boolean shouldInsertAtEnd() {
            return this.afterItemCheck == this.NULLCHECK && this.beforeItemCheck == null;
        }
    }

    @MethodsReturnNonnullByDefault
    @FieldsAreNonnullByDefault
    @ParametersAreNonnullByDefault
    public static class Builder
    extends EasyWidget.EasyBuilder<Builder> {
        int columns = 1;
        int rows = 1;
        @Nullable
        IItemEditListener handler = null;
        @Nullable
        ItemEditWidget oldWidget = null;
        @Nullable
        ScreenPosition searchOffset = null;
        @Nullable
        ScreenPosition stackSizeOffset = null;

        private Builder() {
            super(18, 18);
        }

        @Override
        protected Builder getSelf() {
            return this;
        }

        public Builder columns(int columns) {
            this.columns = columns;
            this.changeWidth(18 * this.columns);
            return this;
        }

        public Builder rows(int rows) {
            this.rows = rows;
            this.changeHeight(18 * this.rows);
            return this;
        }

        public Builder handler(IItemEditListener handler) {
            this.handler = handler;
            return this;
        }

        public Builder oldWidget(@Nullable ItemEditWidget oldWidget) {
            this.oldWidget = oldWidget;
            return this;
        }

        public Builder searchOffset(ScreenPosition searchOffset) {
            this.searchOffset = searchOffset;
            return this;
        }

        public Builder searchOffset(int searchOffX, int searchOffY) {
            this.searchOffset = ScreenPosition.of(searchOffX, searchOffY);
            return this;
        }

        public Builder stackSizeOffset(ScreenPosition stackSizeOffset) {
            this.stackSizeOffset = stackSizeOffset;
            return this;
        }

        public Builder stackSizeOffset(int stackSizeOffX, int stackSizeOffY) {
            this.stackSizeOffset = ScreenPosition.of(stackSizeOffX, stackSizeOffY);
            return this;
        }

        public ItemEditWidget build() {
            return new ItemEditWidget(this);
        }
    }

    public static interface IItemEditListener {
        public ItemTradeData getTrade();

        public boolean restrictItemEditItems();

        public void onItemClicked(ItemStack var1);
    }
}

