/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.trader_interface.data;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.trader_interface.data.TraderInterfaceTargets;
import io.github.lightman314.lightmanscurrency.api.traders.TradeResult;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TradeReference {
    private final TraderInterfaceTargets parent;
    private final int tradeIndex;
    private TradeData tradeData;
    private TradeResult lastResult = TradeResult.SUCCESS;

    public int getTradeIndex() {
        return this.tradeIndex;
    }

    public boolean hasTrade() {
        return this.tradeIndex >= 0 && this.tradeData != null;
    }

    public TradeData getLocalTrade() {
        return this.tradeData;
    }

    public TradeResult getLastResult() {
        return this.lastResult;
    }

    public void setLastResult(TradeResult result) {
        this.lastResult = result;
    }

    @Nullable
    public TradeData getTrueTrade() {
        if (this.tradeIndex < 0) {
            return null;
        }
        TraderData trader = this.parent.getTrader();
        if (trader != null) {
            return trader.getTrade(this.tradeIndex);
        }
        return null;
    }

    private TradeReference(TraderInterfaceTargets parent, int tradeIndex, TradeData trade) {
        this.parent = parent;
        this.tradeIndex = tradeIndex;
        this.tradeData = trade;
    }

    public static TradeReference of(TraderInterfaceTargets parent, int tradeIndex, TradeData trade) {
        return new TradeReference(parent, tradeIndex, trade);
    }

    @Nullable
    public static TradeReference of(TraderInterfaceTargets parent, int tradeIndex) {
        TradeData trade;
        if (tradeIndex < 0) {
            return null;
        }
        TraderData trader = parent.getTrader();
        if (trader != null && (trade = trader.getTrade(tradeIndex)) != null) {
            return TradeReference.of(parent, tradeIndex, parent.copyTrade(trade));
        }
        return null;
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("Index", this.tradeIndex);
        if (this.tradeData != null) {
            tag.m_128365_("Trade", (Tag)this.tradeData.getAsNBT());
        }
        return tag;
    }

    @Nullable
    public static TradeReference load(TraderInterfaceTargets parent, CompoundTag tag) {
        if (tag.m_128441_("Trade") && tag.m_128441_("Index")) {
            int index = tag.m_128451_("Index");
            TradeData trade = parent.loadTrade(tag.m_128469_("Trade"));
            if (trade == null) {
                LightmansCurrency.LogWarning("Error loading cached trade from reference!");
                return null;
            }
            return new TradeReference(parent, index, trade);
        }
        return null;
    }

    public void refreshTrade() {
        if (!this.hasTrade()) {
            return;
        }
        TradeData newTrade = this.parent.copyTrade(this.getTrueTrade());
        if (newTrade != null) {
            this.tradeData = newTrade;
        }
    }
}

