/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.settings;

import io.github.lightman314.lightmanscurrency.api.settings.SettingsNode;
import io.github.lightman314.lightmanscurrency.api.settings.data.LoadContext;
import io.github.lightman314.lightmanscurrency.api.settings.data.SavedSettingData;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public abstract class SettingsSubNode<T extends SettingsNode>
implements IClientTracker {
    protected final T parent;

    public SettingsSubNode(T parent) {
        this.parent = parent;
    }

    @Override
    public final boolean isClient() {
        return ((SettingsNode)this.parent).isClient();
    }

    @Override
    public final boolean isServer() {
        return ((SettingsNode)this.parent).isServer();
    }

    public final String getFullKey() {
        return ((SettingsNode)this.parent).key + "." + this.getSubKey();
    }

    public abstract String getSubKey();

    public abstract MutableComponent getName();

    public boolean allowSelecting(@Nullable Player player) {
        return true;
    }

    public boolean allowSaving(@Nullable Player player) {
        return true;
    }

    public abstract boolean allowLoading(LoadContext var1);

    public abstract void saveSettings(SavedSettingData.MutableNodeAccess var1);

    public abstract void loadSettings(SavedSettingData.NodeAccess var1, LoadContext var2);

    public void writeAsText(SavedSettingData data, Consumer<Component> lineWriter) {
        if (data.hasNode(this.getFullKey())) {
            lineWriter.accept((Component)SettingsNode.formatTitle(this.getName()));
            this.writeLines(data.getNode(this.getFullKey()), lineWriter);
        }
    }

    protected abstract void writeLines(SavedSettingData.NodeAccess var1, Consumer<Component> var2);
}

