/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.money.types;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.api.capability.money.IMoneyHandler;
import io.github.lightman314.lightmanscurrency.api.money.types.IPlayerMoneyHandler;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValueParser;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class CurrencyType {
    private final ResourceLocation type;

    protected CurrencyType(ResourceLocation type) {
        this.type = type;
    }

    public final ResourceLocation getType() {
        return this.type;
    }

    public final MoneyValue sumValues(List<MoneyValue> values) {
        if (values.isEmpty()) {
            return MoneyValue.empty();
        }
        if (values.size() == 1) {
            return values.get(0);
        }
        return this.sumValuesInternal(values);
    }

    protected abstract MoneyValue sumValuesInternal(List<MoneyValue> var1);

    public void getGroupTooltip(MoneyView money, Consumer<MutableComponent> lineConsumer) {
        for (MoneyValue val : money.allValues()) {
            if (val.getCurrency() != this) continue;
            lineConsumer.accept(val.getText());
        }
    }

    @Nullable
    public abstract IPlayerMoneyHandler createMoneyHandlerForPlayer(Player var1);

    @Nullable
    public abstract IMoneyHandler createMoneyHandlerForContainer(Container var1, Consumer<ItemStack> var2, IClientTracker var3);

    @Nullable
    public IMoneyHandler createMoneyHandlerForATM(Player player, Container container) {
        return this.createMoneyHandlerForContainer(container, s -> ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)s), IClientTracker.entityWrapper((Entity)player));
    }

    public boolean allowItemInMoneySlot(Player player, ItemStack item) {
        return false;
    }

    public void addMoneySlotBackground(Consumer<Pair<ResourceLocation, ResourceLocation>> consumer, Consumer<ResourceLocation> lazyConsumer) {
    }

    public abstract MoneyValue loadMoneyValue(CompoundTag var1);

    public abstract MoneyValue loadMoneyValueJson(JsonObject var1);

    public abstract MoneyValueParser getValueParser();

    @OnlyIn(value=Dist.CLIENT)
    public abstract List<Object> getInputHandlers(@Nullable Player var1);
}

