/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.money;

import io.github.lightman314.lightmanscurrency.api.capability.money.IMoneyHandler;
import io.github.lightman314.lightmanscurrency.api.money.types.CurrencyType;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.IMoneyHolder;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.PlayerMoneyHolder;
import io.github.lightman314.lightmanscurrency.common.impl.MoneyAPIImpl;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class MoneyAPI {
    public static final String MODID = "lightmanscurrency";
    public static final MoneyAPI API = MoneyAPIImpl.INSTANCE;

    public abstract List<CurrencyType> AllCurrencyTypes();

    @Deprecated(since="2.2.0.4")
    public static List<CurrencyType> getAllCurrencyTypes() {
        return API.AllCurrencyTypes();
    }

    @Nullable
    public abstract CurrencyType GetRegisteredCurrencyType(ResourceLocation var1);

    @Deprecated(since="2.2.0.4")
    @Nullable
    public static CurrencyType getCurrencyType(ResourceLocation id) {
        return API.GetRegisteredCurrencyType(id);
    }

    public abstract void RegisterCurrencyType(CurrencyType var1);

    @Deprecated(since="2.2.0.4")
    public static void registerCurrencyType(CurrencyType type) {
        API.RegisterCurrencyType(type);
    }

    public abstract IMoneyHolder GetPlayersMoneyHandler(Player var1);

    @Deprecated(since="2.2.0.4")
    public static PlayerMoneyHolder getPlayersMoneyHolder(Player player) {
        return new PlayerMoneyHolder(API.GetPlayersMoneyHandler(player));
    }

    @Deprecated(since="2.2.0.4")
    public static MoneyView getPlayersAvailableFunds(Player player) {
        return API.GetPlayersMoneyHandler(player).getStoredMoney();
    }

    @Deprecated(since="2.2.0.4")
    public static boolean canPlayerAfford(Player player, MoneyValue price) {
        return API.GetPlayersMoneyHandler(player).getStoredMoney().containsValue(price);
    }

    @Deprecated(since="2.2.0.4")
    public static void giveMoneyToPlayer(Player player, MoneyValue value) {
        IMoneyHolder holder = API.GetPlayersMoneyHandler(player);
        holder.insertMoney(value, false);
    }

    @Deprecated(since="2.2.0.4")
    public static boolean takeMoneyFromPlayer(Player player, MoneyValue value) {
        IMoneyHolder holder = API.GetPlayersMoneyHandler(player);
        if (holder.getStoredMoney().containsValue(value) && holder.extractMoney(value, true).isEmpty()) {
            holder.extractMoney(value, false);
            return true;
        }
        return false;
    }

    public final IMoneyHandler GetContainersMoneyHandler(Container container, Player player) {
        return this.CreateContainersMoneyHandler(container, s -> ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)s), IClientTracker.entityWrapper((Entity)player));
    }

    public final IMoneyHandler GetContainersMoneyHandler(Container container, Consumer<ItemStack> overflowHandler, IClientTracker tracker) {
        return this.CreateContainersMoneyHandler(container, overflowHandler, tracker);
    }

    protected abstract IMoneyHandler CreateContainersMoneyHandler(Container var1, Consumer<ItemStack> var2, IClientTracker var3);

    public abstract IMoneyHandler GetATMMoneyHandler(Player var1, Container var2);

    public abstract boolean ItemAllowedInMoneySlot(Player var1, ItemStack var2);
}

