/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.misc.player;

import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.ownership.Owner;
import io.github.lightman314.lightmanscurrency.api.ownership.builtin.FakeOwner;
import io.github.lightman314.lightmanscurrency.api.ownership.builtin.PlayerOwner;
import io.github.lightman314.lightmanscurrency.api.ownership.builtin.TeamOwner;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public final class OwnerData
implements IClientTracker {
    private Owner backupOwner = Owner.getNull(this);
    private Owner currentOwner = Owner.getNull(this);
    private final IClientTracker parent;
    private final Consumer<OwnerData> onChanged;

    @Override
    public boolean isClient() {
        return this.parent.isClient();
    }

    public OwnerData(@Nonnull IClientTracker parent) {
        this(parent, (OwnerData o) -> {});
    }

    public OwnerData(@Nonnull IClientTracker parent, @Nonnull Runnable onChanged) {
        this(parent, (OwnerData o) -> onChanged.run());
    }

    public OwnerData(@Nonnull IClientTracker parent, @Nonnull Consumer<OwnerData> onChanged) {
        this.parent = parent;
        this.onChanged = onChanged;
    }

    @Nonnull
    public Owner getValidOwner() {
        return this.currentOwner.stillValid() ? this.currentOwner : this.backupOwner;
    }

    public boolean hasOwner() {
        return this.currentOwner.stillValid() || this.backupOwner.stillValid();
    }

    public CompoundTag save() {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("BackupOwner", (Tag)this.backupOwner.save());
        compound.m_128365_("Owner", (Tag)this.currentOwner.save());
        return compound;
    }

    public void load(CompoundTag compound) {
        if (compound.m_128441_("BackupOwner") && compound.m_128441_("Owner")) {
            this.backupOwner = Owner.load(compound.m_128469_("BackupOwner"));
            this.currentOwner = Owner.load(compound.m_128469_("Owner"));
        } else {
            this.backupOwner = FakeOwner.of("NULL");
            if (compound.m_128441_("Custom")) {
                MutableComponent custom = Component.Serializer.m_130701_((String)compound.m_128461_("Custom"));
                this.backupOwner = FakeOwner.of(custom.m_6881_());
                this.currentOwner = FakeOwner.of(custom);
            }
            if (compound.m_128441_("Player")) {
                PlayerReference player = PlayerReference.load(compound.m_128469_("Player"));
                this.backupOwner = PlayerOwner.of(player);
                this.currentOwner = PlayerOwner.of(player);
            }
            if (compound.m_128441_("Team")) {
                this.currentOwner = TeamOwner.of(compound.m_128454_("Team"));
            }
        }
        if (this.backupOwner == null) {
            this.backupOwner = Owner.getNull();
        }
        this.backupOwner.setParent(this);
        if (this.currentOwner == null) {
            this.currentOwner = Owner.getNull();
        }
        this.currentOwner.setParent(this);
    }

    public void copyFrom(@Nonnull OwnerData owner) {
        this.backupOwner = owner.backupOwner.copy();
        this.backupOwner.setParent(this);
        this.currentOwner = owner.currentOwner.copy();
        this.currentOwner.setParent(this);
    }

    @Nonnull
    public PlayerReference getPlayerForContext() {
        return this.getValidOwner().asPlayerReference();
    }

    public boolean isAdmin(@Nonnull Player player) {
        return LCAdminMode.isAdminPlayer(player) || this.isAdmin(PlayerReference.of(player));
    }

    public boolean isAdmin(@Nonnull PlayerReference player) {
        return this.getValidOwner().isAdmin(player);
    }

    public boolean isMember(@Nonnull Player player) {
        return LCAdminMode.isAdminPlayer(player) || this.isMember(PlayerReference.of(player));
    }

    public boolean isMember(@Nonnull PlayerReference player) {
        return this.getValidOwner().isMember(player);
    }

    @Nonnull
    public MutableComponent getName() {
        return this.getValidOwner().getName();
    }

    public void SetOwner(@Nonnull Owner newOwner) {
        this.currentOwner = newOwner.copy();
        this.currentOwner.setParent(this);
        if (this.currentOwner.alwaysValid()) {
            this.backupOwner = this.currentOwner.copy();
            this.backupOwner.setParent(this);
        }
        this.setChanged();
    }

    public void setChanged() {
        this.onChanged.accept(this);
    }
}

