/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config.options.builtin;

import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.api.config.options.builtin.ResourceOption;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParser;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParsingException;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemOption
extends ConfigOption<Item> {
    public static final ConfigParser<Item> PARSER = new Parser(true);
    public static final ConfigParser<Item> PARSER_NO_AIR = new Parser(false);
    private final boolean allowAir;

    protected ItemOption(@Nonnull Supplier<Item> defaultValue, boolean allowAir) {
        super(defaultValue);
        this.allowAir = allowAir;
    }

    @Override
    @Nonnull
    protected ConfigParser<Item> getParser() {
        return this.allowAir ? PARSER : PARSER_NO_AIR;
    }

    public static ItemOption create(@Nonnull Supplier<? extends ItemLike> defaultValue) {
        return new ItemOption(() -> ((ItemLike)defaultValue.get()).m_5456_(), true);
    }

    public static ItemOption create(@Nonnull Supplier<? extends ItemLike> defaultValue, boolean allowAir) {
        return new ItemOption(() -> ((ItemLike)defaultValue.get()).m_5456_(), allowAir);
    }

    @Override
    @Nullable
    protected String bonusComment() {
        return "Default: " + PARSER.write((Item)this.getDefaultValue());
    }

    private static class Parser
    implements ConfigParser<Item> {
        private final boolean allowAir;

        private Parser(boolean allowAir) {
            this.allowAir = allowAir;
        }

        @Override
        @Nonnull
        public Item tryParse(@Nonnull String cleanLine) throws ConfigParsingException {
            if (cleanLine.isBlank() && this.allowAir) {
                return Items.f_41852_;
            }
            ResourceLocation itemID = ResourceOption.PARSER.tryParse(cleanLine);
            if (!ForgeRegistries.ITEMS.containsKey(itemID)) {
                throw new ConfigParsingException("No item found with id " + itemID + "!");
            }
            Item item = (Item)ForgeRegistries.ITEMS.getValue(itemID);
            if (item == Items.f_41852_ && !this.allowAir) {
                throw new ConfigParsingException("Air is not an allowed item!");
            }
            return item;
        }

        @Override
        @Nonnull
        public String write(@Nonnull Item value) {
            return ResourceOption.PARSER.write(ForgeRegistries.ITEMS.getKey((Object)value));
        }
    }
}

