/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.version;

import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public interface VersionedText {
    public static final Component LINE_BREAK = VersionedText.literal("\n");
    public static final Component SPACE = VersionedText.literal(" ");
    public static final Component NERUINA_HEADER = VersionedText.withStyle(VersionedText.literal("[Neruina]: "), style -> style.m_131140_(ChatFormatting.AQUA));

    public static Component literal(String text) {
        return Component.m_237113_((String)text);
    }

    public static Component translatable(String key, Object ... args) {
        return Component.m_237110_((String)key, (Object[])args);
    }

    public static Component withStyle(Component text, UnaryOperator<Style> style) {
        if (text instanceof MutableComponent) {
            MutableComponent mutableText = (MutableComponent)text;
            mutableText.m_130938_(style);
        }
        return text;
    }

    public static Component concat(Component ... texts) {
        MutableComponent text = Component.m_237119_();
        for (Component t : texts) {
            text.m_7220_(t);
        }
        return text;
    }

    public static Component concatDelimited(Component delimiter, Component ... texts) {
        MutableComponent text = Component.m_237119_();
        for (int i = 0; i < texts.length; ++i) {
            text.m_7220_(texts[i]);
            if (texts[i].getString().isEmpty() || i == texts.length - 1) continue;
            text.m_7220_(delimiter);
        }
        return text;
    }

    public static Component pad(Component text) {
        MutableComponent padded = Component.m_237119_();
        padded.m_7220_(LINE_BREAK);
        padded.m_7220_(text);
        padded.m_7220_(LINE_BREAK);
        return padded;
    }

    public static Component format(Component text) {
        return VersionedText.concat(NERUINA_HEADER, VersionedText.withStyle(text, style -> style.m_131140_(ChatFormatting.RED)));
    }
}

