/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.mixin.errorable;

import com.bawnorton.neruina.extend.Errorable;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin
implements Errorable {
    @Unique
    private boolean neruina$errored = false;
    @Unique
    private UUID neruina$tickingEntryId = null;

    @Shadow
    public abstract CompoundTag m_41784_();

    @Shadow
    @Nullable
    public abstract CompoundTag m_41783_();

    @Shadow
    public abstract boolean m_41782_();

    @Override
    public boolean neruina$isErrored() {
        return this.neruina$errored;
    }

    @Override
    public void neruina$setErrored() {
        this.neruina$errored = true;
        this.neruina$updateData();
    }

    @Override
    public void neruina$clearErrored() {
        this.neruina$errored = false;
        this.neruina$updateData();
    }

    @Override
    public void neruina$setTickingEntryId(UUID uuid) {
        this.neruina$tickingEntryId = uuid;
        this.neruina$updateData();
    }

    @Override
    public UUID neruina$getTickingEntryId() {
        return this.neruina$tickingEntryId;
    }

    @Unique
    private void neruina$updateData() {
        CompoundTag nbt = this.m_41784_();
        if (this.neruina$errored) {
            nbt.m_128379_("neruina$errored", true);
            if (this.neruina$tickingEntryId != null) {
                nbt.m_128362_("neruina$tickingEntryId", this.neruina$tickingEntryId);
            }
        } else {
            nbt.m_128473_("neruina$errored");
            nbt.m_128473_("neruina$tickingEntryId");
        }
    }

    @Inject(method={"<init>(Lnet/minecraft/nbt/NbtCompound;)V"}, at={@At(value="TAIL")})
    private void readErroredFromNbt(CompoundTag nbt, CallbackInfo ci) {
        if (this.m_41782_()) {
            CompoundTag tag = this.m_41783_();
            assert (tag != null);
            if (tag.m_128441_("neruina$errored")) {
                this.neruina$errored = tag.m_128471_("neruina$errored");
            }
            if (tag.m_128441_("neruina$tickingEntryId")) {
                this.neruina$tickingEntryId = tag.m_128342_("neruina$tickingEntryId");
            }
        }
    }
}

