/*
 * Decompiled with CFR 0.152.
 */
package com.chen1335.renderjs.painter.objects;

import com.chen1335.renderjs.painter.RenderJSPainterObject;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.latvian.mods.kubejs.client.painter.Painter;
import dev.latvian.mods.kubejs.client.painter.PainterObjectProperties;
import dev.latvian.mods.unit.FixedNumberUnit;
import dev.latvian.mods.unit.Unit;
import dev.latvian.mods.unit.UnitVariables;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;

public class RenderJSTexturePainterObject
extends RenderJSPainterObject {
    private Unit color;
    private Unit uOffset;
    private Unit vOffset;
    private Unit uWidth;
    private Unit vHeight;
    private Unit rotation;
    private Unit rotationCenterX = FixedNumberUnit.ZERO;
    private Unit rotationCenterY = FixedNumberUnit.ZERO;
    private Unit scaleX = FixedNumberUnit.ONE;
    private Unit scaleY = FixedNumberUnit.ONE;
    public ResourceLocation texture = MissingTextureAtlasSprite.m_118071_();
    private TextureAtlas textureAtlas;

    public RenderJSTexturePainterObject(Painter painter) {
        super(painter);
    }

    @Override
    protected void load(PainterObjectProperties properties) {
        super.load(properties);
        this.color = properties.getColor("color", this.color);
        this.texture = properties.getResourceLocation("texture", this.texture);
        this.uOffset = properties.getUnit("uOffset", this.uOffset);
        this.vOffset = properties.getUnit("vOffset", this.vOffset);
        this.uWidth = properties.getUnit("uWidth", this.uWidth);
        this.vHeight = properties.getUnit("vHeight", this.vHeight);
        this.rotation = properties.getUnit("rotation", this.rotation);
        if (properties.tag.m_128441_("rotationCenter")) {
            PainterObjectProperties rotationCenterProperties = new PainterObjectProperties(properties.tag.m_128469_("rotationCenter"));
            this.rotationCenterX = rotationCenterProperties.getUnit("x", this.rotationCenterX);
            this.rotationCenterY = rotationCenterProperties.getUnit("y", this.rotationCenterY);
        }
        if (properties.tag.m_128441_("scale")) {
            PainterObjectProperties scaleProperties = new PainterObjectProperties(properties.tag.m_128469_("scale"));
            this.scaleX = scaleProperties.getUnit("x", this.scaleX);
            this.scaleY = scaleProperties.getUnit("y", this.scaleY);
        }
    }

    @Override
    public void draw(GuiGraphics guiGraphics) {
        if (this.texture == null) {
            return;
        }
        if (this.eventJS == null) {
            return;
        }
        float aw = this.w.getFloat((UnitVariables)this.eventJS);
        float ah = this.h.getFloat((UnitVariables)this.eventJS);
        float ax = this.eventJS.alignX(this.x.getFloat((UnitVariables)this.eventJS), aw, this.alignX);
        float ay = this.eventJS.alignY(this.y.getFloat((UnitVariables)this.eventJS), ah, this.alignY);
        float az = this.z.getFloat((UnitVariables)this.eventJS);
        if (this.textureAtlas == null) {
            this.textureAtlas = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_);
        }
        TextureAtlasSprite sprite = this.textureAtlas.m_118316_(this.texture);
        int width = sprite.m_245424_().m_246492_();
        int height = sprite.m_245424_().m_245330_();
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(ax, ay, az);
        poseStack.m_85841_(this.scaleX.getFloat((UnitVariables)this.eventJS), this.scaleY.getFloat((UnitVariables)this.eventJS), 0.0f);
        if (this.rotation != null) {
            poseStack.m_252880_(this.rotationCenterX.getFloat((UnitVariables)this.eventJS), this.rotationCenterY.getFloat((UnitVariables)this.eventJS), 0.0f);
            poseStack.m_252781_(Axis.f_252403_.m_252977_(this.rotation.getFloat((UnitVariables)this.eventJS)));
            poseStack.m_252880_(-this.rotationCenterX.getFloat((UnitVariables)this.eventJS), -this.rotationCenterY.getFloat((UnitVariables)this.eventJS), 0.0f);
        }
        if (this.color != null) {
            int col = this.color.getInt((UnitVariables)this.eventJS);
            RenderSystem.setShaderColor((float)(col >> 16 & 0xFF), (float)(col >> 8 & 0xFF), (float)(col & 0xFF), (float)(col >> 24 & 0xFF));
        }
        float uOffset = this.uOffset == null ? 0.0f : this.uOffset.getFloat((UnitVariables)this.eventJS);
        float vOffset = this.vOffset == null ? 0.0f : this.vOffset.getFloat((UnitVariables)this.eventJS);
        int uWidth = this.uWidth == null ? this.w.getInt((UnitVariables)this.eventJS) : this.uWidth.getInt((UnitVariables)this.eventJS);
        int vHeight = this.vHeight == null ? this.h.getInt((UnitVariables)this.eventJS) : this.vHeight.getInt((UnitVariables)this.eventJS);
        RenderSystem.enableBlend();
        guiGraphics.m_280398_(this.texture, 0, 0, 90, uOffset, vOffset, uWidth, vHeight, width, height);
        poseStack.m_85849_();
    }

    @Override
    public boolean visible() {
        if (this.eventJS == null) {
            return false;
        }
        return this.visible.getBoolean((UnitVariables)this.eventJS);
    }
}

