/*
 * Decompiled with CFR 0.152.
 */
package com.chen1335.renderjs.client.renderer;

import com.chen1335.renderjs.API.IGuiRenderHelper;
import com.chen1335.renderjs.API.ILevelRenderHelper;
import com.chen1335.renderjs.API.IRenderJSPoseStackHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.latvian.mods.kubejs.block.entity.BlockEntityJS;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class RenderJSBlockEntityRenderer
implements BlockEntityRenderer<BlockEntity> {
    public final BlockEntityRenderDispatcher blockEntityRenderDispatcher;
    public final BlockRenderDispatcher blockRenderDispatcher;
    public final ItemRenderer itemRenderer;
    public final EntityRenderDispatcher entityRenderer;
    public final EntityModelSet modelSet;
    public final Font font;
    private int distance = 64;
    private BiPredicate<BlockEntity, Vec3> shouldRenderPredicate = this::defaultShouldRender;
    private BiConsumer<RenderJSBlockEntityRenderer, Context> customRender = (renderer, context) -> {};
    private Predicate<BlockEntity> shouldRenderOffScreen = blockEntity -> false;

    public static RenderJSBlockEntityRenderer create(BlockEntityRendererProvider.Context context) {
        return new RenderJSBlockEntityRenderer(context);
    }

    public RenderJSBlockEntityRenderer(BlockEntityRendererProvider.Context context2) {
        this.blockEntityRenderDispatcher = context2.m_173581_();
        this.blockRenderDispatcher = context2.m_173584_();
        this.itemRenderer = context2.m_234447_();
        this.entityRenderer = context2.m_234446_();
        this.modelSet = context2.m_173585_();
        this.font = context2.m_173586_();
    }

    @HideFromJS
    public void m_6922_(@NotNull BlockEntity blockEntity, float pPartialTick, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        this.customRender.accept(this, Context.context.update(blockEntity, pPartialTick, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay));
    }

    public boolean m_5932_(@NotNull BlockEntity blockEntity) {
        return this.shouldRenderOffScreen.test(blockEntity);
    }

    public int m_142163_() {
        return this.distance;
    }

    public boolean m_142756_(@NotNull BlockEntity pBlockEntity, @NotNull Vec3 pCameraPos) {
        return this.shouldRenderPredicate.test(pBlockEntity, pCameraPos);
    }

    public boolean defaultShouldRender(BlockEntity pBlockEntity, Vec3 pCameraPos) {
        return Vec3.m_82512_((Vec3i)pBlockEntity.m_58899_()).m_82509_((Position)pCameraPos, (double)this.m_142163_());
    }

    public RenderJSBlockEntityRenderer setCustomRender(BiConsumer<RenderJSBlockEntityRenderer, Context> consumer) {
        this.customRender = consumer;
        return this;
    }

    public RenderJSBlockEntityRenderer setViewDistance(int distance) {
        this.distance = distance;
        return this;
    }

    public RenderJSBlockEntityRenderer setShouldRender(BiPredicate<BlockEntity, Vec3> predicate) {
        this.shouldRenderPredicate = predicate;
        return this;
    }

    public RenderJSBlockEntityRenderer setShouldRenderOffScreen(Predicate<BlockEntity> predicate) {
        this.shouldRenderOffScreen = predicate;
        return this;
    }

    public static class Context
    implements ILevelRenderHelper,
    IGuiRenderHelper,
    IRenderJSPoseStackHelper {
        public static final Context context = new Context();
        private GuiGraphics guiGraphics = null;
        public BlockEntity blockEntity;
        @Info(value="\u5982\u679c\u4f60\u5341\u5206\u786e\u5b9a\u4ee5\u53ca\u80af\u5b9a\u8fd9\u4e2a\u5b9e\u4f53\u662fBlockEntityJS\u7c7b\uff0c\u5426\u5219\u4e0d\u8981\u4f7f\u7528\u8fd9\u4e2a\u53c2\u6570")
        public BlockEntityJS blockEntityJS = null;
        public float partialTick;
        public PoseStack poseStack;
        public MultiBufferSource bufferSource;
        public int packedLight;
        public int packedOverlay;

        @HideFromJS
        public Context update(@NotNull BlockEntity pBlockEntity, float pPartialTick, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
            if (pBlockEntity instanceof BlockEntityJS) {
                this.blockEntityJS = (BlockEntityJS)pBlockEntity;
            }
            this.getGuiGraphics().f_279612_ = pPoseStack;
            this.blockEntity = pBlockEntity;
            this.partialTick = pPartialTick;
            this.poseStack = pPoseStack;
            this.bufferSource = pBufferSource;
            this.packedLight = pPackedLight;
            this.packedOverlay = pPackedOverlay;
            return this;
        }

        @Override
        public GuiGraphics getGuiGraphics() {
            if (this.guiGraphics == null) {
                this.guiGraphics = new GuiGraphics(Minecraft.m_91087_(), Minecraft.m_91087_().m_91269_().m_110104_());
            }
            return this.guiGraphics;
        }

        @Override
        public PoseStack getPoseStack() {
            return this.poseStack;
        }
    }
}

