/*
 * Decompiled with CFR 0.152.
 */
package com.chen1335.renderjs.API;

import com.chen1335.renderjs.client.renderer.RenderJSBlockRender;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.latvian.mods.kubejs.typings.Info;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.data.ModelData;

public interface ILevelRenderHelper {
    public static final ILevelRenderHelper levelRenderHelper = new ILevelRenderHelper(){
        public int[] color = new int[]{255, 255, 255, 255};
        public RenderType blockRenderType = null;

        @Override
        public void setColor(int r, int g, int b, int a) {
            RenderSystem.setShaderColor((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)((float)a / 255.0f));
            this.color = new int[]{r, g, b, a};
        }

        @Override
        public int[] getColor() {
            return this.color;
        }

        @Override
        public RenderType getBlockRenderType() {
            return this.blockRenderType;
        }

        @Override
        public void restColor() {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.color = new int[]{255, 255, 255, 255};
        }

        @Override
        public void restBlockRenderType() {
            this.blockRenderType = null;
        }

        @Override
        public void setBlockRenderType(RenderType renderType) {
            this.blockRenderType = renderType;
        }

        @Override
        @Info(value="If you want to make the block semi transparent, please use this first,and set rgba")
        public void setTranslucentBlockRenderType() {
            this.setBlockRenderType(RenderType.m_110466_());
        }
    };

    default public int[] getColor() {
        return levelRenderHelper.getColor();
    }

    default public void setColor(int r, int g, int b, int a) {
        levelRenderHelper.setColor(r, g, b, a);
    }

    default public void restColor() {
        levelRenderHelper.setColor(255, 255, 255, 255);
    }

    default public void restBlockRenderType() {
        levelRenderHelper.setBlockRenderType(null);
    }

    default public void setBlockRenderType(RenderType renderType) {
        levelRenderHelper.setBlockRenderType(renderType);
    }

    default public RenderType getBlockRenderType() {
        return levelRenderHelper.getBlockRenderType();
    }

    @Info(value="If you want to make the block semi transparent, please use this first,and set rgba")
    default public void setTranslucentBlockRenderType() {
        levelRenderHelper.setBlockRenderType(RenderType.m_110466_());
    }

    default public MultiBufferSource.BufferSource getBufferSource() {
        return Minecraft.m_91087_().m_91269_().m_110104_();
    }

    default public void transformerCamera(PoseStack poseStack, Camera camera) {
        Vec3 position = camera.m_90583_();
        poseStack.m_85837_(-position.f_82479_, -position.f_82480_, -position.f_82481_);
    }

    default public void transformerToBlockPose(PoseStack poseStack, BlockPos blockPos) {
        poseStack.m_252880_((float)blockPos.m_123341_(), (float)blockPos.m_123342_(), (float)blockPos.m_123343_());
    }

    default public void renderSingleBlock(BlockState pState, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay, ModelData modelData, RenderType renderType) {
        RenderJSBlockRender.renderSingleBlock(pState, pPoseStack, pBufferSource, this.getColor()[0], this.getColor()[1], this.getColor()[2], this.getColor()[3], pPackedLight, pPackedOverlay, modelData, renderType);
    }

    default public void renderSingleBlock(BlockState pState, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay, ModelData modelData) {
        this.renderSingleBlock(pState, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay, modelData, this.getBlockRenderType());
    }

    default public void renderSingleBlock(BlockState pState, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        this.renderSingleBlock(pState, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay, ModelData.EMPTY);
    }

    default public void renderSingleBlock(BlockState pState, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight) {
        this.renderSingleBlock(pState, pPoseStack, pBufferSource, pPackedLight, OverlayTexture.f_118083_);
    }

    default public void renderSingleBlock(BlockState pState, PoseStack pPoseStack, MultiBufferSource pBufferSource) {
        this.renderSingleBlock(pState, pPoseStack, pBufferSource, LightTexture.m_109885_((int)15, (int)15));
    }

    default public void renderSingleBlock(BlockState pState, PoseStack pPoseStack) {
        this.renderSingleBlock(pState, pPoseStack, (MultiBufferSource)this.getBufferSource());
    }

    default public void renderHitOutline(BlockState pState, PoseStack pPoseStack, MultiBufferSource bufferSource, Entity pEntity, BlockPos pPos) {
        LevelRenderer.m_109782_((PoseStack)pPoseStack, (VertexConsumer)bufferSource.m_6299_(RenderType.m_110504_()), (VoxelShape)pState.m_60651_((BlockGetter)pEntity.m_9236_(), pPos, CollisionContext.m_82750_((Entity)pEntity)), (double)0.0, (double)0.0, (double)0.0, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
    }

    default public void renderHitOutline(BlockState pState, PoseStack pPoseStack, MultiBufferSource bufferSource, Entity pEntity) {
        this.renderHitOutline(pState, pPoseStack, bufferSource, pEntity, BlockPos.f_121853_);
    }

    default public void renderHitOutline(BlockState pState, PoseStack pPoseStack, MultiBufferSource bufferSource) {
        this.renderHitOutline(pState, pPoseStack, bufferSource, Minecraft.m_91087_().f_91075_, BlockPos.f_121853_);
    }

    default public void renderHitOutline(BlockState pState, PoseStack pPoseStack) {
        this.renderHitOutline(pState, pPoseStack, (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_());
    }

    default public void renderLevelItem(ItemStack pItemStack, PoseStack pPoseStack, MultiBufferSource pBuffer, int pCombinedLight, int pCombinedOverlay) {
        Minecraft.m_91087_().m_91291_().m_269128_(pItemStack, ItemDisplayContext.GROUND, pCombinedLight, pCombinedOverlay, pPoseStack, pBuffer, (Level)Minecraft.m_91087_().f_91073_, 0);
    }

    default public void renderLevelItem(ItemStack pItemStack, PoseStack pPoseStack, MultiBufferSource pBuffer, int pCombinedLight) {
        this.renderLevelItem(pItemStack, pPoseStack, pBuffer, pCombinedLight, OverlayTexture.f_118083_);
    }

    default public void renderLevelItem(ItemStack pItemStack, PoseStack pPoseStack, MultiBufferSource pBuffer) {
        this.renderLevelItem(pItemStack, pPoseStack, pBuffer, LightTexture.m_109885_((int)15, (int)15), OverlayTexture.f_118083_);
    }

    default public void renderLevelItem(ItemStack pItemStack, PoseStack pPoseStack) {
        this.renderLevelItem(pItemStack, pPoseStack, (MultiBufferSource)this.getBufferSource(), LightTexture.m_109885_((int)15, (int)15), OverlayTexture.f_118083_);
    }

    default public int packLight(Level level, BlockPos blockPos) {
        return LightTexture.m_109885_((int)level.m_45517_(LightLayer.BLOCK, blockPos), (int)level.m_45517_(LightLayer.SKY, blockPos));
    }
}

