/*
 * Decompiled with CFR 0.152.
 */
package umpaz.farmersrespite.common.crafting;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import umpaz.farmersrespite.common.registry.FRItems;
import umpaz.farmersrespite.common.registry.FRRecipeSerializers;
import umpaz.farmersrespite.common.registry.FRRecipeTypes;

public class KettlePouringRecipe
implements Recipe<RecipeWrapper> {
    private final ResourceLocation id;
    private final Fluid fluid;
    private final int amount;
    private final ItemStack container;
    private final ItemStack output;

    public KettlePouringRecipe(ResourceLocation id, Fluid fluid, ItemStack container, ItemStack output, int amount) {
        this.id = id;
        this.amount = amount;
        this.fluid = fluid;
        this.container = container;
        this.output = output;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredient = NonNullList.m_122779_();
        ingredient.add((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{this.container}));
        return ingredient;
    }

    public boolean matches(RecipeWrapper inv, Level level) {
        return Ingredient.m_43927_((ItemStack[])new ItemStack[]{this.container}).test(inv.m_8020_(4));
    }

    public ItemStack assemble(RecipeWrapper recipeWrapper, RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getContainer() {
        return this.container;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.output;
    }

    public int getAmount() {
        return this.amount;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)FRRecipeSerializers.KETTLE_POURING.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)FRRecipeTypes.KETTLE_POURING.get();
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)FRItems.KETTLE.get());
    }

    public int hashCode() {
        int result = this.m_6423_().hashCode();
        result = 31 * result + this.container.hashCode();
        result = 31 * result + this.fluid.hashCode();
        result = 31 * result + this.amount;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KettlePouringRecipe that = (KettlePouringRecipe)o;
        if (!this.m_6423_().equals((Object)that.m_6423_())) {
            return false;
        }
        if (!this.output.equals(that.output)) {
            return false;
        }
        if (this.amount != that.amount) {
            return false;
        }
        if (!this.fluid.equals(that.fluid)) {
            return false;
        }
        return this.container.equals(that.container);
    }

    public static class Serializer
    implements RecipeSerializer<KettlePouringRecipe> {
        public KettlePouringRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Fluid fluidIn = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"fluid")));
            int amountIn = GsonHelper.m_13824_((JsonObject)json, (String)"amount", (int)250);
            ItemStack container = GsonHelper.m_13900_((JsonObject)json, (String)"container") ? CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"container"), (boolean)true) : ItemStack.f_41583_;
            ItemStack outputIn = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"), (boolean)true);
            return new KettlePouringRecipe(recipeId, fluidIn, container, outputIn, amountIn);
        }

        @Nullable
        public KettlePouringRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Fluid fluidIn = buffer.readFluidStack().getFluid();
            int amountIn = buffer.m_130242_();
            ItemStack containerIn = buffer.m_130267_();
            ItemStack outputIn = buffer.m_130267_();
            return new KettlePouringRecipe(recipeId, fluidIn, containerIn, outputIn, amountIn);
        }

        public void toNetwork(FriendlyByteBuf buffer, KettlePouringRecipe recipe) {
            buffer.writeFluidStack(new FluidStack(recipe.fluid, 1000));
            buffer.m_130130_(recipe.amount);
            buffer.m_130055_(recipe.container);
            buffer.m_130055_(recipe.output);
        }
    }
}

