/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.utils;

import io.github.flemmli97.tenshilib.common.utils.MathUtils;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CircleSector {
    private final float theta;
    private final float radius;
    private final float rotAmount;
    private final Vec3 center;
    private final Vec3 rotAxis;
    private final Vec3 look;
    private final Entity entity;
    private final List<Vec3> vecs = new LinkedList<Vec3>();

    public CircleSector(Vec3 pos, Vec3 look, float radius, float theta, @Nullable Entity entity) {
        this.rotAmount = MathUtils.degToRad(theta > 120.0f ? 10.0f : (theta > 30.0f ? 5.0f : 3.0f));
        this.theta = MathUtils.degToRad(theta);
        this.radius = radius;
        this.rotAxis = MathUtils.rotate(MathUtils.rotate(new Vec3(0.0, 1.0, 0.0), new Vec3(1.0, 0.0, 0.0), (float)Mth.m_14136_((double)look.f_82479_, (double)look.f_82481_)), look, -MathUtils.degToRad(90.0f)).m_82541_();
        this.center = pos;
        this.look = look.m_82541_().m_82490_((double)radius);
        this.entity = entity;
        this.calculateVecs();
    }

    private void calculateVecs() {
        float rot;
        this.vecs.add(this.look);
        for (rot = -this.theta; rot < 0.0f; rot += this.rotAmount) {
            this.vecs.add(MathUtils.rotate(this.rotAxis, this.look, rot));
        }
        for (rot = this.theta; rot > 0.0f; rot -= this.rotAmount) {
            this.vecs.add(MathUtils.rotate(this.rotAxis, this.look, rot));
        }
    }

    public boolean intersects(Level world, AABB aabb) {
        if (aabb.m_82390_(this.center)) {
            return true;
        }
        for (Vec3 ray : this.vecs) {
            BlockHitResult blocks = world.m_45547_(new ClipContext(this.center, this.center.m_82549_(ray), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, this.entity));
            ray = blocks.m_6662_() != HitResult.Type.MISS ? blocks.m_82450_() : this.center.m_82549_(ray);
            if (!aabb.m_82371_(this.center, ray).isPresent()) continue;
            return true;
        }
        return false;
    }

    public void display(ServerLevel world) {
        float rot = -this.theta;
        Vec3 ray = MathUtils.rotate(this.rotAxis, this.look, rot);
        while (rot <= this.theta) {
            BlockHitResult blocks = world.m_45547_(new ClipContext(this.center, this.center.m_82549_(ray.m_82490_((double)this.radius)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, this.entity));
            float reach = (float)blocks.m_82450_().m_82554_(this.center);
            Vec3 from = this.look;
            Vec3 to = ray.m_82490_((double)reach).m_82490_(0.1);
            for (int i = 0; i < 10; ++i) {
                if (i == 9) {
                    world.m_8767_((ParticleOptions)ParticleTypes.f_123744_, from.f_82479_, from.f_82480_, from.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                } else {
                    world.m_8767_((ParticleOptions)ParticleTypes.f_123810_, from.f_82479_, from.f_82480_, from.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                }
                from = from.m_82549_(to);
            }
            ray = MathUtils.rotate(this.rotAxis, this.look, rot += this.rotAmount);
        }
    }
}

