/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity;

import io.github.flemmli97.tenshilib.api.entity.IBeamEntity;
import io.github.flemmli97.tenshilib.common.entity.EntityUtil;
import io.github.flemmli97.tenshilib.common.utils.MathUtils;
import io.github.flemmli97.tenshilib.common.utils.RayTraceUtils;
import io.github.flemmli97.tenshilib.platform.EventCalls;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public abstract class EntityBeam
extends Entity
implements IBeamEntity {
    private LivingEntity shooter;
    protected int livingTicks;
    protected int coolDown;
    protected HitResult hit;
    protected Vec3 hitVec;
    protected static final EntityDataAccessor<Optional<UUID>> SHOOTER_UUID = SynchedEntityData.m_135353_(EntityBeam.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected final Predicate<Entity> notShooter = entity -> entity != this.m_269323_() && EntitySelector.f_20408_.test(entity) && entity.m_6087_();

    public EntityBeam(EntityType<? extends EntityBeam> type, Level world) {
        super(type, world);
        this.f_19811_ = true;
    }

    public EntityBeam(EntityType<? extends EntityBeam> type, Level world, double x, double y, double z) {
        this(type, world);
        this.m_6034_(x, y, z);
    }

    public EntityBeam(EntityType<? extends EntityBeam> type, Level world, LivingEntity shooter) {
        this(type, world, shooter.m_20185_(), shooter.m_20186_() + (double)shooter.m_20192_() - 0.1, shooter.m_20189_());
        this.shooter = shooter;
        this.f_19804_.m_135381_(SHOOTER_UUID, Optional.of(shooter.m_20148_()));
        this.m_19915_(shooter.f_20885_, shooter.m_146909_());
    }

    public void setRotationTo(Entity target, float inaccuracy) {
        Vec3 targetPos = EntityUtil.getStraightProjectileTarget(this.m_20182_(), target);
        this.setRotationTo(targetPos.m_7096_(), targetPos.m_7098_(), targetPos.m_7094_(), inaccuracy);
    }

    public void setRotationTo(double x, double y, double z, float inaccuracy) {
        double dx = x - this.m_20185_();
        double dy = y - this.m_20186_();
        double dz = z - this.m_20189_();
        this.setRotationToDir(dx, dy, dz, inaccuracy);
    }

    public void setRotationToDir(double x, double y, double z, float inaccuracy) {
        double dis = Math.sqrt((x += this.f_19796_.m_188583_() * (double)inaccuracy) * x + (y += this.f_19796_.m_188583_() * (double)inaccuracy) * y + (z += this.f_19796_.m_188583_() * (double)inaccuracy) * z);
        this.m_146922_((float)(Mth.m_14136_((double)z, (double)x) * 180.0 / Math.PI) - 90.0f);
        this.m_146926_((float)(Math.acos(y / dis) * 180.0 / Math.PI) - 90.0f);
    }

    @Override
    public Vec3 startVec() {
        return this.m_20182_();
    }

    @Override
    public Vec3 hitVec() {
        return this.hit != null ? this.hitVec : this.startVec();
    }

    public float getRange() {
        return 32.0f;
    }

    public float radius() {
        return 0.0f;
    }

    public boolean piercing() {
        return false;
    }

    @Override
    public int livingTickMax() {
        return 20;
    }

    @Override
    public void updateYawPitch() {
        if (this.getHitVecFromShooter() && this.m_269323_() != null) {
            LivingEntity e = this.m_269323_();
            this.m_146926_(e.m_146909_());
            this.m_146922_(e.m_146908_());
            this.f_19860_ = e.f_19860_;
            this.f_19859_ = e.f_19859_;
            this.m_6034_(e.m_20185_(), e.m_20186_() + (double)e.m_20192_() - (double)0.1f, e.m_20189_());
        }
    }

    public boolean getHitVecFromShooter() {
        return false;
    }

    public boolean m_6783_(double distance) {
        return distance < (double)Math.max(1048.0f, (this.getRange() + 2.0f) * (this.getRange() + 2.0f));
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(SHOOTER_UUID, Optional.empty());
    }

    public void m_8119_() {
        this.updateYawPitch();
        if (this.hit == null || this.getHitVecFromShooter()) {
            this.hit = this.getHitRay();
            this.hitVec = this.hit.m_82450_();
            if (this.hit.m_6662_() == HitResult.Type.BLOCK) {
                Vec3 dir = this.hitVec.m_82546_(this.m_20182_()).m_82541_();
                this.hitVec = this.hitVec.m_82546_(dir.m_82490_((double)this.radius() * 0.3));
            }
        }
        super.m_8119_();
        ++this.livingTicks;
        if (!this.m_9236_().f_46443_) {
            if (this.livingTicks >= this.livingTickMax()) {
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
            if (this.hit != null && --this.coolDown <= 0 && this.m_6084_()) {
                List list = this.m_9236_().m_45933_((Entity)this, new AABB(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.hitVec.f_82479_, this.hitVec.f_82480_, this.hitVec.f_82481_).m_82400_((double)(1.0f + this.radius())));
                Vec3 pos = this.m_20182_();
                for (Entity entity : list) {
                    EntityHitResult raytraceresult;
                    if (entity.equals((Object)this.m_269323_()) || EntityUtil.isSameMultipart(entity, (Entity)this.m_269323_()) || !this.check(entity, pos, this.hitVec) || EventCalls.INSTANCE.beamHitCall(this, (HitResult)(raytraceresult = new EntityHitResult(entity)))) continue;
                    this.onImpact(raytraceresult);
                    this.coolDown = this.attackCooldown();
                    if (this.piercing()) continue;
                    return;
                }
            }
        }
    }

    public HitResult getHitRay() {
        return RayTraceUtils.entityRayTrace(this, this.getRange(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, !this.piercing(), true, this.notShooter);
    }

    protected boolean check(Entity e, Vec3 from, Vec3 to) {
        if (e.m_5833_() || !e.m_6084_() || !e.m_6087_()) {
            return false;
        }
        AABB aabb = e.m_20191_().m_82400_((double)this.radius() + 0.3);
        Optional ray = aabb.m_82371_(from, to);
        if (ray.isEmpty() && !aabb.m_82390_(this.m_20182_())) {
            return false;
        }
        if (this.radius() == 0.0f) {
            return true;
        }
        double dist = MathUtils.distTo(e, from, to);
        Vec3 dir = to.m_82546_(from).m_82541_().m_82490_(0.1);
        double maxdist = (double)(this.radius() + e.m_20205_()) + 0.3;
        return dist <= maxdist * maxdist && MathUtils.isInFront(e.m_20182_(), from, dir);
    }

    public abstract void onImpact(EntityHitResult var1);

    public int livingTicks() {
        return this.livingTicks;
    }

    public int attackCooldown() {
        return 20;
    }

    public void m_7378_(CompoundTag compound) {
        if (compound.m_128403_("Shooter")) {
            this.f_19804_.m_135381_(SHOOTER_UUID, Optional.of(compound.m_128342_("Shooter")));
        }
        this.shooter = this.m_269323_();
        this.livingTicks = compound.m_128451_("LivingTicks");
    }

    public void m_7380_(CompoundTag compound) {
        ((Optional)this.f_19804_.m_135370_(SHOOTER_UUID)).ifPresent(uuid -> compound.m_128362_("Shooter", uuid));
        compound.m_128405_("LivingTicks", this.livingTicks);
    }

    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(SHOOTER_UUID)).orElse(null);
    }

    public LivingEntity m_269323_() {
        if (this.shooter != null && !this.shooter.m_213877_()) {
            return this.shooter;
        }
        ((Optional)this.f_19804_.m_135370_(SHOOTER_UUID)).ifPresent(uuid -> {
            this.shooter = EntityUtil.findFromUUID(LivingEntity.class, this.m_9236_(), uuid);
        });
        return this.shooter;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

