/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.abnormals_delight.integration.jei;

import com.teamabnormals.abnormals_delight.core.other.ADTiers;
import com.teamabnormals.abnormals_delight.core.registry.ADItems;
import java.util.List;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.ModList;
import vectorwing.farmersdelight.common.registry.ModItems;

@JeiPlugin
public class ADPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("abnormals_delight", "abnormals_delight");
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(RecipeTypes.ANVIL, ADPlugin.getRepairRecipes(registration.getVanillaRecipeFactory()).toList());
    }

    private static Stream<RepairData> getRepairData() {
        Stream<RepairData> fdTools = Stream.of(new RepairData(Tiers.GOLD.m_6282_(), new ItemStack((ItemLike)ModItems.GOLDEN_KNIFE.get())), new RepairData(Tiers.NETHERITE.m_6282_(), new ItemStack((ItemLike)ModItems.NETHERITE_KNIFE.get())));
        Stream<RepairData> ccTools = Stream.of(new RepairData(ADTiers.SILVER.m_6282_(), new ItemStack((ItemLike)ADItems.SILVER_KNIFE.get())), new RepairData(ADTiers.NECROMIUM.m_6282_(), new ItemStack((ItemLike)ADItems.NECROMIUM_KNIFE.get())));
        return ModList.get().isLoaded("caverns_and_chasms") ? Stream.concat(fdTools, ccTools) : fdTools;
    }

    private static Stream<IJeiAnvilRecipe> getRepairRecipes(IVanillaRecipeFactory vanillaRecipeFactory) {
        return ADPlugin.getRepairData().flatMap(repairData -> ADPlugin.getRepairRecipes(repairData, vanillaRecipeFactory));
    }

    private static Stream<IJeiAnvilRecipe> getRepairRecipes(RepairData repairData, IVanillaRecipeFactory vanillaRecipeFactory) {
        Ingredient repairIngredient = repairData.getRepairIngredient();
        List<ItemStack> repairables = repairData.getRepairables();
        List<ItemStack> repairMaterials = List.of(repairIngredient.m_43908_());
        return repairables.stream().mapMulti((itemStack, consumer) -> {
            ItemStack damagedThreeQuarters = itemStack.m_41777_();
            damagedThreeQuarters.m_41721_(damagedThreeQuarters.m_41776_() * 3 / 4);
            ItemStack damagedHalf = itemStack.m_41777_();
            damagedHalf.m_41721_(damagedHalf.m_41776_() / 2);
            IJeiAnvilRecipe repairWithSame = vanillaRecipeFactory.createAnvilRecipe(List.of(damagedThreeQuarters), List.of(damagedThreeQuarters), List.of(damagedHalf));
            consumer.accept(repairWithSame);
            if (!repairMaterials.isEmpty()) {
                ItemStack damagedFully = itemStack.m_41777_();
                damagedFully.m_41721_(damagedFully.m_41776_());
                IJeiAnvilRecipe repairWithMaterial = vanillaRecipeFactory.createAnvilRecipe(List.of(damagedFully), repairMaterials, List.of(damagedThreeQuarters));
                consumer.accept(repairWithMaterial);
            }
        });
    }

    private static class RepairData {
        private final Ingredient repairIngredient;
        private final List<ItemStack> repairables;

        public RepairData(Ingredient repairIngredient, ItemStack ... repairables) {
            this.repairIngredient = repairIngredient;
            this.repairables = List.of(repairables);
        }

        public Ingredient getRepairIngredient() {
            return this.repairIngredient;
        }

        public List<ItemStack> getRepairables() {
            return this.repairables;
        }
    }
}

