/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.config;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.gson.JsonSyntaxException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.EnumUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.Kiwi;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.config.KiwiConfig;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.shadowed.org.yaml.snakeyaml.Yaml;
import snownee.kiwi.util.Util;

public class ConfigHandler {
    public static final String FILE_EXTENSION = ".yaml";
    private final String modId;
    private final String fileName;
    private final KiwiConfig.ConfigType type;
    @Nullable
    private final Class<?> clazz;
    private final Map<String, Value<?>> valueMap = Maps.newLinkedHashMap();
    private boolean hasModules;

    public ConfigHandler(String modId, String fileName, KiwiConfig.ConfigType type, Class<?> clazz, boolean hasModules) {
        this.hasModules = hasModules;
        this.modId = modId;
        this.clazz = clazz;
        this.fileName = fileName;
        this.type = type;
        KiwiConfigManager.register(this);
    }

    private static void flatten(Map<String, Object> src, Map<String, Object> dst, String path, Set<String> keys) {
        for (Map.Entry<String, Object> e : src.entrySet()) {
            String key = e.getKey();
            String newPath = path + key;
            if (e.getValue() instanceof Map && !keys.contains(newPath)) {
                ConfigHandler.flatten((Map)e.getValue(), dst, newPath + ".", keys);
                continue;
            }
            dst.put(newPath, e.getValue());
        }
    }

    static List<String> getPath(Field field) {
        List<String> annotatedPath = ConfigHandler.getPath((AnnotatedElement)field);
        return annotatedPath == null ? Collections.singletonList(field.getName()) : annotatedPath;
    }

    static List<String> getPath(AnnotatedElement annotatedElement) {
        KiwiConfig.Path path = annotatedElement.getDeclaredAnnotation(KiwiConfig.Path.class);
        if (path != null) {
            return List.of(path.value().split("\\."));
        }
        KiwiConfig.AdvancedPath advancedPath = annotatedElement.getDeclaredAnnotation(KiwiConfig.AdvancedPath.class);
        if (advancedPath != null) {
            return Arrays.asList(advancedPath.value());
        }
        return null;
    }

    private static Map<String, Object> getEndMap(Map<String, Object> map, List<String> path) {
        int l = path.size() - 1;
        for (int i = 0; i < l; ++i) {
            map = (Map)map.computeIfAbsent((String)path.get(i), $ -> Maps.newHashMap());
        }
        return map;
    }

    private static Object convert(Field field) {
        try {
            Class<?> type = field.getType();
            if (!(type == Integer.TYPE || type == Long.TYPE || type == Double.TYPE || type == Float.TYPE || type == Boolean.TYPE || type == String.class || Enum.class.isAssignableFrom(type) || List.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type))) {
                return null;
            }
            if (type == String.class) {
                String defaultVal = (String)field.get(null);
                if (defaultVal == null) {
                    defaultVal = "";
                }
                return defaultVal;
            }
            if (List.class.isAssignableFrom(type)) {
                List defaultVal = (List)field.get(null);
                if (defaultVal == null) {
                    defaultVal = List.of();
                }
                return defaultVal;
            }
            if (Map.class.isAssignableFrom(type)) {
                Map defaultVal = (Map)field.get(null);
                if (defaultVal == null) {
                    defaultVal = Map.of();
                }
                return defaultVal;
            }
            return field.get(null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Class<?> toPrimitiveClass(Class<?> clazz) {
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        return clazz;
    }

    private Path getConfigPath() {
        return Platform.getConfigDir().resolve(this.fileName + FILE_EXTENSION);
    }

    public void init() {
        this.build();
        Path configPath = this.getConfigPath();
        if (Files.exists(configPath, new LinkOption[0])) {
            this.refresh();
        }
        this.save();
    }

    public void refresh() {
        Map map;
        Path configPath = this.getConfigPath();
        try (FileReader reader = new FileReader(configPath.toFile(), StandardCharsets.UTF_8);){
            map = new Yaml().loadAs(reader, Map.class);
        }
        catch (Exception e) {
            this.save();
            return;
        }
        if (map == null || map.isEmpty()) {
            this.save();
            return;
        }
        HashMap flatMap = Maps.newHashMap();
        ConfigHandler.flatten(map, flatMap, "", this.valueMap.keySet());
        for (Map.Entry e : flatMap.entrySet()) {
            Value<?> value = this.valueMap.get(e.getKey());
            if (value == null) continue;
            Object $ = e.getValue();
            Class<?> type = value.getType();
            if (Enum.class.isAssignableFrom(type)) {
                $ = EnumUtils.getEnumIgnoreCase(type, (String)((String)$), (Enum)((Enum)type.getEnumConstants()[0]));
            }
            value.accept($);
        }
    }

    public void save() {
        Path configPath = this.getConfigPath();
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (Value<?> value : this.valueMap.values()) {
            List<String> path = List.of(value.path.split("\\."));
            Object v = value.field == null ? value.value : ConfigHandler.convert(value.field);
            value.accept(v);
            if (v instanceof Enum) {
                v = ((Enum)v).name();
            }
            ConfigHandler.getEndMap(map, path).put(path.get(path.size() - 1), v);
        }
        try (FileWriter writer = new FileWriter(configPath.toFile(), StandardCharsets.UTF_8);){
            writer.append("# Use Cloth Config mod for the descriptions.");
            writer.append('\n');
            writer.append("---");
            writer.append('\n');
            Util.dumpYaml(map, writer);
        }
        catch (JsonSyntaxException | IOException e) {
            Kiwi.LOGGER.error("Failed to save config file: %s".formatted(configPath), e);
        }
    }

    private void build() {
        int mods;
        if (this.hasModules) {
            KiwiConfigManager.defineModules(this.modId, this, !this.fileName.equals(this.modId + "-modules"));
        }
        if (this.clazz == null) {
            return;
        }
        Joiner joiner = Joiner.on((char)'.');
        for (Field field : this.clazz.getDeclaredFields()) {
            KiwiConfig.Range range;
            mods = field.getModifiers();
            if (!Modifier.isPublic(mods) || !Modifier.isStatic(mods) || Modifier.isFinal(mods) || field.getAnnotation(KiwiModule.Skip.class) != null) continue;
            List<String> path = ConfigHandler.getPath(field);
            String pathKey = joiner.join(path);
            KiwiConfig.Translation translation = field.getAnnotation(KiwiConfig.Translation.class);
            String translationKey = translation != null ? translation.value() : "%s.config.%s".formatted(this.modId, pathKey);
            Object converted = ConfigHandler.convert(field);
            if (converted == null) continue;
            Value<Object> value = this.define(pathKey, converted, field, translationKey);
            if (field.getAnnotation(KiwiConfig.LevelRestart.class) != null || field.getAnnotation(KiwiConfig.GameRestart.class) != null) {
                value.requiresRestart = true;
            }
            if ((range = field.getAnnotation(KiwiConfig.Range.class)) == null) continue;
            value.min = range.min();
            value.max = range.max();
        }
        for (AccessibleObject accessibleObject : this.clazz.getDeclaredMethods()) {
            KiwiConfig.Listen[] listens;
            mods = ((Method)accessibleObject).getModifiers();
            if (!Modifier.isPublic(mods) || !Modifier.isStatic(mods) || (listens = (KiwiConfig.Listen[])accessibleObject.getAnnotationsByType(KiwiConfig.Listen.class)).length == 0) continue;
            if (((Method)accessibleObject).getParameterCount() != 1 || ((Method)accessibleObject).getParameterTypes()[0] != String.class) {
                throw new IllegalArgumentException("Invalid listener method " + (Method)accessibleObject);
            }
            for (KiwiConfig.Listen listen : listens) {
                String path = listen.value();
                Value<?> value = this.valueMap.get(path);
                if (value == null) {
                    throw new IllegalArgumentException("No config value found for path " + path);
                }
                value.listener = accessibleObject;
            }
        }
    }

    public <T> Value<T> define(String path, T value, @Nullable Field field, String translation) {
        Value<T> v = new Value<T>(path, field, value, translation);
        this.valueMap.put(path, v);
        return v;
    }

    public void setHasModules(boolean hasModules) {
        this.hasModules = hasModules;
    }

    public boolean hasModules() {
        return this.hasModules;
    }

    public String getModId() {
        return this.modId;
    }

    public KiwiConfig.ConfigType getType() {
        return this.type;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getTranslationKey() {
        if (this.fileName.equals(this.modId + "-" + this.getType().extension())) {
            return this.getType().extension();
        }
        if (this.fileName.equals(this.modId + "-modules")) {
            return "modules";
        }
        return this.fileName;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public <T> Value<T> get(String path) {
        return this.valueMap.get(path);
    }

    public Map<String, Value<?>> getValueMap() {
        return this.valueMap;
    }

    public static class Value<T> {
        @NotNull
        public final T defValue;
        @Nullable
        public Field field;
        @NotNull
        public T value;
        public boolean requiresRestart;
        public String translation;
        public double min = Double.NaN;
        public double max = Double.NaN;
        public final String path;
        @Nullable
        Method listener;

        public Value(String path, @Nullable Field field, T value, String translation) {
            this.path = path;
            this.field = field;
            this.value = value;
            this.defValue = this.value;
            this.translation = translation;
        }

        public T get() {
            return this.value;
        }

        public Class<?> getType() {
            return this.field != null ? this.field.getType() : ConfigHandler.toPrimitiveClass(this.value.getClass());
        }

        public void accept(Object $) {
            try {
                Class<?> type = this.getType();
                if (type == Integer.TYPE) {
                    int min = Double.isNaN(this.min) ? Integer.MIN_VALUE : (int)this.min;
                    int max = Double.isNaN(this.max) ? Integer.MAX_VALUE : (int)this.max;
                    int value = ((Number)$).intValue();
                    $ = Mth.m_14045_((int)value, (int)min, (int)max);
                } else if (type == Float.TYPE) {
                    float min = Double.isNaN(this.min) ? Float.MIN_VALUE : (float)this.min;
                    float max = Double.isNaN(this.max) ? Float.MAX_VALUE : (float)this.max;
                    float value = ((Number)$).floatValue();
                    $ = Float.valueOf(Mth.m_14036_((float)value, (float)min, (float)max));
                } else if (type == Double.TYPE) {
                    double min = Double.isNaN(this.min) ? Double.MIN_VALUE : this.min;
                    double max = Double.isNaN(this.max) ? Double.MAX_VALUE : this.max;
                    double value = ((Number)$).doubleValue();
                    $ = Mth.m_14008_((double)value, (double)min, (double)max);
                } else if (type == Long.TYPE) {
                    long min = Double.isNaN(this.min) ? Long.MIN_VALUE : (long)this.min;
                    long max = Double.isNaN(this.max) ? Long.MAX_VALUE : (long)this.max;
                    long value = ((Number)$).longValue();
                    $ = Math.min(Math.max(value, min), max);
                }
                if (this.field != null) {
                    if (type == Boolean.TYPE) {
                        this.field.setBoolean(null, (Boolean)$);
                    } else if (type == Integer.TYPE) {
                        this.field.setInt(null, (Integer)$);
                    } else if (type == Float.TYPE) {
                        this.field.setFloat(null, ((Float)$).floatValue());
                    } else if (type == Double.TYPE) {
                        this.field.setDouble(null, (Double)$);
                    } else if (type == Long.TYPE) {
                        this.field.setLong(null, (Long)$);
                    } else {
                        this.field.set(null, $);
                    }
                }
                boolean changed = !Objects.equals(this.value, $);
                this.value = $;
                if (changed && this.listener != null) {
                    this.listener.invoke(null, this.path);
                }
            }
            catch (Exception e1) {
                Kiwi.LOGGER.error("Failed to set config value %s: %s".formatted(this.path, $), (Throwable)e1);
            }
        }

        public <A extends Annotation> A getAnnotation(Class<A> clazz) {
            return this.field == null ? null : (A)this.field.getAnnotation(clazz);
        }
    }
}

