/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.docs.formatter.formatter.jdoc;

import com.probejs.docs.formatter.formatter.IFormatter;
import com.probejs.jdoc.document.AbstractDocument;
import com.probejs.jdoc.document.AbstractDocumentBase;
import com.probejs.jdoc.property.PropertyComment;
import java.util.ArrayList;
import java.util.List;

public abstract class DocumentFormatter<T extends AbstractDocumentBase<T>>
implements IFormatter {
    protected final T document;

    public DocumentFormatter(T document) {
        this.document = document;
    }

    protected abstract List<String> formatDocument(Integer var1, Integer var2);

    public boolean hasComment() {
        return true;
    }

    public boolean canHide() {
        return true;
    }

    @Override
    public final List<String> format(Integer indent, Integer stepIndent) {
        PropertyComment comments;
        if (((AbstractDocumentBase)this.document).isHidden() && this.canHide()) {
            return List.of();
        }
        ArrayList<String> lines = new ArrayList<String>();
        T t = this.document;
        if (t instanceof AbstractDocument) {
            AbstractDocument doc = (AbstractDocument)t;
            v0 = doc.getMergedComment();
        } else {
            v0 = comments = new PropertyComment();
        }
        if (!comments.isEmpty() && this.hasComment()) {
            lines.addAll(comments.formatLines(indent));
        }
        lines.addAll(this.formatDocument(indent, stepIndent));
        return lines;
    }
}

