/*
 * Decompiled with CFR 0.152.
 */
package com.probejs;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.datafixers.util.Pair;
import com.probejs.ProbeConfig;
import com.probejs.ProbeJS;
import com.probejs.ProbePaths;
import com.probejs.docs.DocCompiler;
import com.probejs.docs.formatter.ClassResolver;
import com.probejs.docs.formatter.NameResolver;
import com.probejs.features.plugin.DocGenerationEventJS;
import com.probejs.features.plugin.ProbeJSEvents;
import com.probejs.features.rich.fluid.RichFluidCompiler;
import com.probejs.features.rich.item.RichItemCompiler;
import com.probejs.features.rich.lang.RichLangCompiler;
import com.probejs.jdoc.RemoteSchema;
import com.probejs.specials.SnippetCompiler;
import com.probejs.specials.SpecialCompiler;
import dev.architectury.platform.Platform;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import org.apache.commons.io.FileUtils;

public class ProbeCommands {
    public static ServerLevel COMMAND_LEVEL = null;
    public static Thread compileThread = null;
    public static Thread resolveRenderThread = null;

    public static <T> Registry<T> getRegistry(ResourceKey<Registry<T>> registryKey) {
        Registry builtinRegistry = RegistryInfo.of(registryKey).getVanillaRegistry();
        if (builtinRegistry == null) {
            builtinRegistry = (Registry)COMMAND_LEVEL.m_9598_().m_6632_(registryKey).get();
        }
        return builtinRegistry;
    }

    public static void triggerRender(Consumer<String> sendMessage) {
        if (resolveRenderThread != null && resolveRenderThread.isAlive()) {
            sendMessage.accept("Skipping image rendering due to previous render thread still running.");
        } else if (resolveRenderThread != null) {
            sendMessage.accept("Previous render thread is dead! Please check out latest.log and submit an error report.");
            resolveRenderThread = null;
        }
        resolveRenderThread = new Thread(() -> {
            sendMessage.accept("Resolving things to render...");
            List<Pair<ItemStack, Path>> items = RichItemCompiler.resolve();
            sendMessage.accept("Items resolved, will render " + items.size() + " items.");
            List<Pair<Fluid, Path>> fluids = RichFluidCompiler.resolve();
            sendMessage.accept("Fluids resolved, will render " + fluids.size() + " fluids.");
            Minecraft.m_91087_().execute(() -> {
                try {
                    sendMessage.accept("Images rendered.");
                }
                catch (Throwable e) {
                    sendMessage.accept("Error occurred while rendering images! Please check out latest.log and submit an error report.");
                    ProbeJS.LOGGER.error("Error:", e);
                }
            });
            resolveRenderThread = null;
        });
        resolveRenderThread.setUncaughtExceptionHandler((t, e) -> {
            sendMessage.accept("Error occurred while rendering images! Please check out latest.log and submit an error report.");
            ProbeJS.LOGGER.error("Error:", e);
            resolveRenderThread = null;
        });
        resolveRenderThread.setDaemon(true);
        resolveRenderThread.start();
    }

    public static void triggerDump(ServerPlayer player) {
        if (compileThread != null && compileThread.isAlive()) {
            player.m_240418_((Component)Component.m_237113_((String)"ProbeJS is running! Please wait for current dump to finish."), false);
            return;
        }
        if (compileThread != null) {
            player.m_240418_((Component)Component.m_237113_((String)"ProbeJS dumping thread is dead! Please check out latest.log and submit an error report."), false);
            compileThread = null;
        }
        player.f_8924_.kjs$runCommandSilent("reload");
        player.f_8924_.kjs$runCommandSilent("kubejs dump_internals events");
        ProbeConfig.reload();
        COMMAND_LEVEL = (ServerLevel)player.m_9236_();
        Instant start = Instant.now();
        Consumer<String> sendMessage = s -> {
            Instant end = Instant.now();
            Duration duration = Duration.between(start, end);
            long sub = TimeUnit.MILLISECONDS.convert(duration.getNano(), TimeUnit.NANOSECONDS);
            player.m_240418_((Component)Component.m_237113_((String)(s + " [%s.%03ds]".formatted(duration.getSeconds(), sub))), false);
        };
        compileThread = new Thread(() -> {
            try {
                SpecialCompiler.specialCompilers.clear();
                DocGenerationEventJS event = new DocGenerationEventJS();
                ProbeJSEvents.DOC_GEN.post((ScriptTypeHolder)ScriptType.SERVER, (EventJS)event);
                sendMessage.accept("Started generating type files...");
                SnippetCompiler.compile(event);
                RichItemCompiler.compile();
                RichFluidCompiler.compile();
                RichLangCompiler.compile();
                sendMessage.accept("Snippets generated.");
                ClassResolver.init();
                NameResolver.init();
                DocCompiler.compile(sendMessage, event);
                if (ProbeConfig.INSTANCE.pullSchema) {
                    RemoteSchema.dumpSchemas(sendMessage);
                }
            }
            catch (Exception e) {
                ProbeJS.LOGGER.error("Uncaught exception has occurred!", (Throwable)e);
                player.m_240418_((Component)Component.m_237113_((String)"Uncaught exception happened in wrapper, please report to the Github issue with complete latest.log."), false);
            }
            sendMessage.accept("ProbeJS typing generation finished.");
            compileThread = null;
        });
        compileThread.setUncaughtExceptionHandler((t, e) -> {
            ProbeJS.LOGGER.error("Uncaught exception has occurred!", e);
            for (StackTraceElement stackTraceElement : e.getStackTrace()) {
                ProbeJS.LOGGER.error(stackTraceElement.toString());
            }
            sendMessage.accept("ProbeJS has run into an error! Please check out latest.log and report to GitHub!");
        });
        compileThread.setDaemon(true);
        compileThread.start();
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"probejs").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"dump").requires(source -> (!ProbeConfig.INSTANCE.requireSingleAndPerm || source.m_81377_().m_129792_() && source.m_6761_(2)) && ProbeConfig.INSTANCE.enabled)).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
            if (player != null) {
                if (Platform.getMods().size() >= 350) {
                    player.m_240418_((Component)Component.m_237113_((String)"There are more than 350 mods installed. You might want to disable some feature to prevent lag in VSCode."), false);
                }
                ProbeCommands.triggerDump(player);
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"clear_cache").requires(source -> source.m_81377_().m_129792_())).executes(context -> {
            ProbeConfig.INSTANCE.docsTimestamp = 0L;
            for (File file : Objects.requireNonNull(ProbePaths.CACHE.toFile().listFiles())) {
                try {
                    if (file.isFile()) {
                        if (file.delete()) {
                            ProbeJS.LOGGER.info("Deleted file: " + file.getName());
                            continue;
                        }
                        ProbeJS.LOGGER.warn("Failed to delete file: " + file.getName());
                        continue;
                    }
                    FileUtils.deleteDirectory((File)file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"configure").requires(source -> source.m_81377_().m_129792_())).then(Commands.m_82127_((String)"toggle_aggressive").executes(context -> {
            boolean aggressive = ProbeConfig.INSTANCE.toggleAggressiveProbing();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Aggressive mode is now: %s".formatted(aggressive ? "disabled" : "enabled")), false);
            ProbeConfig.INSTANCE.save();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Changes will be applied next time you start the game."), false);
            return 1;
        }))).then(Commands.m_82127_((String)"toggle_registry_dumps").executes(context -> {
            ProbeConfig.INSTANCE.allowRegistryObjectDumps = !ProbeConfig.INSTANCE.allowRegistryObjectDumps;
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Dump of object classes in registries: %s".formatted(ProbeConfig.INSTANCE.allowRegistryObjectDumps ? "enabled" : "disabled")), false);
            ProbeConfig.INSTANCE.save();
            return 1;
        }))).then(Commands.m_82127_((String)"toggle_registry_literals").executes(context -> {
            ProbeConfig.INSTANCE.allowRegistryLiteralDumps = !ProbeConfig.INSTANCE.allowRegistryLiteralDumps;
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Dump of literals in registries: %s".formatted(ProbeConfig.INSTANCE.allowRegistryLiteralDumps ? "enabled" : "disabled")), false);
            return 1;
        }))).then(Commands.m_82127_((String)"toggle_dump_req").executes(context -> {
            ProbeConfig.INSTANCE.requireSingleAndPerm = !ProbeConfig.INSTANCE.requireSingleAndPerm;
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Dump command now %srequire%s single player and cheat enabled".formatted(ProbeConfig.INSTANCE.requireSingleAndPerm ? "" : "does not ", ProbeConfig.INSTANCE.requireSingleAndPerm ? "s" : "")), false);
            ProbeConfig.INSTANCE.save();
            return 1;
        }))).then(Commands.m_82127_((String)"toggle_enable").executes(context -> {
            ProbeConfig.INSTANCE.enabled = !ProbeConfig.INSTANCE.enabled;
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"ProbeJS is now %s".formatted(ProbeConfig.INSTANCE.enabled ? "enabled" : "disabled")), false);
            ProbeConfig.INSTANCE.save();
            return 1;
        }))).then(Commands.m_82127_((String)"toggle_recipe_json").executes(context -> {
            ProbeConfig.INSTANCE.disableRecipeJsonDump = !ProbeConfig.INSTANCE.disableRecipeJsonDump;
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Snippets of Recipe JSON is now %s".formatted(ProbeConfig.INSTANCE.disableRecipeJsonDump ? "disabled" : "enabled")), false);
            ProbeConfig.INSTANCE.save();
            return 1;
        }))).then(Commands.m_82127_((String)"toggle_json_intermediates").executes(context -> {
            ProbeConfig.INSTANCE.dumpJSONIntermediates = !ProbeConfig.INSTANCE.dumpJSONIntermediates;
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"JSON intermediates dumping is now %s".formatted(ProbeConfig.INSTANCE.dumpJSONIntermediates ? "enabled" : "disabled")), false);
            ProbeConfig.INSTANCE.save();
            return 1;
        }))).then(Commands.m_82127_((String)"toggle_schema_download").executes(context -> {
            ProbeConfig.INSTANCE.pullSchema = !ProbeConfig.INSTANCE.pullSchema;
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Schema downloading is now %s".formatted(ProbeConfig.INSTANCE.pullSchema ? "enabled" : "disabled")), false);
            ProbeConfig.INSTANCE.save();
            return 1;
        })))).then(Commands.m_82127_((String)"test_availability").executes(ctx -> {
            boolean local = ((CommandSourceStack)ctx.getSource()).m_81377_().m_129792_();
            boolean perm = ((CommandSourceStack)ctx.getSource()).m_6761_(2);
            Consumer<String> sendMessage = s -> ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)s), false);
            if (local && perm) {
                sendMessage.accept("You should can execute ProbeJS dump.");
            } else {
                if (!local) {
                    sendMessage.accept("This doesn't seem to be a Local environment, or the executor is not a player at all!");
                } else {
                    sendMessage.accept("It doesn't seem like you have permission to execute the dump command!");
                }
                sendMessage.accept("If you're sure that you need a dump, run \"/probejs configure toggle_dump_req\" to turn off the check!");
            }
            return 1;
        })));
    }
}

