/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.quality_food.registry;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.cadentem.quality_food.core.Quality;
import de.cadentem.quality_food.core.commands.QualityArgument;
import de.cadentem.quality_food.core.commands.QualityItemArgument;
import de.cadentem.quality_food.util.QualityUtils;
import de.cadentem.quality_food.util.Utils;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.registries.DeferredRegister;

public class QFCommands {
    public static final DeferredRegister<ArgumentTypeInfo<?, ?>> COMMAND_ARGUMENTS = DeferredRegister.create((ResourceKey)Registries.f_256982_, (String)"quality_food");

    public static void registerCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"quality_food").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"give").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"quality", (ArgumentType)new QualityArgument()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"item", (ArgumentType)QualityItemArgument.item(event.getBuildContext())).executes(context -> QFCommands.giveItem((CommandSourceStack)context.getSource(), ItemArgument.m_120963_((CommandContext)context, (String)"item"), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), 1, QualityArgument.get(context)))).then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> QFCommands.giveItem((CommandSourceStack)context.getSource(), ItemArgument.m_120963_((CommandContext)context, (String)"item"), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"count"), QualityArgument.get(context))))))))).then(Commands.m_82127_((String)"apply").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"quality", (ArgumentType)new QualityArgument()).executes(context -> QFCommands.applyQuality((CommandSourceStack)context.getSource(), QualityArgument.get(context), false))).then(Commands.m_82129_((String)"override", (ArgumentType)BoolArgumentType.bool()).executes(context -> QFCommands.applyQuality((CommandSourceStack)context.getSource(), QualityArgument.get(context), BoolArgumentType.getBool((CommandContext)context, (String)"override"))))))).then(Commands.m_82127_((String)"remove").executes(context -> QFCommands.removeQuality((CommandSourceStack)context.getSource()))));
    }

    private static int applyQuality(CommandSourceStack source, Quality quality, boolean shouldOverride) {
        if (quality.level() == 0) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.quality_food.quality.failed.invalid_quality"));
            return 0;
        }
        Entity entity = source.m_81373_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingSource = (LivingEntity)entity;
            ItemStack stack = livingSource.m_21205_();
            if (!Utils.isValidItem(stack)) {
                source.m_81352_((Component)Component.m_237110_((String)"commands.quality_food.quality.failed.no_quality", (Object[])new Object[]{stack.m_41611_()}));
                return 0;
            }
            if (QualityUtils.hasQuality(stack) && !shouldOverride) {
                source.m_81352_((Component)Component.m_237110_((String)"commands.quality_food.quality.failed.already_has_quality", (Object[])new Object[]{stack.m_41611_()}));
                return 0;
            }
            if (shouldOverride && stack.m_41783_() != null) {
                stack.m_41783_().m_128473_("quality_food");
            }
            QualityUtils.applyQuality(stack, quality);
            return 1;
        }
        return 0;
    }

    private static int removeQuality(CommandSourceStack source) {
        Entity entity = source.m_81373_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingSource = (LivingEntity)entity;
            ItemStack stack = livingSource.m_21205_();
            if (stack.m_41783_() != null) {
                stack.m_41783_().m_128473_("quality_food");
                return 1;
            }
            source.m_81352_((Component)Component.m_237110_((String)"commands.quality_food.quality.failed.missing_quality", (Object[])new Object[]{stack.m_41611_()}));
            return 0;
        }
        return 0;
    }

    private static int giveItem(CommandSourceStack source, ItemInput input, Collection<ServerPlayer> players, int count, Quality quality) throws CommandSyntaxException {
        if (quality.level() == 0) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.quality_food.quality.failed.invalid_quality"));
            return 0;
        }
        int maxStackSize = input.m_120979_().m_41459_();
        int maxCount = maxStackSize * 100;
        ItemStack tempStack = input.m_120980_(1, false);
        if (QualityUtils.hasQuality(tempStack) || !Utils.isValidItem(tempStack)) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.quality_food.quality.failed.no_quality", (Object[])new Object[]{tempStack.m_41611_()}));
            return 0;
        }
        if (count > maxCount) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.give.failed.toomanyitems", (Object[])new Object[]{maxCount, tempStack.m_41611_()}));
            return 0;
        }
        for (ServerPlayer player : players) {
            int toGive = count;
            while (toGive > 0) {
                ItemEntity entity;
                int min = Math.min(toGive, maxStackSize);
                toGive -= min;
                ItemStack stack = input.m_120980_(min, false);
                QualityUtils.applyQuality(stack, quality);
                boolean wasAdded = player.m_150109_().m_36054_(stack);
                if (wasAdded && stack.m_41619_()) {
                    stack.m_41764_(1);
                    entity = player.m_36176_(stack, false);
                    if (entity != null) {
                        entity.m_32065_();
                    }
                    player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, (player.m_217043_().m_188501_() - player.m_217043_().m_188501_() * 0.7f + 1.0f) * 2.0f);
                    player.f_36096_.m_38946_();
                    continue;
                }
                entity = player.m_36176_(stack, false);
                if (entity == null) continue;
                entity.m_32061_();
                entity.m_266426_(player.m_20148_());
            }
        }
        if (players.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)"commands.give.success.single", (Object[])new Object[]{count, tempStack.m_41611_(), ((ServerPlayer)players.iterator().next()).m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"commands.give.success.single", (Object[])new Object[]{count, tempStack.m_41611_(), players.size()}), true);
        }
        return players.size();
    }

    static {
        COMMAND_ARGUMENTS.register("quality", () -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass(QualityArgument.class, (ArgumentTypeInfo)SingletonArgumentInfo.m_235451_(QualityArgument::new)));
        COMMAND_ARGUMENTS.register("item", () -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass(QualityItemArgument.class, (ArgumentTypeInfo)SingletonArgumentInfo.m_235449_(QualityItemArgument::item)));
    }
}

