/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.quality_food.core;

import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public enum Quality {
    NONE("none"),
    IRON("iron"),
    GOLD("gold"),
    DIAMOND("diamond"),
    UNDEFINED("none"),
    NONE_PLAYER_PLACED("none");

    private final Component translation;

    private Quality(String name) {
        this.translation = Component.m_237115_((String)("quality_type.quality_food." + name));
    }

    public Component getTranslation() {
        return this.translation;
    }

    @NotNull
    public static Quality get(int ordinal) {
        return Quality.get(ordinal, false);
    }

    @NotNull
    public static Quality get(int ordinal, boolean wasHarvested) {
        if (ordinal < 0 || ordinal >= Quality.values().length) {
            return NONE;
        }
        if (wasHarvested && ordinal == NONE_PLAYER_PLACED.ordinal()) {
            return NONE_PLAYER_PLACED;
        }
        return switch (ordinal) {
            case 1 -> IRON;
            case 2 -> GOLD;
            case 3, 4 -> DIAMOND;
            default -> NONE;
        };
    }

    @NotNull
    public static Quality byName(String name) {
        return switch (name.toLowerCase()) {
            case "iron" -> IRON;
            case "gold" -> GOLD;
            case "diamond" -> DIAMOND;
            default -> NONE;
        };
    }

    public int level() {
        return switch (this) {
            case IRON -> 1;
            case GOLD -> 2;
            case DIAMOND -> 3;
            default -> 0;
        };
    }

    public String getName() {
        return switch (this) {
            case IRON -> "Iron";
            case GOLD -> "Gold";
            case DIAMOND, UNDEFINED -> "Diamond";
            default -> "";
        };
    }
}

