/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.quality_food.config;

import de.cadentem.quality_food.QualityFood;
import de.cadentem.quality_food.compat.Compat;
import de.cadentem.quality_food.config.FarmlandConfig;
import de.cadentem.quality_food.config.QualityConfig;
import de.cadentem.quality_food.core.Quality;
import de.cadentem.quality_food.util.QualityUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.Tags;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ServerConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final Map<Quality, QualityConfig> QUALITY_CONFIG;
    public static final List<FarmlandConfig> FARMLAND_CONFIG;
    public static final ForgeConfigSpec.DoubleValue LUCK_MULTIPLIER;
    public static final ForgeConfigSpec.DoubleValue CROP_TARGET_CHANCE;
    public static final ForgeConfigSpec.DoubleValue SEED_CHANCE_MULTIPLIER;
    public static final ForgeConfigSpec.BooleanValue QUARK_HANDLE_CONFIG;
    public static final ForgeConfigSpec.BooleanValue HANDLE_COMPACTING;
    public static final ForgeConfigSpec.BooleanValue HANDLE_SEED_RECIPES;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> NO_QUALITY_RECIPES;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> RETAIN_QUALITY_RECIPES;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> FARMLAND_CONFIG_INTERNAL;
    private static final List<String> NO_QUALITY_RECIPES_DEFAULT;
    private static final List<String> RETAIN_QUALITY_RECIPES_DEFAULT;

    @SubscribeEvent
    public static void reloadConfig(ModConfigEvent event) {
        if (event.getConfig().getSpec() == SPEC && SPEC.isLoaded()) {
            QUALITY_CONFIG.values().forEach(QualityConfig::initializeEffects);
            FARMLAND_CONFIG.clear();
            ((List)FARMLAND_CONFIG_INTERNAL.get()).forEach(entry -> FARMLAND_CONFIG.add(new FarmlandConfig((String)entry)));
            FARMLAND_CONFIG.sort(Comparator.comparingInt(entry -> entry.index));
            QualityFood.LOG.info("Reloaded configuration");
            QualityFood.LOG.info("- Farmland config: {}", FARMLAND_CONFIG);
        }
    }

    public static boolean isNoQualityRecipe(@Nullable Recipe<?> recipe) {
        if (recipe == null) {
            return false;
        }
        return ((List)NO_QUALITY_RECIPES.get()).contains(recipe.m_6423_().toString());
    }

    public static boolean isRetainQualityRecipe(@Nullable Recipe<?> recipe, @Nullable RegistryAccess access) {
        if (recipe == null) {
            return false;
        }
        if (((Boolean)HANDLE_SEED_RECIPES.get()).booleanValue()) {
            if (access == null && ServerLifecycleHooks.getCurrentServer() != null) {
                access = ServerLifecycleHooks.getCurrentServer().m_206579_();
            }
            if (access != null && recipe.m_8043_(access).m_204117_(Tags.Items.SEEDS)) {
                return true;
            }
        }
        return ((List)RETAIN_QUALITY_RECIPES.get()).contains(recipe.m_6423_().toString());
    }

    public static float getFarmlandMultiplier(BlockState crop, BlockState farmland) {
        if (crop != null && farmland != null) {
            for (FarmlandConfig farmlandConfig : FARMLAND_CONFIG) {
                if (!farmlandConfig.predicate.test(crop, farmland)) continue;
                return (float)farmlandConfig.multiplier;
            }
        }
        return 1.0f;
    }

    private static boolean validateRecipe(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            return ResourceLocation.m_135830_((String)string);
        }
        return false;
    }

    private static boolean validateFarmlandConfig(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            String[] data = string.split(";");
            if (data.length != 4) {
                return false;
            }
            if (ServerConfig.isInvalidInteger(data[0])) {
                return false;
            }
            if (ServerConfig.isInvalidResource(data[1], true)) {
                return false;
            }
            if (ServerConfig.isInvalidResource(data[2], true)) {
                return false;
            }
            try {
                double multiplier = Double.parseDouble(data[3]);
                if (multiplier < 0.0) {
                    return false;
                }
            }
            catch (NumberFormatException ignored) {
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isEffectListValid(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            String[] data = string.split(";");
            if (data.length != 6) {
                return false;
            }
            if (ServerConfig.isInvalidResource(data[0], true)) {
                return false;
            }
            if (ServerConfig.isInvalidResource(data[1], false)) {
                return false;
            }
            if (ServerConfig.isInvalidChance(data[2])) {
                return false;
            }
            if (ServerConfig.isInvalidInteger(data[3])) {
                return false;
            }
            if (ServerConfig.isInvalidInteger(data[4])) {
                return false;
            }
            return !ServerConfig.isInvalidChance(data[5]);
        }
        return false;
    }

    private static boolean isInvalidResource(String resource, boolean allowTags) {
        if (resource == null) {
            return true;
        }
        if (allowTags && resource.startsWith("#")) {
            return !ResourceLocation.m_135830_((String)resource.substring(1));
        }
        return !ResourceLocation.m_135830_((String)resource);
    }

    private static boolean isInvalidChance(String value) {
        if (value == null) {
            return true;
        }
        try {
            double chance = Double.parseDouble(value);
            return chance < 0.0 || chance > 1.0;
        }
        catch (NumberFormatException numberFormatException) {
            return true;
        }
    }

    private static boolean isInvalidInteger(String value) {
        if (value == null) {
            return true;
        }
        if (value.contains(".") || value.contains(",")) {
            return true;
        }
        try {
            return Integer.parseInt(value) < 0;
        }
        catch (NumberFormatException numberFormatException) {
            return true;
        }
    }

    private static void fillNoQualityRecipes() {
        NO_QUALITY_RECIPES_DEFAULT.add("minecraft:hay_block");
        NO_QUALITY_RECIPES_DEFAULT.add("minecraft:wheat");
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("quark", "building/crafting/compressed/apple_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("quark", "building/crafting/compressed/apple_crate_uncompress").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("quark", "building/crafting/compressed/beetroot_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("quark", "building/crafting/compressed/beetroot_crate_uncompress").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("quark", "building/crafting/compressed/berry_sack").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("quark", "building/crafting/compressed/berry_sack_uncompress").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("quark", "building/crafting/compressed/carrot_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("quark", "building/crafting/compressed/carrot_crate_uncompress").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("quark", "building/crafting/compressed/chorus_fruit_block").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("quark", "building/crafting/compressed/chorus_fruit_block_uncompress").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("quark", "building/crafting/compressed/cocoa_bean_sack").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("quark", "building/crafting/compressed/cocoa_bean_sack_uncompress").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("quark", "building/crafting/compressed/glowberry_sack").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("quark", "building/crafting/compressed/glowberry_sack_uncompress").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("quark", "building/crafting/compressed/golden_apple_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("quark", "building/crafting/compressed/golden_apple_crate_uncompress").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("quark", "building/crafting/compressed/golden_carrot_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("quark", "building/crafting/compressed/golden_carrot_crate_uncompress").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("quark", "building/crafting/compressed/potato_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("quark", "building/crafting/compressed/potato_crate_uncompress").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("quark", "building/crafting/compressed/sugar_cane_block").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("quark", "building/crafting/compressed/sugar_cane_block_uncompress").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farmersdelight", "carrot_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farmersdelight", "carrot_from_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farmersdelight", "potato_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farmersdelight", "potato_from_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farmersdelight", "beetroot_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farmersdelight", "beetroot_from_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farmersdelight", "cabbage_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farmersdelight", "cabbage").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farmersdelight", "tomato_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farmersdelight", "tomato").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farmersdelight", "onion_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farmersdelight", "onion").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farmersdelight", "rice_bale").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farmersdelight", "rice_panicle").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farmersdelight", "rice_bag").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farmersdelight", "rice_from_bag").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("vinery", "white_grape_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("vinery", "white_grape").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("vinery", "red_grape_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("vinery", "red_grape").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("vinery", "cherry_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("vinery", "cherries").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("vinery", "apple_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("vinery", "apples").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("supplementaries", "sugar_cube").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("supplementaries", "sugar_cube_uncrafting").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("cratedelight", "apple_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("cratedelight", "apples").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("cratedelight", "beetroot_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("cratedelight", "beetroots").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("cratedelight", "berry_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("cratedelight", "berries").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("cratedelight", "brown_mushroom_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("cratedelight", "brown_mushroom").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("cratedelight", "carrot_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("cratedelight", "carrots").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("cratedelight", "cocoabeans_bag").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("cratedelight", "cocoabeans").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("cratedelight", "cod_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("cratedelight", "cod").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("cratedelight", "egg_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("cratedelight", "eggs").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("cratedelight", "glowberry_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("cratedelight", "glowberries").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("cratedelight", "golden_apple_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("cratedelight", "golden_apple").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("cratedelight", "golden_carrot_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("cratedelight", "golden_carrot").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("cratedelight", "potato_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("cratedelight", "potatoes").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("cratedelight", "red_mushroom_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("cratedelight", "red_mushroom").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("cratedelight", "salmon_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("cratedelight", "salmon").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("cratedelight", "stacked_melons").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("cratedelight", "melons").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("cratedelight", "stacked_pumpkins").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("cratedelight", "pumpkins").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("cratedelight", "sugar_bag").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("cratedelight", "sugar").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("alexsmobs", "banana_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("alexsmobs", "bananas").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("alexsmobs", "caiman_egg_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("alexsmobs", "caiman_egg").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("alexsmobs", "crocodile_egg_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("alexsmobs", "crocodile_egg").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("alexsmobs", "emu_egg_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("alexsmobs", "emu_egg").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("alexsmobs", "platypus_egg_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("alexsmobs", "platypus_egg").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("alexsmobs", "terrapin_egg_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("alexsmobs", "terrapin_egg").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("betterend", "end_fish_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("betterend", "end_fish").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("create", "wheat_flour_bag").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("create", "wheat_flour").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("diamond_apples", "diamond_apple_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("diamond_apples", "diamond_apples").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farmersdelight", "stacked_melons").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farmersdelight", "stacked_pumpkins").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("jagmkiwis", "kiwi_egg_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("jagmkiwis", "kiwi_egg").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("jagmkiwis", "kiwi_fruit_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("jagmkiwis", "kiwi_fruit").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("naturalist", "bass_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("naturalist", "bass").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("naturalist", "catfish_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("naturalist", "catfish").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("naturalist", "duck_egg_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("naturalist", "duck_eggs").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("nutritious_feast", "blueberry_crate").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("nutritious_feast", "blueberries").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farm_and_charm", "lettuce_bag").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farm_and_charm", "lettuce").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farm_and_charm", "tomato_bag").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farm_and_charm", "tomato").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farm_and_charm", "carrot_bag").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farm_and_charm", "carrot_from_bag").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farm_and_charm", "potato_bag").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farm_and_charm", "potato_from_bag").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farm_and_charm", "onion_bag").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farm_and_charm", "onion_from_bag").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farm_and_charm", "beetroot_bag").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farm_and_charm", "beetroot_from_bag").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farm_and_charm", "corn_bag").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farm_and_charm", "corn_from_bag").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farm_and_charm", "strawberry_bag").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farm_and_charm", "strawberry_from_bag").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farm_and_charm", "flour_bag").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farm_and_charm", "flour_from_bag").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farm_and_charm", "oat_ball").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farm_and_charm", "oat_from_ball").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farm_and_charm", "barley_ball").toString());
        NO_QUALITY_RECIPES_DEFAULT.add(Compat.location("farm_and_charm", "barley_from_ball").toString());
    }

    private static void fillRetainQualityRecipes() {
        RETAIN_QUALITY_RECIPES_DEFAULT.add("minecraft:sugar_from_sugar_cane");
        RETAIN_QUALITY_RECIPES_DEFAULT.add("minecraft:sugar_from_honey_bottle");
        RETAIN_QUALITY_RECIPES_DEFAULT.add(Compat.location("cratedelight", "stacked_melons").toString());
        RETAIN_QUALITY_RECIPES_DEFAULT.add(Compat.location("cratedelight", "melons").toString());
        RETAIN_QUALITY_RECIPES_DEFAULT.add(Compat.location("cratedelight", "stacked_pumpkins").toString());
        RETAIN_QUALITY_RECIPES_DEFAULT.add(Compat.location("cratedelight", "pumpkins").toString());
        RETAIN_QUALITY_RECIPES_DEFAULT.add(Compat.location("farmersdelight", "stacked_melons").toString());
        RETAIN_QUALITY_RECIPES_DEFAULT.add(Compat.location("farmersdelight", "stacked_pumpkins").toString());
    }

    static {
        QUALITY_CONFIG = new HashMap<Quality, QualityConfig>();
        FARMLAND_CONFIG = new ArrayList<FarmlandConfig>();
        NO_QUALITY_RECIPES_DEFAULT = new ArrayList<String>();
        RETAIN_QUALITY_RECIPES_DEFAULT = new ArrayList<String>();
        ServerConfig.fillNoQualityRecipes();
        ServerConfig.fillRetainQualityRecipes();
        LUCK_MULTIPLIER = BUILDER.comment("Luck will affect how often each quality will be tried for (10 luck * 0.1 multiplier -> + 0.75 rolls, resulting in 1 guaranteed (baseline) and 75% chance for another)").defineInRange("luck_multiplier", 0.075, 0.0, 10.0);
        String cropTargetChanceComment1 = "The chance of quality crops dropping its own quality (also affects other qualities) - It affects a multiplier which is calculated as: <crop_target_chance> / <quality.chance>";
        String cropTargetChanceComment2 = "Meaning for Gold it would result in a multiplier of 20 (0.6 / 0.03) -> The chances for all qualities would then be: 20 * 0.10 (iron) = 2 (100%) | 20 * 0.03 (gold) = 0.6 (60%) | 20 * 0.005 = 0.1 (10%)";
        CROP_TARGET_CHANCE = BUILDER.comment(cropTargetChanceComment1 + cropTargetChanceComment2).defineInRange("crop_target_chance", 0.6, 0.0, 1.0);
        SEED_CHANCE_MULTIPLIER = BUILDER.comment("Multiplier on top of the crop target chance").defineInRange("seed_chance_multiplier", 0.25, 0.0, 100.0);
        String farmlandConfigComment1 = "Define multipliers to be applied per farmland on crops - Syntax: <index>;<crop>;<farmland>;<multiplier> (the index defines the sequence in which they will be checked - the first matching one is applied)";
        String farmlandConfigComment2 = "\nExample: [\"2;minecraft:wheat;#farmersdelight:terrain;0.75\", \"3;#minecraft:crops;farmersdelight:rich_soil;1.25\"]";
        FARMLAND_CONFIG_INTERNAL = BUILDER.comment(farmlandConfigComment1 + farmlandConfigComment2).defineList("farmland_config", Collections.emptyList(), ServerConfig::validateFarmlandConfig);
        BUILDER.push("Crafting");
        NO_QUALITY_RECIPES = BUILDER.comment("Define recipes (namespace:path) which should not result in quality being applied (e.g. when the items can be converted back and forth)").defineList("no_quality_recipes", NO_QUALITY_RECIPES_DEFAULT, ServerConfig::validateRecipe);
        RETAIN_QUALITY_RECIPES = BUILDER.comment("Define recipes (namespace:path) which should result in the quality should be always be applied to the result (only if all ingredients have the same quality)").defineList("retain_quality_recipes", RETAIN_QUALITY_RECIPES_DEFAULT, ServerConfig::validateRecipe);
        HANDLE_COMPACTING = BUILDER.comment("Defines whether (de)compacting should be handled automatically (in terms of retaining quality)").define("handle_compacting", true);
        HANDLE_SEED_RECIPES = BUILDER.comment("Attempt to handle recipes involving seed items automatically (to avoid having to add all of them to the retain_quality_recipes config)").define("handle_seed_recipes", true);
        BUILDER.pop();
        for (Quality quality : Quality.values()) {
            if (!QualityUtils.isValidQuality(quality) || quality == Quality.UNDEFINED) continue;
            BUILDER.push(quality.name());
            QualityConfig config = new QualityConfig();
            config.weight = BUILDER.comment("The weight of the quality (relevant for crafting - average weight from the quality of the ingredients determine affect the resulting quality)").defineInRange("weight", QualityConfig.getWeight(quality), 0.0, 100.0);
            config.minWeight = BUILDER.comment("The min. weight of the quality (chance for quality when crafting: (average_weight - min_weight) / (weight / min_weight)").defineInRange("min_weight", QualityConfig.getMinWeight(quality), 0.0, 100.0);
            config.chance = BUILDER.comment("The chance for a quality to occur (with no luck or other bonus)").defineInRange("chance", (double)QualityConfig.getChance(quality), 0.0, 1.0);
            config.cropMultiplier = BUILDER.comment("A chance multiplier for dropped crops (from a fully grown crop)").defineInRange("crop_multiplier", (double)QualityConfig.getCropMultiplier(quality), 0.0, 5.0);
            config.seedMultiplier = BUILDER.comment("A chance multiplier for dropped seeds (from a fully grown crop)").defineInRange("seed_multiplier", (double)QualityConfig.getCropMultiplier(quality), 0.0, 5.0);
            config.durationMultiplier = BUILDER.comment("By how much the duration of the effect will get multiplied (beneficial) or divided (harmful) for").defineInRange("duration_multiplier", QualityConfig.getDurationMultiplier(quality), 1.0, 100.0);
            config.probabilityAddition = BUILDER.comment("The addition (beneficial) or subtraction (harmful) for the probability (chance for the effect to apply)").defineInRange("probability_addition", (double)QualityConfig.getProbabilityAddition(quality), 0.0, 1.0);
            config.amplifierAddition = BUILDER.comment("The addition (beneficial) or subtraction (harmful) for the amplifier (level of the effect)").defineInRange("amplifier_addition", QualityConfig.getAmplifierAddition(quality), 0, 255);
            config.nutritionMultiplier = BUILDER.comment("By how much the nutrition will get multiplied for").defineInRange("nutrition_multiplier", QualityConfig.getNutritionMultiplier(quality), 1.0, 100.0);
            config.saturationMultiplier = BUILDER.comment("By how much the saturation will get multiplied for").defineInRange("saturation_multiplier", (double)QualityConfig.getSaturationMultiplier(quality), 1.0, 100.0);
            config.effect_list_internal = BUILDER.comment("List of effects this rarity can grant (the item can be a tag) (<item>;<effect>;<chance>;<duration>;<amplifier>;<probability>)").defineList("effect_list", List.of(), ServerConfig::isEffectListValid);
            QUALITY_CONFIG.put(quality, config);
            BUILDER.pop();
        }
        BUILDER.push("Compatibility");
        QUARK_HANDLE_CONFIG = BUILDER.comment("Handle Quark harvest & replant automatically (if you have custom behaviour configured regarding the quality block state turn this off)").define("quark_handle_config", true);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

