/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.quality_food.config;

import de.cadentem.quality_food.config.EffectConfig;
import de.cadentem.quality_food.config.ServerConfig;
import de.cadentem.quality_food.core.Quality;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;

public class QualityConfig {
    private final List<EffectConfig> effects = new ArrayList<EffectConfig>();
    public ForgeConfigSpec.DoubleValue weight;
    public ForgeConfigSpec.DoubleValue minWeight;
    public ForgeConfigSpec.DoubleValue chance;
    public ForgeConfigSpec.DoubleValue cropMultiplier;
    public ForgeConfigSpec.DoubleValue seedMultiplier;
    public ForgeConfigSpec.DoubleValue durationMultiplier;
    public ForgeConfigSpec.DoubleValue probabilityAddition;
    public ForgeConfigSpec.IntValue amplifierAddition;
    public ForgeConfigSpec.DoubleValue nutritionMultiplier;
    public ForgeConfigSpec.DoubleValue saturationMultiplier;
    public ForgeConfigSpec.ConfigValue<List<? extends String>> effect_list_internal;

    public static float getChance(@NotNull Quality quality) {
        QualityConfig config = ServerConfig.QUALITY_CONFIG.get((Object)quality);
        if (config != null) {
            return ((Double)config.chance.get()).floatValue();
        }
        return switch (quality) {
            case Quality.IRON -> 0.1f;
            case Quality.GOLD -> 0.03f;
            case Quality.DIAMOND -> 0.005f;
            default -> 0.0f;
        };
    }

    public static double getWeight(@NotNull Quality quality) {
        QualityConfig config = ServerConfig.QUALITY_CONFIG.get((Object)quality);
        if (config != null) {
            return (Double)config.weight.get();
        }
        return switch (quality) {
            case Quality.IRON -> 1.0;
            case Quality.GOLD -> 2.0;
            case Quality.DIAMOND -> 3.0;
            default -> 0.0;
        };
    }

    public static double getMinWeight(@NotNull Quality quality) {
        QualityConfig config = ServerConfig.QUALITY_CONFIG.get((Object)quality);
        if (config != null) {
            return (Double)config.minWeight.get();
        }
        return switch (quality) {
            case Quality.IRON -> 0.0;
            case Quality.GOLD -> 1.0;
            case Quality.DIAMOND -> 1.75;
            default -> 0.0;
        };
    }

    public static float getCropMultiplier(@NotNull Quality quality) {
        QualityConfig config = ServerConfig.QUALITY_CONFIG.get((Object)quality);
        if (config != null) {
            return ((Double)config.cropMultiplier.get()).floatValue();
        }
        return switch (quality) {
            case Quality.IRON -> 1.0f;
            case Quality.GOLD -> 0.9f;
            case Quality.DIAMOND -> 0.75f;
            default -> 0.0f;
        };
    }

    public static float getSeedMultiplier(@NotNull Quality quality) {
        QualityConfig config = ServerConfig.QUALITY_CONFIG.get((Object)quality);
        if (config != null) {
            return ((Double)config.seedMultiplier.get()).floatValue();
        }
        return switch (quality) {
            case Quality.IRON -> 1.0f;
            case Quality.GOLD -> 0.9f;
            case Quality.DIAMOND -> 0.75f;
            default -> 0.0f;
        };
    }

    public static double calculateChance(Quality quality, double averageWeight) {
        double minWeight = QualityConfig.getMinWeight(quality);
        return Mth.m_14008_((double)((averageWeight - minWeight) / (QualityConfig.getWeight(quality) - minWeight)), (double)0.0, (double)1.0);
    }

    public static double getDurationMultiplier(@NotNull Quality quality) {
        QualityConfig config = ServerConfig.QUALITY_CONFIG.get((Object)quality);
        if (config != null) {
            return (Double)config.durationMultiplier.get();
        }
        return 1.0 + (double)quality.level() * 0.5;
    }

    public static float getProbabilityAddition(@NotNull Quality quality) {
        QualityConfig config = ServerConfig.QUALITY_CONFIG.get((Object)quality);
        if (config != null) {
            return ((Double)config.probabilityAddition.get()).floatValue();
        }
        if (quality == Quality.NONE || quality == Quality.NONE_PLAYER_PLACED) {
            return 0.0f;
        }
        return (float)quality.level() / 10.0f;
    }

    public static int getAmplifierAddition(@NotNull Quality quality) {
        QualityConfig config = ServerConfig.QUALITY_CONFIG.get((Object)quality);
        if (config != null) {
            return (Integer)config.amplifierAddition.get();
        }
        return quality.level();
    }

    public static double getNutritionMultiplier(@NotNull Quality quality) {
        QualityConfig config = ServerConfig.QUALITY_CONFIG.get((Object)quality);
        if (config != null) {
            return (Double)config.nutritionMultiplier.get();
        }
        return 1.0 + (double)quality.level() * 0.5;
    }

    public static float getSaturationMultiplier(@NotNull Quality quality) {
        QualityConfig config = ServerConfig.QUALITY_CONFIG.get((Object)quality);
        if (config != null) {
            return ((Double)config.saturationMultiplier.get()).floatValue();
        }
        return 1.0f + (float)quality.level() * 0.25f;
    }

    public void initializeEffects() {
        this.effects.clear();
        ((List)this.effect_list_internal.get()).forEach(effect -> {
            EffectConfig config = EffectConfig.create(effect);
            if (config != null) {
                this.effects.add(config);
            }
        });
    }

    public List<EffectConfig> getEffects() {
        return this.effects;
    }
}

