/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.quality_food;

import com.mojang.logging.LogUtils;
import de.cadentem.quality_food.capability.BlockData;
import de.cadentem.quality_food.capability.LevelData;
import de.cadentem.quality_food.compat.Compat;
import de.cadentem.quality_food.compat.create.QualityItemAttributeType;
import de.cadentem.quality_food.compat.harvestwithease.ModEvents;
import de.cadentem.quality_food.config.ClientConfig;
import de.cadentem.quality_food.config.ServerConfig;
import de.cadentem.quality_food.network.NetworkHandler;
import de.cadentem.quality_food.registry.QFCommands;
import de.cadentem.quality_food.registry.QFItems;
import de.cadentem.quality_food.registry.QFLootModifiers;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="quality_food")
public class QualityFood {
    public static final String MODID = "quality_food";
    public static final Logger LOG = LogUtils.getLogger();

    public QualityFood() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.register((Object)this);
        QFItems.ITEMS.register(modEventBus);
        QFLootModifiers.LOOT_MODIFIERS.register(modEventBus);
        QFCommands.COMMAND_ARGUMENTS.register(modEventBus);
        MinecraftForge.EVENT_BUS.addListener(QFCommands::registerCommands);
        if (Compat.isModLoaded("harvestwithease")) {
            MinecraftForge.EVENT_BUS.addListener(ModEvents::handleHarvestEvent);
        }
        if (Compat.isModLoaded("create")) {
            QualityItemAttributeType.REGISTRY.register(modEventBus);
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.SPEC);
    }

    @SubscribeEvent
    public void commonSetup(FMLCommonSetupEvent event) {
        NetworkHandler.register();
    }

    @SubscribeEvent
    public void registerCapability(RegisterCapabilitiesEvent event) {
        event.register(BlockData.class);
        event.register(LevelData.class);
    }

    public static ResourceLocation location(String path) {
        return new ResourceLocation(MODID, path);
    }

    public static String concat(String path) {
        return "quality_food." + path;
    }
}

