/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.init.food;

import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.xkmc.l2library.base.L2Registrate;
import dev.xkmc.youkaishomecoming.content.block.plant.CoffeaCropBlock;
import dev.xkmc.youkaishomecoming.content.block.plant.PlantJsonGen;
import dev.xkmc.youkaishomecoming.content.block.plant.TeaCropBlock;
import dev.xkmc.youkaishomecoming.content.block.plant.UdumbaraBlock;
import dev.xkmc.youkaishomecoming.content.block.plant.WildCoffeaBlock;
import dev.xkmc.youkaishomecoming.content.block.plant.YHCropBlock;
import dev.xkmc.youkaishomecoming.content.block.plant.grape.GrapeCropBlock;
import dev.xkmc.youkaishomecoming.content.block.plant.grape.GrapeVineSet;
import dev.xkmc.youkaishomecoming.content.block.plant.rope.CucumberCropBlock;
import dev.xkmc.youkaishomecoming.content.block.plant.rope.RootedClimbingCropBlock;
import dev.xkmc.youkaishomecoming.content.block.plant.rope.RopeClimbingSeedItem;
import dev.xkmc.youkaishomecoming.content.block.plant.rope.RopeCropJsonGen;
import dev.xkmc.youkaishomecoming.init.YoukaisHomecoming;
import dev.xkmc.youkaishomecoming.init.registrate.YHItems;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.tag.ForgeTags;
import vectorwing.farmersdelight.common.tag.ModTags;

public enum YHCrops {
    SOYBEAN(PlantType.CROSS, 8, 12, null, "pods"),
    REDBEAN(PlantType.CROSS, 8, 12, null, null),
    COFFEA(PlantType.COFFEA, 6, 12, "green_coffee_bean", "coffee_berries"),
    TEA(PlantType.TEA, 6, 12, "tea_seeds", "tea_leaves"),
    UDUMBARA(PlantType.UDUMBARA, 6, 12, "udumbara_seeds", "udumbara_flower"),
    MANDRAKE(PlantType.MANDRAKE, 6, 12, "mandrake_root", "mandrake_flower"),
    CUCUMBER(PlantType.CUCUMBER, 8, 24, "cucumber_seeds", "cucumber"),
    RED_GRAPE(PlantType.GRAPE, 8, 12, "red_grape_seeds", "red_grape"),
    BLACK_GRAPE(PlantType.GRAPE, 4, 48, "black_grape_seeds", "black_grape"),
    WHITE_GRAPE(PlantType.GRAPE, 8, 12, "white_grape_seeds", "white_grape");

    private final PlantType type;
    private final BlockEntry<? extends BushBlock> PLANT;
    private final BlockEntry<? extends Block> WILD;
    public final ItemEntry<ItemNameBlockItem> seed;
    public final ItemEntry<? extends Item> fruits;
    public final ResourceKey<ConfiguredFeature<?, ?>> configKey;
    public final ResourceKey<PlacedFeature> placementKey;
    private final int rarity;
    private final int density;
    public final GrapeVineSet set;

    private YHCrops(PlantType type, @Nullable int rarity, @Nullable int density, String seedName, String fruit) {
        this.type = type;
        String name = this.name().toLowerCase(Locale.ROOT);
        this.rarity = rarity;
        this.density = density;
        String sname = seedName == null ? name : seedName;
        this.configKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)YoukaisHomecoming.loc(name));
        this.placementKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)YoukaisHomecoming.loc(name));
        this.PLANT = type.plant(this);
        this.WILD = type.wild(this);
        ItemBuilder seedBuilder = YHItems.seed(sname, p -> type.item(this.getPlant(), (Item.Properties)p));
        if (seedName != null || name.endsWith("bean")) {
            seedBuilder.tag(new TagKey[]{ForgeTags.SEEDS});
        }
        this.seed = seedBuilder.register();
        this.fruits = fruit == null ? this.seed : (type.eatable() ? YHItems.crop(fruit, p -> new Item(p.m_41489_(new FoodProperties.Builder().m_38760_(2).m_38758_(0.3f).m_38767_()))) : YHItems.crop(fruit, Item::new));
        this.set = type == PlantType.GRAPE ? new GrapeVineSet(this) : null;
    }

    public Block getPlant() {
        return (Block)this.PLANT.get();
    }

    public Block getWildPlant() {
        return (Block)this.WILD.get();
    }

    public Item getSeed() {
        return (Item)this.seed.get();
    }

    public Item getFruits() {
        return (Item)this.fruits.get();
    }

    public String getTypeName() {
        if (this.type == PlantType.GRAPE) {
            return this.getName().split("_")[1];
        }
        return this.getName();
    }

    public void registerComposter() {
        ComposterBlock.f_51914_.put((Object)this.getSeed(), 0.3f);
        if (this.getSeed() != this.getFruits()) {
            ComposterBlock.f_51914_.put((Object)this.getFruits(), 0.5f);
        }
        ComposterBlock.f_51914_.put((Object)this.getWildPlant().m_5456_(), 0.65f);
    }

    public void registerConfigs(BootstapContext<ConfiguredFeature<?, ?>> ctx) {
        if (this == BLACK_GRAPE) {
            FeatureUtils.m_254977_(ctx, this.configKey, (Feature)Feature.f_65763_, (FeatureConfiguration)new RandomPatchConfiguration(this.density, 5, 5, PlacementUtils.m_206498_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)this.getWildPlant())), (BlockPredicate)BlockPredicate.m_190417_((BlockPredicate[])new BlockPredicate[]{BlockPredicate.m_190419_(), BlockPredicate.m_246848_(), BlockPredicate.m_224768_((Vec3i)Direction.UP.m_122436_(), (TagKey)BlockTags.f_13035_)}))));
            return;
        }
        FeatureUtils.m_254977_(ctx, this.configKey, (Feature)Feature.f_65763_, (FeatureConfiguration)new RandomPatchConfiguration(this.density, 5, 3, PlacementUtils.m_206498_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)this.getWildPlant())), (BlockPredicate)BlockPredicate.m_190417_((BlockPredicate[])new BlockPredicate[]{BlockPredicate.m_190419_(), BlockPredicate.m_246848_(), BlockPredicate.m_224774_((Vec3i)Direction.DOWN.m_122436_(), (Block[])new Block[]{Blocks.f_50440_})}))));
    }

    public void registerPlacements(BootstapContext<PlacedFeature> ctx) {
        PlacementUtils.m_255206_(ctx, this.placementKey, (Holder)ctx.m_255420_(Registries.f_256911_).m_255043_(this.configKey), (PlacementModifier[])new PlacementModifier[]{RarityFilter.m_191900_((int)this.rarity), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
    }

    public BlockEntry<Block> createBag() {
        return YHCrops.createBag(this.getName());
    }

    public BlockEntry<Block> createCrate() {
        return YHCrops.createCrate(this.getName());
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public ResourceKey<PlacedFeature> getPlacementKey() {
        return this.placementKey;
    }

    public static BlockEntry<Block> createCrate(String id) {
        return ((BlockBuilder)YoukaisHomecoming.REGISTRATE.block(id + "_crate", p -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50745_))).blockstate((ctx, pvd) -> pvd.simpleBlock((Block)ctx.get(), (ModelFile)((BlockModelBuilder)pvd.models().cubeBottomTop(ctx.getName(), pvd.modLoc("block/bags/" + ctx.getName() + "_side"), pvd.modLoc("block/bags/crate_bottom"), pvd.modLoc("block/bags/" + ctx.getName() + "_top"))).texture("particle", pvd.modLoc("block/bags/" + ctx.getName() + "_top")))).tag(new TagKey[]{Tags.Blocks.STORAGE_BLOCKS, BlockTags.f_144280_}).item().tag(new TagKey[]{Tags.Items.STORAGE_BLOCKS}).build()).register();
    }

    public static BlockEntry<Block> createBag(String id) {
        return ((BlockBuilder)YoukaisHomecoming.REGISTRATE.block(id + "_bag", p -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50106_))).blockstate((ctx, pvd) -> pvd.simpleBlock((Block)ctx.get(), (ModelFile)((BlockModelBuilder)pvd.models().cube(ctx.getName(), pvd.modLoc("block/bags/" + ctx.getName() + "_bottom"), pvd.modLoc("block/bags/" + ctx.getName() + "_top"), pvd.modLoc("block/bags/" + ctx.getName() + "_side"), pvd.modLoc("block/bags/" + ctx.getName() + "_side"), pvd.modLoc("block/bags/" + ctx.getName() + "_side_tied"), pvd.modLoc("block/bags/" + ctx.getName() + "_side_tied"))).texture("particle", pvd.modLoc("block/bags/" + ctx.getName() + "_top")))).tag(new TagKey[]{Tags.Blocks.STORAGE_BLOCKS}).item().tag(new TagKey[]{Tags.Items.STORAGE_BLOCKS}).build()).register();
    }

    public static void register() {
    }

    public BlockBuilder<BushBlock, L2Registrate> wildCrop() {
        return ((BlockBuilder)YoukaisHomecoming.REGISTRATE.block("wild_" + this.getName(), BushBlock::new).initialProperties(() -> Blocks.f_50111_).blockstate((ctx, pvd) -> YHCropBlock.buildWildModel((DataGenContext<Block, ? extends Block>)ctx, pvd, this)).item().tag(new TagKey[]{ModTags.WILD_CROPS_ITEM}).model((ctx, pvd) -> pvd.generated((NonNullSupplier)ctx, new ResourceLocation[]{pvd.modLoc("block/plants/" + this.getTypeName() + "/wild_" + this.getName())})).build()).tag(new TagKey[]{ModTags.WILD_CROPS});
    }

    public BlockEntry<BushBlock> wildCropDropFruit() {
        return this.wildCrop().loot((ctx, pvd) -> PlantJsonGen.wildDropFruit(ctx, (Block)pvd, this)).register();
    }

    public BlockEntry<BushBlock> wildCropDropSeed() {
        return this.wildCrop().loot((ctx, pvd) -> PlantJsonGen.wildDropSeed(ctx, (Block)pvd, this)).register();
    }

    public static enum PlantType {
        CROP((crop, name) -> YoukaisHomecoming.REGISTRATE.block(name, p -> new YHCropBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_), crop::getSeed)).blockstate((ctx, pvd) -> PlantJsonGen.buildCropModel((DataGenContext<Block, ? extends YHCropBlock>)ctx, pvd, name)).loot((pvd, block) -> PlantJsonGen.buildPlantLoot(pvd, block, crop)).register(), YHCrops::wildCropDropFruit, ItemNameBlockItem::new),
        CROSS((crop, name) -> YoukaisHomecoming.REGISTRATE.block(name, p -> new YHCropBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_), crop::getSeed)).blockstate((ctx, pvd) -> PlantJsonGen.buildCrossModel((DataGenContext<Block, ? extends Block>)ctx, pvd, name)).loot((pvd, block) -> PlantJsonGen.buildPlantLoot(pvd, block, crop)).register(), YHCrops::wildCropDropFruit, ItemNameBlockItem::new),
        COFFEA((crop, name) -> YoukaisHomecoming.REGISTRATE.block(name, p -> new CoffeaCropBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_), crop::getSeed)).blockstate((ctx, pvd) -> CoffeaCropBlock.buildPlantModel((DataGenContext<Block, CoffeaCropBlock>)ctx, pvd, name)).loot((pvd, block) -> CoffeaCropBlock.buildPlantLoot(pvd, block, crop)).register(), crop -> ((BlockBuilder)YoukaisHomecoming.REGISTRATE.block("wild_" + crop.getName(), p -> new WildCoffeaBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50111_))).blockstate((ctx, pvd) -> WildCoffeaBlock.buildWildModel((DataGenContext<Block, WildCoffeaBlock>)ctx, pvd, crop)).loot((ctx, pvd) -> WildCoffeaBlock.buildWildLoot(ctx, pvd, crop)).item().tag(new TagKey[]{ModTags.WILD_CROPS_ITEM}).model((ctx, pvd) -> pvd.generated((NonNullSupplier)ctx, new ResourceLocation[]{pvd.modLoc("block/plants/" + crop.getTypeName() + "/wild_" + crop.getName() + "_top")})).build()).tag(new TagKey[]{ModTags.WILD_CROPS}).register(), ItemNameBlockItem::new),
        TEA((crop, name) -> YoukaisHomecoming.REGISTRATE.block(name, p -> new TeaCropBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60955_().m_280574_().m_60977_().m_60966_().m_60918_(SoundType.f_56758_).m_278166_(PushReaction.DESTROY), crop::getSeed)).blockstate((ctx, pvd) -> TeaCropBlock.buildPlantModel((DataGenContext<Block, TeaCropBlock>)ctx, pvd, name)).loot((pvd, block) -> TeaCropBlock.buildPlantLoot(pvd, block, crop)).register(), YHCrops::wildCropDropSeed, ItemNameBlockItem::new),
        UDUMBARA((crop, name) -> YoukaisHomecoming.REGISTRATE.block(name, p -> new UdumbaraBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_).m_60953_(s -> 2), crop::getSeed, crop::getFruits)).blockstate((ctx, pvd) -> PlantJsonGen.buildCrossModel((DataGenContext<Block, ? extends Block>)ctx, pvd, name)).loot((pvd, block) -> UdumbaraBlock.buildPlantLoot(pvd, block, crop)).register(), YHCrops::wildCropDropSeed, ItemNameBlockItem::new),
        MANDRAKE((crop, name) -> YoukaisHomecoming.REGISTRATE.block(name, p -> new YHCropBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_), crop::getSeed)).blockstate((ctx, pvd) -> PlantJsonGen.buildCrossModel((DataGenContext<Block, ? extends Block>)ctx, pvd, name)).loot((pvd, block) -> PlantJsonGen.buildDoubleLoot(pvd, (Block)block, crop)).register(), YHCrops::wildCropDropSeed, ItemNameBlockItem::new),
        CUCUMBER((crop, name) -> YoukaisHomecoming.REGISTRATE.block(name, p -> new CucumberCropBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_), crop::getSeed, crop::getFruits)).blockstate((ctx, pvd) -> RopeCropJsonGen.buildRootedModel((DataGenContext<Block, ? extends RootedClimbingCropBlock>)ctx, pvd, name)).loot((pvd, block) -> PlantJsonGen.buildPlantLoot(pvd, block, crop)).tag(new TagKey[]{BlockTags.f_13082_}).register(), YHCrops::wildCropDropFruit, RopeClimbingSeedItem::new),
        GRAPE((crop, name) -> YoukaisHomecoming.REGISTRATE.block(name, p -> new GrapeCropBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_), (YHCrops)((Object)crop))).blockstate((ctx, pvd) -> GrapeVineSet.buildPlantModel((DataGenContext<Block, GrapeCropBlock>)ctx, pvd, name)).loot((pvd, block) -> GrapeVineSet.buildPlantLoot(pvd, block, crop)).tag(new TagKey[]{BlockTags.f_13082_}).register(), GrapeVineSet::wildBush, RopeClimbingSeedItem::new);

        private final BiFunction<YHCrops, String, BlockEntry<? extends BushBlock>> plant;
        private final Function<YHCrops, BlockEntry<? extends Block>> wild;
        private final BiFunction<Block, Item.Properties, ItemNameBlockItem> item;

        private PlantType(BiFunction<YHCrops, String, BlockEntry<? extends BushBlock>> plant, Function<YHCrops, BlockEntry<? extends Block>> wild, BiFunction<Block, Item.Properties, ItemNameBlockItem> item) {
            this.plant = plant;
            this.wild = wild;
            this.item = item;
        }

        public BlockEntry<? extends BushBlock> plant(YHCrops crop) {
            return this.plant.apply(crop, crop.getName());
        }

        public BlockEntry<? extends Block> wild(YHCrops crop) {
            return this.wild.apply(crop);
        }

        public ItemNameBlockItem item(Block plant, Item.Properties p) {
            return this.item.apply(plant, p);
        }

        public boolean eatable() {
            return this == CUCUMBER || this == GRAPE;
        }
    }
}

