/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.init.food;

import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.xkmc.youkaishomecoming.content.block.food.YHCakeBlock;
import dev.xkmc.youkaishomecoming.content.block.food.YHCandleCakeBlock;
import dev.xkmc.youkaishomecoming.content.block.food.YHPieBlock;
import dev.xkmc.youkaishomecoming.content.item.food.YHFoodItem;
import dev.xkmc.youkaishomecoming.init.YoukaisHomecoming;
import dev.xkmc.youkaishomecoming.init.food.EffectEntry;
import dev.xkmc.youkaishomecoming.init.food.FoodType;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.registries.ForgeRegistries;
import vectorwing.farmersdelight.common.block.PieBlock;

public class CakeEntry {
    private final String base;
    public final BlockEntry<? extends Block> block;
    public final ItemEntry<YHFoodItem> item;
    public boolean isCake;

    public CakeEntry(String base, MapColor color, FoodType type, int nut, float sat, boolean isCake, EffectEntry ... effects) {
        this.base = base;
        this.isCake = isCake;
        BlockBehaviour.Properties props = BlockBehaviour.Properties.m_284310_().m_284180_(color).m_280606_().m_60978_(0.5f).m_60918_(SoundType.f_56745_).m_278166_(PushReaction.DESTROY);
        if (!isCake) {
            this.item = type.build("feast/", base + "_slice", nut, sat, new TagKey[0], List.of(effects));
            this.block = ((BlockBuilder)YoukaisHomecoming.REGISTRATE.block(base, p -> new YHPieBlock(props, () -> this.item.get())).blockstate(this::genPieModels).loot((pvd, block) -> pvd.m_246125_((Block)block, (ItemLike)this.item.get())).item().model((ctx, pvd) -> pvd.generated((NonNullSupplier)ctx, new ResourceLocation[]{pvd.modLoc("item/feast/" + ctx.getName())})).build()).register();
        } else {
            BlockEntry b;
            this.item = type.build("feast/", base + "_cake_slice", nut, sat, new TagKey[0], List.of(effects));
            this.block = b = ((BlockBuilder)YoukaisHomecoming.REGISTRATE.block(base + "_cake", p -> new YHCakeBlock(() -> this.item.get(), props)).blockstate(this::genCakeModels).loot((pvd, block) -> pvd.m_246125_((Block)block, (ItemLike)this.item.get())).item().model((ctx, pvd) -> pvd.generated((NonNullSupplier)ctx, new ResourceLocation[]{pvd.modLoc("item/feast/" + ctx.getName())})).build()).register();
            YoukaisHomecoming.REGISTRATE.block(base + "_candle_cake", p -> new YHCandleCakeBlock((Supplier<YHCakeBlock>)b, Blocks.f_152482_, props)).blockstate((ctx, pvd) -> this.genCandleModels((DataGenContext<Block, YHCandleCakeBlock>)ctx, (RegistrateBlockstateProvider)pvd, "candle")).loot((pvd, block) -> pvd.m_246125_((Block)block, (ItemLike)Items.f_151065_)).tag(new TagKey[]{BlockTags.f_144268_}).register();
            for (DyeColor dye : DyeColor.values()) {
                String color_name = dye.m_41065_();
                Block candle = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(color_name + "_candle"));
                assert (candle != null);
                YoukaisHomecoming.REGISTRATE.block(color_name + "_" + base + "_candle_cake", p -> new YHCandleCakeBlock((Supplier<YHCakeBlock>)b, candle, props)).blockstate((ctx, pvd) -> this.genCandleModels((DataGenContext<Block, YHCandleCakeBlock>)ctx, (RegistrateBlockstateProvider)pvd, color_name + "_candle")).loot((pvd, block) -> pvd.m_246125_((Block)block, (ItemLike)candle.m_5456_())).tag(new TagKey[]{BlockTags.f_144268_}).register();
            }
        }
    }

    private void genPieModels(DataGenContext<Block, YHPieBlock> ctx, RegistrateBlockstateProvider pvd) {
        pvd.horizontalBlock((Block)ctx.get(), state -> {
            int stage = (Integer)state.m_61143_((Property)PieBlock.BITES);
            Object suffix = stage == 0 ? "" : "_slice" + stage;
            return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)pvd.models().getBuilder(ctx.getName() + (String)suffix)).parent((ModelFile)new ModelFile.UncheckedModelFile("farmersdelight:block/pie" + (String)suffix))).texture("particle", pvd.modLoc("block/cake/" + ctx.getName() + "_top"))).texture("top", pvd.modLoc("block/cake/" + ctx.getName() + "_top"))).texture("inner", pvd.modLoc("block/cake/" + ctx.getName() + "_inner"))).texture("side", pvd.modLoc("block/cake/pie_side"))).texture("bottom", pvd.modLoc("block/cake/pie_bottom"));
        });
    }

    private void genCandleModels(DataGenContext<Block, YHCandleCakeBlock> ctx, RegistrateBlockstateProvider pvd, String candle) {
        BlockModelBuilder nolit = this.genCandleCakeModel(ctx, pvd, candle, false);
        BlockModelBuilder lit = this.genCandleCakeModel(ctx, pvd, candle, true);
        pvd.getVariantBuilder((Block)ctx.getEntry()).forAllStates(e -> ConfiguredModel.builder().modelFile((ModelFile)((Boolean)e.m_61143_((Property)BlockStateProperties.f_61443_) != false ? lit : nolit)).build());
    }

    private void genCakeModels(DataGenContext<Block, YHCakeBlock> ctx, RegistrateBlockstateProvider pvd) {
        BlockModelBuilder[] slice = new BlockModelBuilder[7];
        slice[0] = this.genCakeModel(pvd, "cake");
        for (int i = 1; i <= 6; ++i) {
            slice[i] = this.genCakeModel(pvd, "cake_slice" + i);
        }
        pvd.getVariantBuilder((Block)ctx.getEntry()).forAllStates(e -> ConfiguredModel.builder().modelFile((ModelFile)slice[(Integer)e.m_61143_((Property)BlockStateProperties.f_61412_)]).build());
    }

    private BlockModelBuilder genCakeModel(RegistrateBlockstateProvider pvd, String model) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)pvd.models().withExistingParent(this.base + "_" + model, new ResourceLocation("block/" + model))).texture("particle", pvd.modLoc("block/cake/" + this.base + "_cake_side"))).texture("bottom", pvd.modLoc("block/cake/" + this.base + "_cake_bottom"))).texture("top", pvd.modLoc("block/cake/" + this.base + "_cake_top"))).texture("side", pvd.modLoc("block/cake/" + this.base + "_cake_side"))).texture("inside", pvd.modLoc("block/cake/" + this.base + "_cake_inner"));
    }

    private BlockModelBuilder genCandleCakeModel(DataGenContext<Block, YHCandleCakeBlock> ctx, RegistrateBlockstateProvider pvd, String candle, boolean lit) {
        Object name = ctx.getName();
        if (lit) {
            name = (String)name + "_lit";
            candle = (String)candle + "_lit";
        }
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)pvd.models().withExistingParent((String)name, new ResourceLocation("block/template_cake_with_candle"))).texture("particle", pvd.modLoc("block/cake/" + this.base + "_cake_side"))).texture("bottom", pvd.modLoc("block/cake/" + this.base + "_cake_bottom"))).texture("top", pvd.modLoc("block/cake/" + this.base + "_cake_top"))).texture("side", pvd.modLoc("block/cake/" + this.base + "_cake_side"))).texture("candle", pvd.mcLoc("block/" + (String)candle));
    }

    public static void register() {
    }
}

