/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.events;

import dev.xkmc.l2library.base.effects.EffectBuilder;
import dev.xkmc.youkaishomecoming.content.entity.reimu.MaidenEntity;
import dev.xkmc.youkaishomecoming.content.entity.youkai.YoukaiEntity;
import dev.xkmc.youkaishomecoming.content.item.curio.hat.KoishiHatItem;
import dev.xkmc.youkaishomecoming.init.data.YHModConfig;
import dev.xkmc.youkaishomecoming.init.registrate.YHEffects;
import dev.xkmc.youkaishomecoming.init.registrate.YHItems;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="youkaishomecoming", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EffectEventHandlers {
    public static boolean isYoukai(LivingEntity e) {
        return e.m_21023_((MobEffect)YHEffects.YOUKAIFYING.get()) || e.m_21023_((MobEffect)YHEffects.YOUKAIFIED.get());
    }

    public static boolean isCharacter(LivingEntity e) {
        return e instanceof YoukaiEntity || e.m_21023_((MobEffect)YHEffects.YOUKAIFYING.get()) || e.m_21023_((MobEffect)YHEffects.YOUKAIFIED.get()) || e.m_21023_((MobEffect)YHEffects.FAIRY.get());
    }

    public static boolean isFullCharacter(LivingEntity e) {
        return e instanceof YoukaiEntity || e.m_21023_((MobEffect)YHEffects.YOUKAIFIED.get()) || e.m_21023_((MobEffect)YHEffects.FAIRY.get());
    }

    @SubscribeEvent
    public static void onSleep(PlayerSleepInBedEvent event) {
        if (event.getEntity().m_21023_((MobEffect)YHEffects.SOBER.get())) {
            event.setResult(Player.BedSleepingProblem.OTHER_PROBLEM);
        }
    }

    public static void disableKoishi(Player player) {
        boolean flag = false;
        KoishiHatItem hat = (KoishiHatItem)((Object)YHItems.KOISHI_HAT.get());
        if (player.m_21023_((MobEffect)YHEffects.UNCONSCIOUS.get())) {
            player.m_21195_((MobEffect)YHEffects.UNCONSCIOUS.get());
            flag = true;
        }
        if (player.m_36335_().m_41519_((Item)hat)) {
            flag = true;
        }
        if (flag) {
            player.m_36335_().m_41524_((Item)hat, 200);
        }
    }

    @SubscribeEvent
    public static void onAttack(LivingAttackEvent event) {
        LivingEntity le;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity && (le = (LivingEntity)entity) instanceof Player) {
            Player player = (Player)le;
            EffectEventHandlers.disableKoishi(player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onHeal(LivingHealEvent event) {
        float amount = event.getAmount();
        if (event.getEntity().m_21023_((MobEffect)YHEffects.SMOOTHING.get())) {
            amount = (float)((double)amount * (Double)YHModConfig.COMMON.smoothingHealingFactor.get());
        }
        if (event.getEntity().m_21023_((MobEffect)YHEffects.FAIRY.get())) {
            amount = (float)((double)amount * (Double)YHModConfig.COMMON.fairyHealingFactor.get());
        }
        event.setAmount(amount);
    }

    @SubscribeEvent
    public static void onTick(LivingEvent.LivingTickEvent event) {
        LivingEntity e = event.getEntity();
        if (e.m_21023_((MobEffect)YHEffects.THICK.get()) && e.m_21023_(MobEffects.f_19615_)) {
            e.m_21195_(MobEffects.f_19615_);
        }
        if (e.m_21023_((MobEffect)YHEffects.SMOOTHING.get()) && e.m_21023_(MobEffects.f_19614_)) {
            e.m_21195_(MobEffects.f_19614_);
        }
        if (e.m_21023_((MobEffect)YHEffects.REFRESHING.get()) && e.m_6060_()) {
            e.m_20095_();
        }
        if (e.m_21214_() instanceof MaidenEntity || e.m_21188_() instanceof MaidenEntity) {
            EffectEventHandlers.removeKoishi(e);
        }
    }

    public static void removeKoishi(LivingEntity le) {
        if (le instanceof Player) {
            Player player = (Player)le;
            if (player.m_21023_((MobEffect)YHEffects.UNCONSCIOUS.get())) {
                player.m_21195_((MobEffect)YHEffects.UNCONSCIOUS.get());
            }
            KoishiHatItem hat = (KoishiHatItem)((Object)YHItems.KOISHI_HAT.get());
            if (player.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)hat) && (double)player.m_36335_().m_41521_((Item)hat, 0.0f) < 0.5) {
                player.m_36335_().m_41524_((Item)hat, 200);
            }
        }
    }

    @SubscribeEvent
    public static void onEffectTest(MobEffectEvent.Applicable event) {
        if (event.getEffectInstance().m_19544_() == MobEffects.f_19615_ && event.getEntity().m_21023_((MobEffect)YHEffects.THICK.get())) {
            event.setResult(Event.Result.DENY);
        }
        if (event.getEffectInstance().m_19544_() == MobEffects.f_19614_ && event.getEntity().m_21023_((MobEffect)YHEffects.SMOOTHING.get())) {
            event.setResult(Event.Result.DENY);
        }
        if (event.getEffectInstance().m_19544_() == YHEffects.YOUKAIFYING.get() && (event.getEntity().m_21023_((MobEffect)YHEffects.SOBER.get()) || event.getEntity().m_21023_((MobEffect)YHEffects.FAIRY.get()) || event.getEntity().m_21023_((MobEffect)YHEffects.YOUKAIFIED.get()))) {
            event.setResult(Event.Result.DENY);
        }
        if (event.getEffectInstance().m_19544_() == YHEffects.YOUKAIFIED.get() && (event.getEntity().m_21023_((MobEffect)YHEffects.SOBER.get()) || event.getEntity().m_21023_((MobEffect)YHEffects.FAIRY.get()))) {
            event.setResult(Event.Result.DENY);
        }
        if (event.getEffectInstance().m_19544_() == YHEffects.FAIRY.get() && (event.getEntity().m_21023_((MobEffect)YHEffects.YOUKAIFYING.get()) || event.getEntity().m_21023_((MobEffect)YHEffects.YOUKAIFIED.get()))) {
            event.setResult(Event.Result.DENY);
        }
    }

    public static MobEffectInstance onEat(LivingEntity user, MobEffectInstance ins) {
        EffectBuilder builder = new EffectBuilder(ins);
        int dur = ins.m_19557_();
        MobEffectInstance enjoy = user.m_21124_((MobEffect)YHEffects.ENJOYABLE.get());
        if (enjoy != null && ins.m_19544_().m_19486_()) {
            int lv = enjoy.m_19564_() + 1;
            builder.setDuration((int)((double)dur * (1.0 + 0.2 * (double)lv)));
        }
        return ins;
    }
}

