/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.events;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.xkmc.l2damagetracker.contents.curios.AttrTooltip;
import dev.xkmc.youkaishomecoming.content.entity.youkai.CombatProgress;
import dev.xkmc.youkaishomecoming.content.entity.youkai.YoukaiEntity;
import dev.xkmc.youkaishomecoming.content.item.curio.hat.TouhouHatItem;
import dev.xkmc.youkaishomecoming.init.registrate.YHEffects;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="youkaishomecoming", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientEventHandlers {
    private static float oTilt;
    private static float tilt;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        oTilt = tilt;
        float lv = ClientEventHandlers.drunkLevel();
        tilt = Mth.m_14179_((float)0.03f, (float)tilt, (float)lv);
    }

    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        Item item = event.getItemStack().m_41720_();
        if (item instanceof TouhouHatItem) {
            TouhouHatItem hat = (TouhouHatItem)item;
            AttrTooltip.modifyTooltip((List)event.getToolTip(), hat.getAttributeModifiersForDisplay(), (boolean)false);
        }
    }

    private static float drunkLevel() {
        Entity cam = Minecraft.m_91087_().m_91288_();
        if (!(cam instanceof Player)) {
            return 0.0f;
        }
        Player player = (Player)cam;
        MobEffectInstance ins = player.m_21124_((MobEffect)YHEffects.DRUNK.get());
        if (ins == null) {
            return 0.0f;
        }
        return Mth.m_14036_((float)((float)ins.m_19564_() * 0.25f), (float)0.0f, (float)1.0f);
    }

    public static void drunkView(PoseStack pose, float pTick) {
        Entity cam = Minecraft.m_91087_().m_91288_();
        if (!(cam instanceof Player)) {
            return;
        }
        Player player = (Player)cam;
        float t = Mth.m_14179_((float)pTick, (float)oTilt, (float)tilt);
        if ((double)t < 0.01) {
            return;
        }
        float time = pTick + (float)player.f_19797_;
        pose.m_252781_(Axis.f_252403_.m_252977_(t * t * 45.0f * Mth.m_14031_((float)((float)((double)(time / 60.0f) * Math.PI * 2.0)))));
    }

    public static void setProgress(int id, CombatProgress progress) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Entity entity = level.m_6815_(id);
        if (entity instanceof YoukaiEntity) {
            YoukaiEntity e = (YoukaiEntity)entity;
            e.combatProgress.loadFrom(progress);
        }
    }
}

