/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.spell.game;

import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.DanmakuHelper;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.IYHDanmaku;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemDanmakuEntity;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemLaserEntity;
import dev.xkmc.youkaishomecoming.content.spell.mover.CompositeMover;
import dev.xkmc.youkaishomecoming.content.spell.mover.PolarMover;
import dev.xkmc.youkaishomecoming.content.spell.mover.RectMover;
import dev.xkmc.youkaishomecoming.content.spell.mover.ZeroMover;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.ActualSpellCard;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.CardHolder;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.Ticker;
import dev.xkmc.youkaishomecoming.init.data.YHDamageTypes;
import dev.xkmc.youkaishomecoming.init.registrate.YHDanmaku;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

@SerialClass
public class YukariSpell
extends ActualSpellCard {
    @SerialClass.SerialField
    private int cooldown;
    @SerialClass.SerialField
    private int vulnerable;

    @Override
    public DamageSource getDanmakuDamageSource(IYHDanmaku danmaku) {
        return YHDamageTypes.abyssal(danmaku);
    }

    @Override
    public void tick(CardHolder holder) {
        Vec3 target;
        super.tick(holder);
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        if (this.vulnerable > 0) {
            --this.vulnerable;
        }
        if ((target = holder.target()) == null) {
            return;
        }
        Vec3 pos = holder.center();
        Vec3 vel = holder.targetVelocity();
        double dist = target.m_82554_(pos);
        if (vel != null && dist > 40.0 && this.tick % 5 == 0) {
            if (vel.m_82553_() < 0.5 || vel.m_82553_() > 1.0) {
                Vec3 dst = target.m_82549_(target.m_82546_(pos).m_82541_().m_82490_(32.0));
                if (YukariSpell.teleport(holder.self(), dst)) {
                    this.hidden(holder, dst, target);
                    this.vulnerable = 5;
                    return;
                }
            } else {
                Vec3 dst = target.m_82549_(target.m_82546_(pos).m_82541_().m_82490_(-16.0));
                if (YukariSpell.teleport(holder.self(), dst)) {
                    this.hidden(holder, dst, target);
                    this.vulnerable = 5;
                    return;
                }
            }
            this.cooldown = 5;
            return;
        }
        if (this.cooldown > 0) {
            return;
        }
        if (dist < 20.0) {
            this.launchButterfly(holder, YHDanmaku.Bullet.BUTTERFLY, DyeColor.CYAN, 1);
            this.launchButterfly(holder, YHDanmaku.Bullet.BUTTERFLY, DyeColor.MAGENTA, -1);
            this.cooldown = 60;
            this.vulnerable = 20;
            return;
        }
        this.addTicker(new LaserAdder());
        this.cooldown = 120;
        this.vulnerable = 40;
    }

    @Override
    public void hurt(CardHolder holder, DamageSource source, float amount) {
        Vec3 target;
        if (this.vulnerable <= 0) {
            // empty if block
        }
        if ((target = holder.target()) == null) {
            return;
        }
        if (YukariSpell.teleportRandom(holder, target)) {
            this.hidden(holder, holder.center(), target);
        }
    }

    private void hidden(CardHolder holder, Vec3 pos, Vec3 target) {
        this.cooldown = 20;
        this.hiddenImpl(holder, pos, target);
        double dist = pos.m_82554_(target);
        Vec3 dir = pos.m_82546_(target).m_82541_();
        DanmakuHelper.Orientation ori = DanmakuHelper.getOrientation(dir);
        for (int i = 1; i < 7; ++i) {
            Vec3 dst = target.m_82549_(ori.rotateDegrees(51.42857142857143 * (double)i).m_82490_(dist));
            DelayedHidden ans = new DelayedHidden();
            ans.pos = dst;
            ans.tick = -10 * i;
            this.addTicker(ans);
        }
    }

    private void hiddenImpl(CardHolder holder, Vec3 pos, Vec3 target) {
        Vec3 vec;
        int i;
        Vec3 dir = target.m_82546_(pos).m_82541_();
        DanmakuHelper.Orientation ori = DanmakuHelper.getOrientation(dir);
        for (i = 0; i < 6; ++i) {
            vec = ori.rotateDegrees(60 * i);
            ItemLaserEntity laser = holder.prepareLaser(120, pos, vec, 80.0f, YHDanmaku.Laser.LASER, DyeColor.MAGENTA);
            laser.setupTime(2, 8, 100, 10);
            holder.shoot(laser);
        }
        for (i = 0; i < 6; ++i) {
            vec = ori.rotateDegrees(60 * i);
            ItemDanmakuEntity e = holder.prepareDanmaku(40, Vec3.f_82478_, YHDanmaku.Bullet.BUBBLE, DyeColor.PURPLE);
            e.m_146884_(pos);
            e.mover = new RectMover(pos, vec.m_82490_(2.0), Vec3.f_82478_);
            holder.shoot(e);
        }
        for (i = -3; i <= 3; ++i) {
            for (int k = -2; k <= 2; ++k) {
                Vec3 vec2 = ori.rotateDegrees(10 * i, k * 10);
                for (int j = 0; j < 3; ++j) {
                    ItemDanmakuEntity e = holder.prepareDanmaku(40, Vec3.f_82478_, YHDanmaku.Bullet.BUTTERFLY, DyeColor.PURPLE);
                    e.m_146884_(pos);
                    e.mover = new RectMover(pos, vec2.m_82490_(1.4 + (double)j * 0.2), Vec3.f_82478_);
                    holder.shoot(e);
                }
            }
        }
    }

    private void launchButterfly(CardHolder holder, YHDanmaku.Bullet type, DyeColor color, int dire) {
        RandomSource r = holder.random();
        Vec3 pos = holder.center();
        DanmakuHelper.Orientation o0 = DanmakuHelper.getOrientation(holder.forward());
        int n = 100;
        int mrange = 12;
        int vrange = 8;
        int t0 = 40;
        int t1 = 10;
        double tvr = 0.8;
        int t2 = 10;
        int t3 = 30;
        int t4 = 40;
        double avar = 0.7853981633974483;
        float wvr = (float)(tvr / (double)mrange) * (float)dire;
        int total = t0 + t1 + t2 + t3 + t4;
        for (int i = 0; i < n; ++i) {
            double a0 = Math.PI * 2 / (double)n * (double)i;
            double ver = (r.m_188500_() * 2.0 - 1.0) * avar;
            Vec3 a1 = o0.rotate(a0, ver);
            Vec3 vn = o0.rotate(a0, ver + 1.5707963267948966);
            float range = (float)mrange + (float)vrange * (float)(r.m_188500_() * 2.0 - 1.0);
            float va = range * 2.0f / (float)(t0 * t0);
            float vr = va * (float)t0;
            CompositeMover mover = new CompositeMover();
            Vec3 a2 = PolarMover.ofPlane(pos, a1, vn).radial(range, 0.0, 0.0).angular(0.0, wvr, 0.0).dir(0.0).m_82490_(100.0).m_82541_();
            PolarMover polar0 = PolarMover.ofPlane(pos, a1, vn).radial(range, 0.0, 0.0).angular(0.0, 0.0, wvr / (float)t2);
            PolarMover polar1 = polar0.copy().atTime(t2).clearAccel();
            RectMover rect = polar1.copy().atTime(t3).toRect();
            Vec3 v1 = a1.m_82490_((double)vr);
            mover.add(t0, new RectMover(pos, v1, a1.m_82490_((double)(-va))));
            mover.add(t1, new ZeroMover(a1, a2, t1));
            mover.add(t2, polar0);
            mover.add(t3, polar1);
            mover.add(t4, rect);
            ItemDanmakuEntity danmaku = holder.prepareDanmaku(total + r.m_188503_(40), v1, type, color);
            danmaku.mover = mover;
            holder.shoot(danmaku);
        }
    }

    private static boolean teleportRandom(CardHolder holder, Vec3 target) {
        double dist = holder.center().m_82554_(target);
        RandomSource r = holder.random();
        for (int i = 0; i < 16; ++i) {
            Vec3 dir = new Vec3(r.m_188583_(), Math.abs(r.m_188583_()), r.m_188583_());
            Vec3 pos = dir.m_82490_(Math.min(32.0, dist * (0.8 + r.m_188500_() * 0.4))).m_82549_(target);
            if (!YukariSpell.teleport(holder.self(), pos)) continue;
            return true;
        }
        return false;
    }

    private static boolean teleport(LivingEntity mob, Vec3 target) {
        Vec3 old = mob.m_20182_();
        mob.m_6021_(target.m_7096_(), target.m_7098_(), target.m_7094_());
        if (!mob.m_9236_().m_45786_((Entity)mob)) {
            mob.m_6021_(old.m_7096_(), old.m_7098_(), old.m_7094_());
            return false;
        }
        mob.m_9236_().m_7605_((Entity)mob, (byte)46);
        mob.m_9236_().m_214171_(GameEvent.f_238175_, mob.m_20182_(), GameEvent.Context.m_223717_((Entity)mob));
        if (!mob.m_20067_()) {
            mob.m_9236_().m_6263_(null, mob.f_19854_, mob.f_19855_, mob.f_19856_, SoundEvents.f_11852_, mob.m_5720_(), 1.0f, 1.0f);
            mob.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
        }
        return true;
    }

    @SerialClass
    public static class LaserAdder
    extends Ticker<YukariSpell> {
        @SerialClass.SerialField
        private Vec3 pos;
        @SerialClass.SerialField
        private Vec3 forward;

        @Override
        public boolean tick(CardHolder holder, YukariSpell card) {
            if (this.tick == 0) {
                this.forward = holder.forward();
                this.forward = this.forward.m_82542_(1.0, 0.5, 1.0).m_82541_();
                this.pos = holder.center();
            }
            DanmakuHelper.Orientation ori = DanmakuHelper.getOrientation(this.forward);
            RandomSource r = holder.random();
            this.addLaserBeams(holder, this.pos, ori.rotateDegrees(-45.0), 1.0 + (double)this.tick * 0.5, r.m_188500_(), DyeColor.RED);
            this.addLaserBeams(holder, this.pos, ori.rotateDegrees(45.0), 1.0 + (double)this.tick * 0.5, r.m_188500_(), DyeColor.BLUE);
            if (this.tick == 20) {
                this.shootGroup(holder, DyeColor.RED);
            }
            if (this.tick == 40) {
                this.shootGroup(holder, DyeColor.BLUE);
            }
            super.tick(holder, card);
            return this.tick > 120;
        }

        private void shootGroup(CardHolder holder, DyeColor color) {
            int lf;
            Vec3 vec;
            double sp;
            double d1;
            double d0;
            int i;
            double speed = 1.0;
            double dv = 0.5;
            double dev = 30.0;
            int n0 = 5;
            int n1 = 50;
            int life = 60;
            int dl = 20;
            Vec3 forward = holder.forward();
            RandomSource rand = holder.random();
            DanmakuHelper.Orientation ori = DanmakuHelper.getOrientation(forward);
            for (i = 0; i < n0; ++i) {
                d0 = (rand.m_188500_() * 2.0 - 1.0) * dev * (double)i / (double)n0;
                d1 = (rand.m_188500_() * 2.0 - 1.0) * dev * (double)i / (double)n0;
                sp = speed - dv / (double)n0 * (double)i;
                vec = ori.rotateDegrees(d0, d1).m_82490_(sp);
                lf = life + rand.m_188503_(dl);
                holder.shoot(holder.prepareDanmaku(lf, vec, YHDanmaku.Bullet.BUBBLE, color));
            }
            for (i = 0; i < n1; ++i) {
                d0 = (rand.m_188500_() * 2.0 - 1.0) * dev * (double)i / (double)n1;
                d1 = (rand.m_188500_() * 2.0 - 1.0) * dev * (double)i / (double)n1;
                sp = speed - dv / (double)n1 * (double)i;
                vec = ori.rotateDegrees(d0, d1).m_82490_(sp);
                lf = life + rand.m_188503_(dl);
                holder.shoot(holder.prepareDanmaku(lf, vec, YHDanmaku.Bullet.MENTOS, color));
            }
        }

        private void addLaserBeams(CardHolder holder, Vec3 pos, Vec3 dir, double step, double r, DyeColor color) {
            Vec3 p = pos.m_82549_(dir.m_82490_(step));
            Vec3 ori = DanmakuHelper.getOrientation(dir).rotate(1.5707963267948966, r * Math.PI * 2.0);
            holder.shoot(holder.prepareLaser(100, p, ori, 80.0f, YHDanmaku.Laser.LASER, color));
        }
    }

    @SerialClass
    public static class DelayedHidden
    extends Ticker<YukariSpell> {
        @SerialClass.SerialField
        public Vec3 pos = Vec3.f_82478_;

        @Override
        public boolean tick(CardHolder holder, YukariSpell card) {
            Vec3 target;
            if (this.tick == 0 && (target = holder.target()) != null) {
                card.hiddenImpl(holder, this.pos, target);
            }
            super.tick(holder, card);
            return this.tick > 0;
        }
    }
}

